@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('S.N.')</th>
                                    <th>@lang('Logo')</th>
                                    <th>@lang('Stock')</th>
                                    <th>@lang('Price')</th>
                                    <th>@lang('Change')</th>
                                    <th>@lang('Market Cap')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($stakings as $staking)
                                    <tr>
                                        <td>{{ $stakings->firstItem() + $loop->index }}</td>
                                        <td>
                                            <img src="{{ getImage(getFilePath('stock').'/'.$staking->logo) }}" alt="logo" style="width:40px;">
                                        </td>
                                        <td><strong>{{ $staking->symbol }}</strong></td>
                                        <td>{{ $staking->price }}</td>
                                        <td class="{{ str_contains($staking->pct_change, '+') ? 'text--success' : 'text--danger' }}">
                                            {{ $staking->pct_change }}
                                        </td>
                                        <td>{{ $staking->market_cap }}</td>
                                        <td>@php echo $staking->statusBadge; @endphp</td>
                                        <td>
                                            <div class="button--group">
                                                <button 
                                                    data-id="{{ $staking->id }}" 
                                                    data-symbol="{{ $staking->symbol }}" 
                                                    data-price="{{ $staking->price }}"
                                                    data-pct_change="{{ $staking->pct_change }}"
                                                    data-volume="{{ $staking->volume }}"
                                                    data-market_cap="{{ $staking->market_cap }}"
                                                    data-pe_ratio="{{ $staking->pe_ratio }}"
                                                    data-dividend_yield="{{ $staking->dividend_yield }}"
                                                    data-sector="{{ $staking->sector }}"
                                                    class="btn btn-outline--primary editBtn btn-sm"><i class="las la-pen"></i>@lang('Edit')</button>
                                                
                                                @if ($staking->status)
                                                    <button class="btn btn-sm btn-outline--danger confirmationBtn" data-question="@lang('Are you sure to disable this stock?')" data-action="{{ route('admin.staking.status', $staking->id) }}"><i class="las la-eye-slash"></i>@lang('Disable')</button>
                                                @else
                                                    <button class="btn btn-sm btn-outline--success confirmationBtn" data-question="@lang('Are you sure to enable this stock?')" data-action="{{ route('admin.staking.status', $staking->id) }}"><i class="las la-eye"></i>@lang('Enable')</button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($stakings->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($stakings) }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    {{-- Modal for Add/Edit --}}
    <div class="modal fade" id="stakingModal">
        <div class="modal-dialog modal-lg"> {{-- Wider modal for more fields --}}
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title"></h4>
                    <button type="button" class="close" data-bs-dismiss="modal"><span><i class="las la-times"></i></span></button>
                </div>
                <form method="post" enctype="multipart/form-data"> {{-- Added enctype for logo upload --}}
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Stock Symbol')</label>
                                    <input type="text" class="form-control" name="symbol" placeholder="e.g. NVDA" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Current Price')</label>
                                    <input type="number" step="any" class="form-control" name="price" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Percentage Change')</label>
                                    <input type="text" class="form-control" name="pct_change" placeholder="+1.02%">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Market Cap')</label>
                                    <input type="text" class="form-control" name="market_cap" placeholder="$4.68T">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Volume')</label>
                                    <input type="text" class="form-control" name="volume">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('P/E Ratio')</label>
                                    <input type="number" step="any" class="form-control" name="pe_ratio">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Sector')</label>
                                    <input type="text" class="form-control" name="sector">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Stock Logo')</label>
                                    <input type="file" class="form-control" name="logo" accept=".png, .jpg, .jpeg">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <button class="btn btn-outline--primary btn-sm addBtn"><i class="las la-plus"></i> @lang('Add New Stock')</button>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            let modal = $('#stakingModal');
            let action = `{{ route('admin.staking.save') }}`;

            $('.addBtn').on('click', function() {
                modal.find('.modal-title').text(`@lang('Add New Stock')`);
                modal.find('form').trigger('reset'); // Clear all inputs
                modal.find('form').attr('action', action);
                modal.modal('show');
            });

            $('.editBtn').on('click', function() {
                let data = $(this).data();
                modal.find('.modal-title').text(`@lang('Update Stock'): ` + data.symbol);
                
                // Map data attributes to input names
                modal.find('[name=symbol]').val(data.symbol);
                modal.find('[name=price]').val(data.price);
                modal.find('[name=pct_change]').val(data.pct_change);
                modal.find('[name=market_cap]').val(data.market_cap);
                modal.find('[name=volume]').val(data.volume);
                modal.find('[name=pe_ratio]').val(data.pe_ratio);
                modal.find('[name=sector]').val(data.sector);
                
                modal.find('form').attr('action', `${action}/${data.id}`);
                modal.modal('show');
            });

        })(jQuery);
    </script>
@endpush