@extends('Template::layouts.frontend')
@section('content')
    <div class="min-h-screen bg-white">
        <!-- Header / Progress (revamped) -->
        <header class="relative overflow-hidden bg-gradient-to-br from-black via-gray-900 to-black text-white">
            <svg class="absolute inset-0 opacity-[0.06] z-0 pointer-events-none" xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="none" aria-hidden="true" focusable="false">
                <defs>
                    <pattern id="grid" width="40" height="40" patternUnits="userSpaceOnUse">
                        <path d="M 40 0 L 0 0 0 40" fill="none" stroke="white" stroke-width="1" />
                    </pattern>
                </defs>
                <rect width="100%" height="100%" fill="url(#grid)" />
            </svg>
            <div class="absolute inset-0 z-0 pointer-events-none" aria-hidden="true">
                <img src="{{ getImage(getFilePath('inventory') . '/' . $car->image) }}" alt=""
                    class="h-full w-full object-cover opacity-20" loading="eager" decoding="async" />
                <div class="absolute inset-0 bg-gradient-to-b from-black/80 via-black/70 to-black/90"></div>
            </div>
            <div class="relative z-10">
                <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 py-8">
                    <div class="flex items-center justify-between">
                        <!-- Breadcrumb -->
                        <nav class="flex items-center space-x-2 text-sm text-gray-300" aria-label="Breadcrumb">
                            <a href="{{ url('/') }}" class="hover:text-white transition-colors">Home</a>
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                                aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                            </svg>
                            <a href="{{ route('car.details', $car->id) }}" class="hover:text-white transition-colors">Tesla
                                Model X</a>
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                                aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                            </svg>
                            <a href="#" class="hover:text-white transition-colors">Checkout</a>
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                                aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                            </svg>
                            <span class="text-white font-medium">Payment</span>
                        </nav>

                        <!-- Progress Steps -->
                        <ol class="hidden md:flex items-center space-x-4" aria-label="Progress">
                            <li class="flex items-center">
                                <span
                                    class="w-8 h-8 bg-white text-black rounded-full flex items-center justify-center text-sm font-medium">✓</span>
                                <span class="ml-2 text-sm font-medium text-white">Order Details</span>
                            </li>
                            <li class="w-8 h-px bg-white/30" aria-hidden="true"></li>
                            <li class="flex items-center">
                                <span
                                    class="w-8 h-8 bg-white text-black rounded-full flex items-center justify-center text-sm font-medium">2</span>
                                <span class="ml-2 text-sm text-white">Payment</span>
                            </li>
                            <li class="w-8 h-px bg-white/30" aria-hidden="true"></li>
                            <li class="flex items-center">
                                <span
                                    class="w-8 h-8 bg-white/10 text-white rounded-full flex items-center justify-center text-sm font-medium">3</span>
                                <span class="ml-2 text-sm text-gray-300">Confirmation</span>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </header>

        <!-- Payment Timer moved inside payment card header -->

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-16">
                <!-- Main Content -->
                <div class="lg:col-span-2 space-y-12">
                    <!-- Header with logo, title, and inline timer -->
                    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
                        <div class="text-center lg:text-left">
                            <h1 class="text-3xl sm:text-4xl font-light text-black mb-1">
                                Complete Your {{$method}} ({{$order->method}}) Payment
 
                            </h1>
                            <p class="text-gray-600 font-light">Send the exact amount to complete your purchase</p>
                        </div>
                        <div class="flex items-center justify-center lg:justify-end">
                            <div id="inline-timer-box"
                                class="flex items-center gap-3 bg-gray-50 border border-gray-200 px-4 py-2 rounded-lg">
                                <div class="w-8 h-8 bg-black text-white rounded flex items-center justify-center">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </div>
                                <div class="text-right min-w-[140px]">
                                    <div id="timer" class="text-xl sm:text-2xl font-light font-mono" aria-live="polite"
                                        role="status">30:00</div>
                                    <p class="text-xs text-gray-500 font-light leading-none">Time Remaining</p>
                                    <div class="mt-1 h-1 bg-gray-200 rounded overflow-hidden">
                                        <div id="timer-progress" class="h-1 bg-black rounded" style="width: 100%"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Payment Details Card -->
                    <div class="bg-white border border-gray-200 p-8 rounded-2xl shadow-sm">
                        <div class="flex items-center mb-10">
                            <img src="{{ asset('assets/frontend/storage/'.$order->method.'.png') }}"
                                alt="{{$order->method}}" class="w-12 h-12 object-contain mr-4">
                            <div>
                                <h3 class="text-xl font-medium text-black">{{$method}}</h3>
                                <p class="text-gray-600 font-light">{{$order->method}} Payment</p>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                            <!-- Amount Section -->
                            <div>
                                <label class="block text-sm font-medium text-black mb-4">Amount to Send</label>
                                <div class="bg-gray-50 border border-gray-200 p-6 rounded-xl">
                                    <div class="text-2xl font-light text-black mb-3">0.80000000 {{$order->method}}</div>
                                    <div class="text-sm text-gray-500 mb-4 font-light">≈ {{ showAmount($car->purchase) }}{{gs()->cur_text}}</div>
                                    <div class="text-xs text-orange-600 mb-4 font-light">+ 0.00005000 {{$order->method}} network fee</div>
                                    <button onclick="copyToClipboard('0.80000000')"
                                        class="text-sm text-black hover:text-gray-600 underline transition-colors duration-200">
                                        Copy Amount
                                    </button>
                                </div>
                            </div>

                            <!-- Wallet Address Section -->
                            <div>
                                <label class="block text-sm font-medium text-black mb-4">Wallet Address</label>
                                <div class="bg-gray-50 border border-gray-200 p-6 rounded-xl">
                                    <div class="flex items-center justify-between mb-4">
                                        <code
                                            class="text-sm font-mono text-black break-all pr-2">{{$wallet}}</code>
                                        <button onclick="copyToClipboard('{{$wallet}}')"
                                            class="flex-shrink-0 p-2 text-gray-500 hover:text-black hover:bg-gray-100 transition-all duration-200"
                                            title="Copy Address">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z" />
                                            </svg>
                                        </button>
                                    </div>
                                    <button onclick="copyToClipboard('{{$wallet}}')"
                                        class="text-sm text-black hover:text-gray-600 underline transition-colors duration-200">
                                        Copy Address
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- QR Code Section -->
                        <div class="mt-10">
                            <label class="block text-sm font-medium text-black mb-4">QR Code</label>
                            <div class="bg-gray-50 border border-gray-200 p-8 rounded-xl text-center">

                                <div class="relative inline-block">
                                    <img id="qr-code"
                                        src="https://api.qrserver.com/v1/create-qr-code/?size=200x200&amp;format=png&amp;data={{strToLower($order->method)}}%3A{{$wallet}}%3Famount%3D0.80000000"
                                        alt="Payment QR Code" class="mx-auto w-48 h-48 border border-gray-200"
                                        onerror="this.style.display='none'; document.getElementById('qr-fallback').style.display='block';">

                                    <div id="qr-fallback" style="display: none;"
                                        class="w-48 h-48 mx-auto bg-gray-100 border border-gray-200 flex items-center justify-center">
                                        <div class="text-center">
                                            <svg class="w-12 h-12 text-gray-400 mx-auto mb-2" fill="none"
                                                stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M12 4v1m6 11h2m-6 0h-2v4m0-11v3m0 0h.01M12 12h4.01M16 16h4.01M12 8h4.01M12 16h.01m0 0h3.99m-3.99 0v4" />
                                            </svg>
                                            <p class="text-xs text-gray-500">QR Code unavailable</p>
                                            <p class="text-xs text-gray-400 font-light">Use wallet address above</p>
                                        </div>
                                    </div>

                                    <button onclick="refreshQRCode()"
                                        class="absolute top-2 right-2 bg-white/90 hover:bg-white p-2 border border-gray-200 transition-all duration-200"
                                        title="Refresh QR Code">
                                        <svg class="w-4 h-4 text-gray-600" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                                        </svg>
                                    </button>
                                </div>

                                <div class="mt-8 space-y-2">
                                    <p class="text-sm text-gray-600 font-light">Scan with your {{$order->method}} wallet</p>
                                    <p class="text-xs text-gray-500 font-light">Amount: 0.80000000 {{$order->method}}</p>
                                    <button
                                        onclick="copyToClipboard('{{strToLower($order->method)}}:{{$wallet}}?amount=0.80000000')"
                                        class="text-sm text-black hover:text-gray-600 underline transition-colors duration-200">
                                        Copy Payment URI
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Payment Instructions -->
                    <div class="bg-white border border-gray-200 p-8 rounded-2xl shadow-sm">
                        <h3 class="text-xl font-medium text-black mb-10">Payment Instructions</h3>
                        <div class="space-y-8">
                            <div class="flex items-start">
                                <div
                                    class="w-8 h-8 bg-black text-white flex items-center justify-center text-sm font-medium mr-6 mt-0.5 flex-shrink-0">
                                    1</div>
                                <div>
                                    <h4 class="font-medium text-black mb-3">Open Your Wallet</h4>
                                    <p class="text-gray-600 font-light">Open your {{$order->method}} wallet app or scan the QR code above
                                    </p>
                                </div>
                            </div>
                            <div class="flex items-start">
                                <div
                                    class="w-8 h-8 bg-black text-white flex items-center justify-center text-sm font-medium mr-6 mt-0.5 flex-shrink-0">
                                    2</div>
                                <div>
                                    <h4 class="font-medium text-black mb-3">Send Exact Amount</h4>
                                    <p class="text-gray-600 font-light">Send exactly <strong>0.80000000 {{$order->method}}</strong> to the
                                        wallet address provided</p>
                                </div>
                            </div>
                            <div class="flex items-start">
                                <div
                                    class="w-8 h-8 bg-black text-white flex items-center justify-center text-sm font-medium mr-6 mt-0.5 flex-shrink-0">
                                    3</div>
                                <div>
                                    <h4 class="font-medium text-black mb-3">Get Transaction Hash</h4>
                                    <p class="text-gray-600 font-light">After sending, copy the transaction hash from your
                                        wallet</p>
                                </div>
                            </div>
                            <div class="flex items-start">
                                <div
                                    class="w-8 h-8 bg-black text-white flex items-center justify-center text-sm font-medium mr-6 mt-0.5 flex-shrink-0">
                                    4</div>
                                <div>
                                    <h4 class="font-medium text-black mb-3">Confirm Payment</h4>
                                    <p class="text-gray-600 font-light">Paste the transaction hash below to complete your
                                        purchase</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Transaction Hash Form -->
                    <div class="bg-white border border-gray-200 p-8 rounded-2xl shadow-sm">
                        <h3 class="text-xl font-medium text-black mb-10">Confirm Your Payment</h3>
                        <form action="" method="POST"
                            class="space-y-8" id="payment-form">
                            @csrf
                            <div>
                                <label for="transaction_hash"
                                    class="block text-sm font-medium text-black mb-4">Transaction Hash</label>
                                <input type="text" id="transaction_hash" name="transaction_hash" value=""
                                    class="w-full px-4 py-4 border border-gray-300 focus:outline-none focus:border-black font-mono text-sm transition-colors duration-200 "
                                    placeholder="Enter your transaction hash here..." required>
                                <p class="mt-3 text-xs text-gray-500 font-light">You can find this in your wallet after
                                    sending the payment</p>
                            </div>

                            <button type="submit"
                                class="w-full bg-black hover:bg-gray-800 text-white py-4 px-6 text-lg font-medium transition-colors duration-200 disabled:opacity-50 disabled:cursor-not-allowed"
                                id="confirm-button">
                                <span class="confirm-text">Confirm Payment</span>
                                <span class="loading-text hidden">Verifying...</span>
                            </button>
                        </form>
                    </div>

                    <!-- Important Notice -->
                    <div class="bg-red-50 border border-red-200 p-8 rounded-2xl">
                        <div class="flex items-start">
                            <svg class="w-6 h-6 text-red-600 mr-4 mt-0.5 flex-shrink-0" fill="none"
                                stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z" />
                            </svg>
                            <div>
                                <h4 class="font-medium text-red-900 mb-6">Important Notice</h4>
                                <ul class="text-sm text-red-800 space-y-4 font-light">
                                    <li class="flex items-start">
                                        <span class="w-1.5 h-1.5 bg-red-600 mt-2 mr-4 flex-shrink-0"></span>
                                        Send only {{$order->method}} to this address
                                    </li>
                                    <li class="flex items-start">
                                        <span class="w-1.5 h-1.5 bg-red-600 mt-2 mr-4 flex-shrink-0"></span>
                                        Double-check the amount and address before sending
                                    </li>
                                    <li class="flex items-start">
                                        <span class="w-1.5 h-1.5 bg-red-600 mt-2 mr-4 flex-shrink-0"></span>
                                        Cryptocurrency transactions are irreversible
                                    </li>
                                    <li class="flex items-start">
                                        <span class="w-1.5 h-1.5 bg-red-600 mt-2 mr-4 flex-shrink-0"></span>
                                        Your purchase will be processed after blockchain confirmation
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Order Summary Sidebar -->
                <div class="lg:col-span-1">
                    <div class="bg-white border border-gray-200 p-8 rounded-2xl shadow-sm sticky top-24">
                        <h2 class="text-xl font-medium text-black mb-10">Order Summary</h2>

                        <!-- Car Details -->
                        <div class="flex space-x-4 mb-10">
                            <div class="w-20 h-20 bg-gray-100 overflow-hidden flex-shrink-0">
                                <img src="https://www.tesinvspf.com/storage/cars/EUQThikjzOXRp484fkQmQxLyQkHLce7PEZiMTEO9.jpg"
                                    alt="Tesla Model X" class="w-full h-full object-cover">
                            </div>
                            <div class="flex-1">
                                <h3 class="font-medium text-black mb-2">Tesla Model X</h3>
                                <p class="text-sm text-gray-600 font-light">2021 Tesla Model X</p>
                                <p class="text-sm text-gray-600 font-light">White</p>
                            </div>
                        </div>

                        <!-- Payment Details -->
                        <div class="space-y-4 border-t border-gray-200 pt-10 mb-10">
                            <div class="flex justify-between text-sm">
                                <span class="text-gray-600">Vehicle Price</span>
                                <span class="font-medium text-black">$36,000.00</span>
                            </div>
                            <div class="flex justify-between text-sm">
                                <span class="text-gray-600">Payment Method</span>
                                <span class="font-medium text-black">{{$method}}</span>
                            </div>
                            <div class="flex justify-between text-sm">
                                <span class="text-gray-600">Crypto Amount</span>
                                <span class="font-medium text-black">0.80000000 {{$order->method}}</span>
                            </div>
                            <div class="flex justify-between text-sm">
                                <span class="text-gray-600">Network Fee</span>
                                <span class="font-medium text-orange-600">0.00005000 {{$order->method}}</span>
                            </div>
                            <div class="border-t border-gray-200 pt-6">
                                <div class="flex justify-between">
                                    <span class="text-lg font-medium text-black">Total (USD)</span>
                                    <span class="text-lg font-medium text-black">$36,000.00</span>
                                </div>
                            </div>
                        </div>

                        <!-- Status -->
                        <div class="p-8 bg-orange-50 border border-orange-200 mb-10">
                            <div class="flex items-center">
                                <svg class="w-5 h-5 text-orange-600 mr-2" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                <span class="text-sm font-medium text-orange-800">Payment Pending</span>
                            </div>
                            <p class="text-xs text-orange-700 mt-2 font-light">Complete your cryptocurrency payment to
                                proceed</p>
                        </div>

                        <!-- Security Features -->
                        <div class="space-y-4">
                            <div class="flex items-center space-x-3 text-sm text-gray-600">
                                <svg class="w-4 h-4 text-green-500" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                <span class="font-light">Blockchain Verified</span>
                            </div>
                            <div class="flex items-center space-x-3 text-sm text-gray-600">
                                <svg class="w-4 h-4 text-green-500" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                <span class="font-light">Secure Transaction</span>
                            </div>
                            <div class="flex items-center space-x-3 text-sm text-gray-600">
                                <svg class="w-4 h-4 text-green-500" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                <span class="font-light">Real-time Monitoring</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @push('script')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Timer variables
            let timeLeft = 30 * 60; // 30 minutes in seconds
            let timerInterval;
            let isTimerExpired = false;

            // Start timer
            function startTimer() {
                timerInterval = setInterval(function() {
                    if (timeLeft <= 0) {
                        clearInterval(timerInterval);
                        handleTimerExpired();
                        return;
                    }

                    updateTimerDisplay();
                    updateProgressBar();
                    timeLeft--;
                }, 1000);
            }

            function updateTimerDisplay() {
                const minutes = Math.floor(timeLeft / 60);
                const seconds = timeLeft % 60;
                const display = `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
                document.getElementById('timer').textContent = display;

                // Change color when time is running low (last 5 minutes)
                if (timeLeft <= 300) {
                    document.getElementById('timer').classList.add('animate-pulse');
                }
            }

            function updateProgressBar() {
                const bar = document.getElementById('timer-progress');
                if (!bar) {
                    return; // progress bar not present (e.g., timer layout changed)
                }
                const totalTime = 30 * 60;
                const progressPercentage = Math.max(0, Math.min(100, (timeLeft / totalTime) * 100));
                bar.style.width = progressPercentage + '%';
            }

            function handleTimerExpired() {
                isTimerExpired = true;
                document.getElementById('timer').textContent = '00:00';
                document.getElementById('timer-progress').style.width = '0%';

                // Show expiration message
                const timerBox = document.getElementById('inline-timer-box');
                if (timerBox) {
                    timerBox.classList.add('opacity-60');
                    const t = document.getElementById('timer');
                    if (t) t.textContent = '00:00';
                }

                // Disable the payment form
                const form = document.getElementById('payment-form');
                const submitButton = document.getElementById('confirm-button');
                submitButton.disabled = true;
                submitButton.textContent = 'Session Expired';
                submitButton.classList.add('opacity-50', 'cursor-not-allowed');
            }

            // Copy to clipboard function
            window.copyToClipboard = function(text) {
                if (isTimerExpired) {
                    alert('Payment session has expired. Please refresh the page.');
                    return;
                }

                navigator.clipboard.writeText(text).then(function() {
                    const button = event.target.closest('button');
                    const originalText = button.textContent;
                    const originalHTML = button.innerHTML;

                    if (button.querySelector('svg')) {
                        button.innerHTML =
                            '<svg class="w-4 h-4 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>';
                        setTimeout(() => {
                            button.innerHTML = originalHTML;
                        }, 2000);
                    } else {
                        button.textContent = 'Copied!';
                        button.classList.add('text-green-600');
                        setTimeout(() => {
                            button.textContent = originalText;
                            button.classList.remove('text-green-600');
                        }, 2000);
                    }
                }).catch(function(err) {
                    console.error('Could not copy text: ', err);
                    alert('Failed to copy to clipboard. Please copy manually.');
                });
            };

            // Refresh QR Code function
            window.refreshQRCode = function() {
                if (isTimerExpired) {
                    alert('Payment session has expired. Please refresh the page.');
                    return;
                }

                const qrImage = document.getElementById('qr-code');
                const qrFallback = document.getElementById('qr-fallback');

                qrImage.style.opacity = '0.5';

                const cryptoSymbol = '{{strToLower($order->method)}}';
                const walletAddress = '{{$wallet}}';
                const cryptoAmount = '0.80000000';
                const paymentUri = cryptoSymbol + ':' + walletAddress + '?amount=' + cryptoAmount;
                const timestamp = new Date().getTime();
                const newQrUrl = 'https://api.qrserver.com/v1/create-qr-code/?size=200x200&format=png&data=' +
                    encodeURIComponent(paymentUri) + '&t=' + timestamp;

                qrImage.onload = function() {
                    qrImage.style.opacity = '1';
                    qrFallback.style.display = 'none';
                    qrImage.style.display = 'block';
                };

                qrImage.onerror = function() {
                    qrImage.style.display = 'none';
                    qrFallback.style.display = 'block';
                };

                qrImage.src = newQrUrl;
            };

            // Form submission handling
            const form = document.getElementById('payment-form');
            const confirmButton = document.getElementById('confirm-button');

            form.addEventListener('submit', function(e) {
                if (isTimerExpired) {
                    e.preventDefault();
                    alert('Payment session has expired. Please refresh the page to start a new session.');
                    return;
                }

                const confirmText = confirmButton.querySelector('.confirm-text');
                const loadingText = confirmButton.querySelector('.loading-text');

                confirmText.classList.add('hidden');
                loadingText.classList.remove('hidden');
                confirmButton.disabled = true;
            });

            // Prevent leaving page warning
            window.addEventListener('beforeunload', function(e) {
                if (!isTimerExpired && timeLeft > 0) {
                    const message = 'Your payment session is still active. Are you sure you want to leave?';
                    e.returnValue = message;
                    return message;
                }
            });

            // Start the timer
            startTimer();
        });
    </script>
    @endpush
@endsection
