@extends('Template::layouts.frontend')
@section('content')
    @php
        $contactContent = getContent('contact.content', true);
        $contactElements = getContent('contact.element', null, false, true);
    @endphp
 <!-- ==================== Breadcrumb Start Here ==================== -->
            <section class="breadcrumb">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-lg-8">
                            <div class="breadcrumb__wrapper">
                                <h2 class="breadcrumb__title"> Support</h2>
                                <ul class="breadcrumb__list">
                                    <li class="breadcrumb__item"><a href="{{url('/')}}" class="breadcrumb__link"> <i
                                                class="las la-home"></i> Home</a> </li>
                                    <li class="breadcrumb__item"><i class="fa-solid fa-minus"></i></li>
                                    <li class="breadcrumb__item"> <span class="breadcrumb__item-text"> Support </span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- ==================== Breadcrumb End Here ==================== -->
            <!--==========================  Services Section Start  ==========================-->
            <section class="services-section bg--black py-120">
                <div class="container position-relative">
                    <div class="row justify-content-center">
                        <div class="col-xl-7 col-lg-8">
                            <div class="section-content text-center">
                                <h6 class="top-reveal">Support Anytime</h6>
                                <h2 class="top-reveal"> {{ __(@$contactContent->data_values->heading) }}</h2>
                                <p class="top-reveal"> {{ __(@$contactContent->data_values->sub_heading) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="row row-gap-4 mt-60 justify-content-center">
                        @foreach ($contactElements as $contactElement)

                        <div class="col-lg-4 col-md-6 bottom-reveal">
                            <div class="services-box">
                                <div class="icon">
                                    @php echo $contactElement->data_values->icon @endphp
                                </div>
                                <h3><a href="{{route('user.login')}}">{{ __(@$contactElement->data_values->title) }}</a></h3>
                                <p>{{ __(@$contactElement->data_values->content) }}</p>
                                <a href="{{route('user.login')}}" class="learn-more">Learn More <i
                                        class="flaticon-arrow-upper-right"></i></a>
                            </div>
                        </div>
                        @endforeach
                         
                    </div>

                    <form action="{{ route('contact') }}" method="post" class="contact-form verify-gcaptcha container-fluid p-0">
    @csrf
    
    <div class="row g-3 mb-4">
        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label fw-black text-uppercase text-muted small tracking-widest mb-1" style="font-size: 10px;">Full Name</label>
                <input type="text" name="name" 
                    class="form-control form-control-lg rounded-3 shadow-sm py-3 px-4 border-secondary-subtle" 
                    value="{{ old('name', @$user->fullname) }}" 
                    @if ($user && $user->profile_complete) readonly @endif 
                    required>
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label fw-black text-uppercase text-muted small tracking-widest mb-1" style="font-size: 10px;">Email Address</label>
                <input type="email" name="email" 
                    class="form-control form-control-lg rounded-3 shadow-sm py-3 px-4 border-secondary-subtle" 
                    value="{{ old('email', @$user->email) }}" 
                    @if ($user) readonly @endif 
                    required>
            </div>
        </div>
    </div>

    <div class="mb-4">
        <label class="form-label fw-black text-uppercase text-muted small tracking-widest mb-1" style="font-size: 10px;">Subject</label>
        <input type="text" name="subject" 
            class="form-control form-control-lg rounded-3 shadow-sm py-3 px-4 border-secondary-subtle" 
            required>
    </div>

    <div class="mb-4">
        <label class="form-label fw-black text-uppercase text-muted small tracking-widest mb-1" style="font-size: 10px;">Message Terminal</label>
        <textarea name="message" 
            class="form-control form-control-lg rounded-3 shadow-sm py-3 px-4 border-secondary-subtle" 
            rows="5" 
            required></textarea>
    </div>

    <div class="mb-4">
        <x-captcha />
    </div>

    <div class="d-grid">
        <button type="submit" class="btn btn-dark btn-lg py-3 rounded-3 fw-bold text-uppercase tracking-widest shadow">
            Execute Transmission
        </button>
    </div>
</form>
                </div>
            </section>
            <!--==========================  Services Section End  ==========================-->
            

     
@endsection