<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title> {{ gs()->siteName(__($pageTitle)) }}</title>
    @include('partials.seo')
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:300,400,500,600,700&display=swap" rel="stylesheet" />

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js" onload="console.log('Lucide loaded')"
        onerror="console.error('Failed to load Lucide')"></script>
    <style></style>
    <!-- Scripts -->
    <link rel="preload" as="style" href="{{ asset('assets/frontend/build/assets/app-Cf1VUFo0.css') }}" />
    <link rel="modulepreload" as="script" href="{{ asset('assets/frontend/build/assets/app-C7QjXGVt.js') }}" />
    <link rel="stylesheet" href="{{ asset('assets/frontend/build/assets/app-Cf1VUFo0.css') }}" />
    <script type="module" src="{{ asset('assets/frontend/build/assets/app-C7QjXGVt.js') }}"></script>
    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('sidebar-overlay');
            const isOpen = sidebar.classList.contains('translate-x-0');

            if (isOpen) {
                sidebar.classList.remove('translate-x-0');
                sidebar.classList.add('-translate-x-full');
                overlay.classList.add('hidden');
            } else {
                sidebar.classList.remove('-translate-x-full');
                sidebar.classList.add('translate-x-0');
                overlay.classList.remove('hidden');
            }
        }
    </script>
</head>

<body class="font-sans antialiased bg-white">
    <div class="min-h-screen flex">
        <!-- Mobile Sidebar Overlay -->
        <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-[9998] lg:hidden hidden"
            onclick="toggleSidebar()"></div>

        <!-- Enhanced Sidebar -->
        <div id="sidebar"
            class="fixed inset-y-0 left-0 z-[9999] w-72 bg-black shadow-2xl transform -translate-x-full transition-transform duration-300 ease-in-out lg:translate-x-0">
            <div class="flex flex-col h-full">
                <!-- Enhanced Logo Section -->
                <div class="flex items-center justify-between h-16 px-6 border-b border-gray-800">
                    <div class="flex items-center">
                        <img src="{{ siteLogo() }}" alt="Tesla Investments Platform"
                            class="h-6 w-auto mr-3 filter brightness-0 invert">
                    </div>
                    <button onclick="toggleSidebar()"
                        class="lg:hidden text-gray-400 hover:text-white p-1.5 rounded-md hover:bg-gray-800">
                        <i data-lucide="x" class="w-4 h-4"></i>
                    </button>
                </div>

                <!-- Enhanced User Profile Section -->
                <div class="px-6 py-4 border-b border-gray-800">
                    <div class="flex items-center space-x-3">
                        <div class="relative">
                            <div
                                class="w-12 h-12 bg-gradient-to-br from-blue-400 to-blue-600 rounded-xl flex items-center justify-center">
                                <span class="text-white font-medium text-sm">C</span>
                            </div>
                            <!-- KYC Status Badge -->
                        </div>

                        <div class="flex-1 min-w-0">
                            <p class="text-sm font-medium text-white truncate">{{ auth()->user()->fullname }}</p>
                            <p class="text-xs text-gray-400 truncate">{{ auth()->user()->email }}</p>

                            <div class="flex items-center mt-1">
                                <span
                                    class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-gray-900 text-gray-300">
                                    <i data-lucide="user" class="w-3 h-3 mr-1"></i>
                                    KYC @if (auth()->user()->kv == Status::KYC_PENDING)
                                        Not
                                    @endif Submitted
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Enhanced Navigation -->
                <nav class="flex-1 px-4 py-4 space-y-1 overflow-y-auto">
                    <!-- Dashboard -->
                    <a href="{{ route('user.home') }}"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 bg-white text-black">
                        <i data-lucide="layout-dashboard" class="w-4 h-4 mr-3 text-black"></i>
                        <span>Dashboard</span>
                    </a>

                    <!-- Wallet -->
                    <a href="{{ route('user.wallet') }}"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-gray-300 hover:bg-gray-800 hover:text-white">
                        <i data-lucide="wallet" class="w-4 h-4 mr-3 text-gray-400"></i>
                        <span>Wallet</span>
                    </a>

                    <!-- Investments -->
                    <a href="{{ route('user.invest.plan') }}"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-gray-300 hover:bg-gray-800 hover:text-white">
                        <i data-lucide="trending-up" class="w-4 h-4 mr-3 text-gray-400"></i>
                        <span>Investments</span>
                    </a>
                    @if(gs('staking_option'))
                    <!-- Stocks -->
                    <a href="{{ route('user.stock.index') }}"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-gray-300 hover:bg-gray-800 hover:text-white">
                        <i data-lucide="bar-chart-3" class="w-4 h-4 mr-3 text-gray-400"></i>
                        <span>Stocks</span>
                    </a>
                    @endif

                    <!-- Portfolio -->
                    <a href="{{ route('user.invest.portfolio') }}"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-gray-300 hover:bg-gray-800 hover:text-white">
                        <i data-lucide="pie-chart" class="w-4 h-4 mr-3 text-gray-400"></i>
                        <span>Portfolio</span>
                    </a>

                    <!-- Investment Dashboard -->
                    <a href="{{ route('user.invest.statistics') }}"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-gray-300 hover:bg-gray-800 hover:text-white">
                        <i data-lucide="bar-chart-3" class="w-4 h-4 mr-3 text-gray-400"></i>
                        <span>Investment Dashboard</span>
                    </a>

                    <!-- Browse Cars -->
                    <a href="{{ route('cars') }}"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-gray-300 hover:bg-gray-800 hover:text-white">
                        <i data-lucide="car" class="w-4 h-4 mr-3 text-gray-400"></i>
                        <span>Inventory</span>
                    </a>

                    <!-- Purchase History -->
                    <a href="{{ route('user.order') }}"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-gray-300 hover:bg-gray-800 hover:text-white">
                        <i data-lucide="receipt" class="w-4 h-4 mr-3 text-gray-400"></i>
                        <span>Orders</span>
                    </a>

                    <!-- Profile -->
                    <a href="{{ route('user.profile.setting') }}"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-gray-300 hover:bg-gray-800 hover:text-white">
                        <i data-lucide="user" class="w-4 h-4 mr-3 text-gray-400"></i>
                        <span>Account</span>
                    </a>

                    <!-- KYC Verification -->
                    <a href="{{ route('user.kyc.form') }}"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-gray-300 hover:bg-gray-800 hover:text-white">
                        <i data-lucide="shield-check" class="w-4 h-4 mr-3 text-gray-400"></i>
                        <span>KYC Verification</span>
                    </a>

                    <!-- Divider -->
                    <div class="border-t border-gray-800 pt-4 mt-4">
                        <!-- Support -->
                        <a href="{{ route('ticket.index') }}"
                            class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg text-gray-300 hover:bg-gray-800 hover:text-white transition-all duration-200">
                            <i data-lucide="help-circle" class="w-4 h-4 mr-3 text-gray-400"></i>
                            <span>Support</span>
                        </a>
                    </div>
                </nav>

                <!-- Enhanced User Menu -->
                <div class="p-4 border-t border-gray-800">
                    <div class="flex items-center justify-between">
                        <span class="text-sm font-medium text-gray-300">Logout</span>
                        <form method="POST" action="{{ route('user.logout') }}" class="inline">
                            <input type="hidden" name="_token" value="5k20KbOPIXIlEMGFIn1VwlwuS4WiK9x4vhYjb6Mz"
                                autocomplete="off"> <button type="submit"
                                class="flex items-center text-sm font-medium text-red-400 hover:text-red-300 transition-colors p-2 rounded-lg hover:bg-gray-800"
                                title="Sign Out">
                                <i data-lucide="log-out" class="w-4 h-4"></i>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col overflow-hidden lg:ml-72">
            <!-- Enhanced Top Bar -->
            <header class="bg-white border-b border-gray-200">
                <div class="flex items-center justify-between px-6 py-3">
                    <div class="flex items-center">
                        <button onclick="toggleSidebar()"
                            class="lg:hidden text-gray-500 hover:text-gray-700 p-1.5 rounded-md hover:bg-gray-100 mr-3">
                            <i data-lucide="menu" class="w-5 h-5"></i>
                        </button>
                        <div class="font-light text-lg text-black">
                            {{ @$pageTitle ?? 'Dashboard' }}
                        </div>
                    </div>

                    <!-- Enhanced Right side with notifications -->
                    <div class="flex items-center space-x-3">
                        <!-- Impersonation Stop Button -->

                        <!-- Notifications -->
                        <div class="relative">
                            <button onclick="toggleNotifications()"
                                class="relative p-2 text-gray-500 hover:text-gray-700 rounded-md hover:bg-gray-100">
                                <i data-lucide="bell" class="w-5 h-5"></i>
                                <!-- Notification badge -->
                                <span id="notification-badge"
                                    class="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full h-4 w-4 flex items-center justify-center hidden">0</span>
                            </button>
                            @php
                                $notifyme = \App\Models\SupportTicket::where('user_id', auth()->id())
                                    ->latest()
                                    ->whereStatus(1)
                                    ->take(5)
                                    ->get();
                            @endphp
                            <!-- Enhanced Notifications Dropdown -->
                            <div id="notifications-dropdown"
                                class="hidden absolute right-0 mt-2 w-80 bg-white rounded-lg shadow-lg border border-gray-200 z-50">
                                <div class="p-3 border-b border-gray-200">
                                    <div class="flex items-center justify-between">
                                        <h3 class="text-sm font-medium text-black">Notifications</h3>
                                        <button onclick="markAllNotificationsAsRead()"
                                            class="text-xs text-gray-500 hover:text-gray-700">Mark all read</button>
                                    </div>
                                </div>
                                <div id="notifications-list" class="max-h-64 overflow-y-auto">
                                    <!-- Notifications will be loaded here dynamically -->
                                    <div class="p-3 text-center">
                                        <div
                                            class="w-6 h-6 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-2">
                                            <i data-lucide="loader-2" class="w-3 h-3 text-gray-400 animate-spin"></i>
                                        </div>
                                        <p class="text-xs text-gray-500">Loading notifications...</p>
                                    </div>
                                </div>
                                <div class="p-3 border-t border-gray-200">
                                    <a href="{{ route('ticket.index') }}"
                                        class="text-xs text-black hover:text-gray-600 font-medium">View all
                                        notifications</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Enhanced Flash Messages -->


            <main class="flex-1 overflow-y-auto p-6 bg-white pb-20 lg:pb-6">
                @yield('content')
            </main>

            <!-- Enhanced Mobile Bottom Navigation -->
        <div class="fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 lg:hidden z-50 shadow-2xl">
            <div class="flex justify-around px-3 py-2">
                <!-- Dashboard -->
                <a href="{{route('user.home')}}" class="flex flex-col items-center py-1.5 px-3 rounded-xl transition-all duration-300 text-gray-500 hover:text-blue-600 hover:bg-blue-50">
                    <div class="relative">
                        <i data-lucide="layout-dashboard" class="w-5 h-5 mb-1"></i>
                                            </div>
                    <span class="text-xs font-semibold">Home</span>
                </a>

                <!-- Wallet -->
                <a href="{{route('user.wallet')}}" class="flex flex-col items-center py-1.5 px-3 rounded-xl transition-all duration-300 text-gray-500 hover:text-green-600 hover:bg-green-50">
                    <div class="relative">
                        <i data-lucide="wallet" class="w-5 h-5 mb-1"></i>
                                            </div>
                    <span class="text-xs font-semibold">Wallet</span>
                </a>

                <!-- Investments -->
                <a href="{{route('user.invest.plan')}}" class="flex flex-col items-center py-1.5 px-3 rounded-xl transition-all duration-300 text-gray-500 hover:text-purple-600 hover:bg-purple-50">
                    <div class="relative">
                        <i data-lucide="trending-up" class="w-5 h-5 mb-1"></i>
                                            </div>
                    <span class="text-xs font-semibold">Invest</span>
                </a>

                <!-- Stocks -->
                <a href="{{route('user.stock.index')}}" class="flex flex-col items-center py-1.5 px-3 rounded-xl transition-all duration-300 text-white bg-gradient-to-br from-orange-500 to-orange-600 shadow-lg scale-105">
                    <div class="relative">
                        <i data-lucide="bar-chart-3" class="w-5 h-5 mb-1"></i>
                                                    <div class="absolute -top-1 -right-1 w-1.5 h-1.5 bg-white rounded-full"></div>
                                            </div>
                    <span class="text-xs font-semibold">Stocks</span>
                </a>

                <!-- Portfolio -->
                <a href="{{route('user.invest.portfolio')}}" class="flex flex-col items-center py-1.5 px-3 rounded-xl transition-all duration-300 text-gray-500 hover:text-red-600 hover:bg-red-50">
                    <div class="relative">
                        <i data-lucide="pie-chart" class="w-5 h-5 mb-1"></i>
                                            </div>
                    <span class="text-xs font-semibold">Portfolio</span>
                </a>
            </div>
        </div>

            <!-- Google Translate Widget -->
            <div id="google_translate_element"></div>
            <script type="text/javascript">
                function googleTranslateElementInit() {
                    new google.translate.TranslateElement({
                        pageLanguage: 'en',
                        layout: google.translate.TranslateElement.InlineLayout.HORIZONTAL,
                        autoDisplay: false
                    }, 'google_translate_element');
                }
            </script>
            <script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit">
            </script>
            <style>
                /* Container style - transparent and top-right */
                #google_translate_element {
                    position: fixed;
                    top: 20px;
                    right: 20px;
                    z-index: 9999;
                    background: rgba(255, 255, 255, 0.1);
                    /* Almost transparent */
                    border-radius: 6px;
                    padding: 6px 8px;
                    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
                    /* Subtle shadow */
                    max-width: 160px;
                    font-size: 14px;
                    opacity: 0.2;
                    /* Very faint */
                    transition: opacity 0.3s ease, background 0.3s ease;
                }

                /* Show on hover */
                #google_translate_element:hover {
                    opacity: 1;
                    background: #ffffff;
                    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.2);
                }

                /* Style the select dropdown */
                #google_translate_element select {
                    padding: 4px;
                    border-radius: 4px;
                    border: 1px solid #ccc;
                    width: 100%;
                    box-sizing: border-box;
                }

                /* Responsive adjustment */
                @media (max-width: 600px) {
                    #google_translate_element {
                        top: 10px;
                        right: 10px;
                        width: 140px;
                        padding: 4px 6px;
                    }

                    #google_translate_element select {
                        font-size: 13px;
                    }
                }
            </style>

            <script>
                // Close dropdowns when clicking outside
                document.addEventListener('click', function(event) {
                    const notificationsDropdown = document.getElementById('notifications-dropdown');

                    if (!event.target.closest('#notifications-dropdown') && !event.target.closest(
                            'button[onclick="toggleNotifications()"]')) {
                        notificationsDropdown.classList.add('hidden');
                    }
                });

                function toggleNotifications() {
                    const dropdown = document.getElementById('notifications-dropdown');
                    dropdown.classList.toggle('hidden');

                    if (!dropdown.classList.contains('hidden')) {
                        loadNotifications();
                    }
                }

                function markAllNotificationsAsRead() {
                    fetch('', {
                            method: 'PATCH',
                            headers: {
                                'X-CSRF-TOKEN': '5k20KbOPIXIlEMGFIn1VwlwuS4WiK9x4vhYjb6Mz',
                                'Content-Type': 'application/json',
                            },
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                loadNotifications();
                                updateNotificationBadge();
                            }
                        })
                        .catch(error => console.error('Error:', error));
                }

                function loadNotifications() {
                    fetch('')
                        .then(response => response.json())
                        .then(data => {
                            const notificationsList = document.getElementById('notifications-list');

                            if (data.notifications.length === 0) {
                                notificationsList.innerHTML = `
                            <div class="p-3 text-center">
                                <div class="w-6 h-6 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-2">
                                    <i data-lucide="bell" class="w-3 h-3 text-gray-400"></i>
                                </div>
                                <p class="text-xs text-gray-500">No notifications</p>
                            </div>
                        `;
                            } else {
                                notificationsList.innerHTML = data.notifications.map(notification => `
                            <div class="p-3 border-b border-gray-100 hover:bg-gray-50 ${notification.is_read ? 'opacity-60' : ''}">
                                <div class="flex items-start">
                                    <div class="w-6 h-6 bg-${notification.color}-500 rounded-full flex items-center justify-center mr-3 flex-shrink-0">
                                        <i data-lucide="${notification.icon}" class="w-3 h-3 text-white"></i>
                                    </div>
                                    <div class="flex-1 min-w-0">
                                        <p class="text-xs font-medium text-black">${notification.title}</p>
                                        <p class="text-xs text-gray-500">${notification.message}</p>
                                        <p class="text-xs text-gray-400 mt-1">${notification.formatted_time}</p>
                                    </div>
                                </div>
                            </div>
                        `).join('');
                            }

                            // Re-initialize Lucide icons for new content
                            lucide.createIcons();
                        })
                        .catch(error => {
                            console.error('Error loading notifications:', error);
                            const notificationsList = document.getElementById('notifications-list');
                            notificationsList.innerHTML = `
                        <div class="p-3 text-center">
                            <div class="w-6 h-6 bg-red-100 rounded-full flex items-center justify-center mx-auto mb-2">
                                <i data-lucide="alert-circle" class="w-3 h-3 text-red-400"></i>
                            </div>
                            <p class="text-xs text-red-500">Failed to load notifications</p>
                        </div>
                    `;
                            lucide.createIcons();
                        });
                }

                function updateNotificationBadge() {
                    fetch('')
                        .then(response => response.json())
                        .then(data => {
                            const badge = document.getElementById('notification-badge');
                            if (data.count > 0) {
                                badge.textContent = data.count;
                                badge.classList.remove('hidden');
                            } else {
                                badge.classList.add('hidden');
                            }
                        })
                        .catch(error => console.error('Error updating badge:', error));
                }

                // Load notifications and update badge on page load
                document.addEventListener('DOMContentLoaded', function() {
                    // Initialize Lucide icons first
                    if (typeof lucide !== 'undefined') {
                        lucide.createIcons();
                    } else {
                        console.error('Lucide icons library not loaded');
                    }

                    loadNotifications();
                    updateNotificationBadge();

                    // Update every 30 seconds
                    setInterval(() => {
                        updateNotificationBadge();
                    }, 30000);
                });

                // Also initialize icons immediately if DOM is already loaded
                if (document.readyState === 'loading') {
                    // Document is still loading, wait for DOMContentLoaded
                } else {
                    // Document is already loaded, initialize icons now
                    if (typeof lucide !== 'undefined') {
                        lucide.createIcons();
                    }
                }
            </script>

            <!-- Real-time Stock Updates -->
            <link rel="stylesheet" href="https://www.tesinvspf.com/css/stock-animations.css">
            <script src="https://www.tesinvspf.com/js/stock-updates.js"></script>
            <script src="https://www.tesinvspf.com/js/market-overview.js"></script>
            <script src="https://www.tesinvspf.com/js/portfolio-updates.js"></script>

            <!-- Debug Icons (temporary) -->
            <script src="https://www.tesinvspf.com/js/debug-icons.js"></script>

            <!-- Live Chat Widget -->
            <div id="live-chat-widget" class="fixed bottom-4 right-4 z-[10000]" style="">
                <!-- Smartsupp Live Chat script -->
                <script type="text/javascript">
                    var _smartsupp = _smartsupp || {};
                    _smartsupp.key = '5e6d3682e26f929d5fcc70ccbcd471a4c329061b';
                    window.smartsupp || (function(d) {
                        var s, c, o = smartsupp = function() {
                            o._.push(arguments)
                        };
                        o._ = [];
                        s = d.getElementsByTagName('script')[0];
                        c = d.createElement('script');
                        c.type = 'text/javascript';
                        c.charset = 'utf-8';
                        c.async = true;
                        c.src = 'https://www.smartsuppchat.com/loader.js?';
                        s.parentNode.insertBefore(c, s);
                    })(document);
                </script>
                <noscript> Powered by <a href=“https://www.smartsupp.com” target=“_blank”>Smartsupp</a></noscript>
            </div>

            <!-- Chat Widget Styles -->
            <style>
                #live-chat-widget {
                    max-width: 400px;
                }

                #live-chat-widget iframe {
                    border: none;
                    border-radius: 8px;
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                }

                #live-chat-widget .chat-widget {
                    border-radius: 8px;
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                }

                /* Ensure chat widget is above all navigation elements */
                #live-chat-widget {
                    z-index: 10000 !important;
                }

                /* Adjust positioning to avoid navigation conflicts */
                #live-chat-widget.fixed.bottom-4.right-4 {
                    bottom: 80px !important;
                    /* Move up to avoid mobile navigation */
                }

                #live-chat-widget.fixed.bottom-4.left-4 {
                    bottom: 80px !important;
                    /* Move up to avoid mobile navigation */
                }

                /* Responsive adjustments */
                @media (max-width: 768px) {
                    #live-chat-widget {
                        max-width: 100%;
                        margin: 0 16px;
                    }

                    #live-chat-widget.fixed.bottom-4.right-4,
                    #live-chat-widget.fixed.bottom-4.left-4 {
                        bottom: 80px !important;
                        /* Move up to avoid mobile navigation */
                        right: 16px;
                        left: auto;
                    }

                    #live-chat-widget.fixed.top-4.right-4,
                    #live-chat-widget.fixed.top-4.left-4 {
                        top: 16px;
                        right: 16px;
                        left: auto;
                    }
                }
            </style>

            @stack('script-lib')
            @php echo loadExtension('tawk-chat') @endphp
            @include('partials.notify')

            @if (gs('pn'))
                @include('partials.push_script')
            @endif
            @stack('script')
</body>

</html>
