 @extends('Template::layouts.auth')
 @section('content')
     @php
         $loginContent = getContent('login.content', true);
     @endphp
     <div class="w-full max-w-sm">
         <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
             <!-- Enhanced Header -->
             <div class="px-6 py-6 text-center">
                 <h1 class="text-xl font-light text-black mb-1">Sign In</h1>
                 <p class="text-xs text-gray-500">Access your Tesla Drives account</p>
             </div>

             <!-- Session Status -->

             <!-- Login Form -->
             <div class="px-6 pb-6">
                 <form method="POST" action="{{ route('user.login') }}" class="space-y-4">
                     @csrf
                     <!-- Email Address -->
                     <div>
                         <label for="email" class="block text-xs font-medium text-black mb-1">Email</label>
                         <input type="email" id="email" name="username" value="" required autofocus
                             autocomplete="username"
                             class="w-full px-3 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200 ">
                     </div>

                     <!-- Password -->
                     <div>
                         <div class="flex items-center justify-between mb-1">
                             <label for="password" class="block text-xs font-medium text-black">Password</label>
                             <a href="{{ route('user.password.request') }}"
                                 class="text-xs text-gray-500 hover:text-black transition-colors duration-200">
                                 Forgot password?
                             </a>
                         </div>
                         <div class="relative">
                             <input type="password" id="password" name="password" required autocomplete="current-password"
                                 class="w-full px-3 py-2.5 pr-10 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200 ">
                             <button type="button" onclick="togglePassword()"
                                 class="absolute inset-y-0 right-0 flex items-center pr-3 text-gray-400 hover:text-gray-600 transition-colors">
                                 <svg id="password-show-icon" class="w-4 h-4" fill="none" stroke="currentColor"
                                     viewBox="0 0 24 24">
                                     <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                         d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                     <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                         d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z">
                                     </path>
                                 </svg>
                                 <svg id="password-hide-icon" class="w-4 h-4 hidden" fill="none" stroke="currentColor"
                                     viewBox="0 0 24 24">
                                     <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                         d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.878 9.878L3 3m6.878 6.878L21 21">
                                     </path>
                                 </svg>
                             </button>
                         </div>
                     </div>

                     <!-- Remember Me -->
                     <div class="flex items-center">
                         <input type="checkbox" id="remember_me" name="remember"
                             class="w-3.5 h-3.5 text-black border-gray-300 rounded focus:ring-black">
                         <label for="remember_me" class="ml-2 text-xs text-gray-600">
                             Remember me
                         </label>
                     </div>

                     <!-- Submit Button -->
                     <div class="pt-2">
                         <button type="submit"
                             class="w-full bg-black hover:bg-gray-800 text-white py-2.5 px-4 rounded-lg text-sm font-medium transition-all duration-200">
                             Sign In
                         </button>
                     </div>
                 </form>
             </div>

             <!-- Registration Link -->
             <div class="px-6 py-4 bg-gray-50 border-t border-gray-100 text-center">
                 <p class="text-xs text-gray-500">
                     Don't have an account?
                     <a href="{{ route('user.register') }}"
                         class="text-black hover:text-gray-600 font-medium transition-colors duration-200">
                         Create account
                     </a>
                 </p>
             </div>
         </div>

         @if (@gs('socialite_credentials')->google->status == Status::ENABLE)
         <!-- Alternative Sign In -->
         <div class="mt-6">
             <div class="relative">
                 <div class="absolute inset-0 flex items-center">
                     <div class="w-full border-t border-gray-200"></div>
                 </div>
                 <div class="relative flex justify-center text-xs">
                     <span class="px-3 bg-gray-50 text-gray-500">Or continue with</span>
                 </div>
             </div>
             
                 <div class="mt-4 flex justify-center">
                     <a href="{{ route('user.social.login', 'google') }}"
                         class="inline-flex items-center justify-center px-3 py-2 border border-gray-300 rounded-lg shadow-sm bg-white text-xs font-medium text-gray-700 hover:bg-gray-50 transition-colors duration-200">
                         <svg class="h-4 w-4 mr-2" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                             <path
                                 d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"
                                 fill="#4285F4" />
                             <path
                                 d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"
                                 fill="#34A853" />
                             <path
                                 d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"
                                 fill="#FBBC05" />
                             <path
                                 d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"
                                 fill="#EA4335" />
                         </svg>
                         Continue with Google
                     </a>
                 </div>
         </div>

             @endif

         <!-- Security Notice -->
         <div class="mt-6 text-center">
             <div class="flex items-center justify-center text-gray-400 text-xs">
                 <i data-lucide="shield" class="w-3 h-3 mr-1"></i>
                 Secure login protected by SSL encryption
             </div>
         </div>

         <script>
             function togglePassword() {
                 const passwordInput = document.getElementById('password');
                 const showIcon = document.getElementById('password-show-icon');
                 const hideIcon = document.getElementById('password-hide-icon');

                 if (passwordInput.type === 'password') {
                     passwordInput.type = 'text';
                     showIcon.classList.add('hidden');
                     hideIcon.classList.remove('hidden');
                 } else {
                     passwordInput.type = 'password';
                     showIcon.classList.remove('hidden');
                     hideIcon.classList.add('hidden');
                 }
             }
         </script>
     </div>
 @endsection
