@extends('Template::layouts.master')
@section('content')
<div style="padding: 1rem; margin-left: auto; margin-right: auto; max-width: 1400px;">
    
    <div style="display: grid; grid-template-columns: repeat(12, 1fr); gap: 1.5rem; margin-bottom: 2.5rem;">
        
        <div style="grid-column: span 12; @media (min-width: 1024px) { grid-column: span 5; }; display: flex; flex-direction: column; gap: 1.5rem;">
            
            <div style="position: relative; overflow: hidden; border: 1px solid rgba(0,0,0,0.1); background-color: #ffffff; border-radius: 0.75rem; padding: 1.5rem; box-shadow: 0 1px 2px rgba(0,0,0,0.05);">
                <div style="position: absolute; top: 0; right: 0; padding: 1rem; opacity: 0.1;">
                    <i data-lucide="bar-chart-big" style="width: 4rem; height: 4rem;"></i>
                </div>
                <p style="font-size: 10px; font-weight: 900; color: #94a3b8; text-transform: uppercase; letter-spacing: 0.2em; margin-bottom: 0.25rem;">@lang('Active Deployment')</p>
                <h3 style="font-size: 1.875rem; font-weight: 900; color: #0f172a; letter-spacing: -0.05em; margin: 0;">
                    <span style="font-size: 0.875rem; font-weight: 700; color: #94a3b8; margin-right: 0.25rem;">{{ gs('cur_sym') }}</span>{{ showAmount(auth()->user()->invests->sum('amount'), currencyFormat:false) }}
                </h3>
                <div style="margin-top: 1rem; display: flex; gap: 0.5rem;">
                    <a href="{{ route('plan') }}" style="text-decoration: none; font-size: 10px; font-weight: 900; text-transform: uppercase; color: #10b981; display: flex; align-items: center; gap: 0.25rem;">
                        @lang('Increase Stake') <i data-lucide="arrow-up-right" style="width: 12px; height: 12px;"></i>
                    </a>
                </div>
            </div>

            <div style="position: relative; overflow: hidden; border: 1px solid rgba(255,255,255,0.1); background-color: #0f172a; border-radius: 0.75rem; padding: 1.5rem; box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1);">
                <p style="font-size: 10px; font-weight: 900; color: #64748b; text-transform: uppercase; letter-spacing: 0.2em; margin-bottom: 0.25rem;">@lang('Net Yield Generated')</p>
                <h3 style="font-size: 1.875rem; font-weight: 900; color: #ffffff; letter-spacing: -0.05em; margin: 0;">
                    <span style="font-size: 0.875rem; font-weight: 700; opacity: 0.5; margin-right: 0.25rem;">{{ gs('cur_sym') }}</span>{{ showAmount(auth()->user()->transactions()->where('remark', 'interest')->sum('amount'), currencyFormat:false) }}
                </h3>
                <div style="margin-top: 1rem;">
                    <a href="{{ route('user.withdraw') }}" style="text-decoration: none; display: inline-block; padding: 0.5rem 1rem; border-radius: 0.5rem; background-color: #10b981; color: #ffffff; font-size: 10px; font-weight: 900; text-transform: uppercase; letter-spacing: 0.1em;">
                        @lang('Withdraw Profit')
                    </a>
                </div>
            </div>
        </div>

        <div style="grid-column: span 12; @media (min-width: 1024px) { grid-column: span 7; };">
            <div style="height: 100%; border: 1px solid rgba(0,0,0,0.1); background-color: #ffffff; border-radius: 0.75rem; padding: 2rem; display: flex; flex-direction: column;">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
                    <h4 style="font-size: 10px; font-weight: 900; color: #94a3b8; text-transform: uppercase; letter-spacing: 0.2em; margin: 0;">@lang('Asset Distribution')</h4>
                    <div style="padding: 0.25rem 0.75rem; background-color: #f1f5f9; border-radius: 0.375rem; font-size: 10px; font-weight: 700; color: #64748b;">@lang('Live Portfolio')</div>
                </div>

                @if ($investChart->count())
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); align-items: center; gap: 2rem; flex: 1;">
                        <div style="display: flex; flex-direction: column; gap: 1rem;">
                            @foreach ($investChart as $chart)
                                <div style="display: flex; align-items: center; justify-content: space-between;">
                                    <div style="display: flex; align-items: center; gap: 0.75rem;">
                                        <div class="plan-indicator" style="width: 0.75rem; height: 0.75rem; border-radius: 0.125rem;"></div>
                                        <span style="font-size: 12px; font-weight: 900; color: #475569; text-transform: uppercase; letter-spacing: -0.025em;">{{ __($chart->plan->name) }}</span>
                                    </div>
                                    <span style="font-size: 12px; font-family: monospace; font-weight: 700; color: #0f172a;">
                                        {{ showAmount(($chart->investAmount / $investChart->sum('investAmount')) * 100, currencyFormat:false) }}%
                                    </span>
                                </div>
                            @endforeach
                        </div>

                        <div style="position: relative; display: flex; justify-content: center; align-items: center;">
                            <div style="width: 12rem; height: 12rem;">
                                <canvas id="investDonutChart"></canvas>
                            </div>
                        </div>
                    </div>
                @else
                    <div style="flex: 1; display: flex; flex-direction: column; align-items: center; justify-content: center; border: 2px dashed #f1f5f9; border-radius: 0.75rem;">
                        <i data-lucide="pie-chart" style="width: 2.5rem; height: 2.5rem; color: #e2e8f0; margin-bottom: 0.5rem;"></i>
                        <p style="font-size: 10px; font-weight: 900; color: #cbd5e1; text-transform: uppercase; letter-spacing: 0.1em;">@lang('Insufficient Data')</p>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 1.5rem; padding: 0 0.5rem;">
        <h4 style="font-size: 11px; font-weight: 900; color: #0f172a; text-transform: uppercase; letter-spacing: 0.3em; margin: 0;">@lang('Investment Terminal Log')</h4>
        <a href="{{ route('user.invest.log') }}" style="text-decoration: none; font-size: 10px; font-weight: 700; color: #94a3b8; text-transform: uppercase; transition: color 0.3s ease;">@lang('View Details')</a>
    </div>

    <div style="overflow: hidden; border: 1px solid rgba(0,0,0,0.1); background-color: #ffffff; border-radius: 0.75rem; box-shadow: 0 1px 2px rgba(0,0,0,0.05);">
        @include('Template::partials.invest_history',['invests'=>$invests])
    </div>
</div>
@endsection