@extends('Template::layouts.dashboard')
@section('content')
<div class="min-h-[80vh] flex items-center justify-center py-20 px-4">
    <div class="relative w-full max-w-lg">
        
        <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500 via-cyan-500 to-blue-500 rounded-[2.5rem] blur opacity-20"></div>
        
        <div class="relative bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2.5rem] shadow-2xl overflow-hidden">
            
            <div class="p-10 pb-4 text-center">
                <div class="w-16 h-16 bg-slate-100 dark:bg-white/5 rounded-2xl flex items-center justify-center mx-auto mb-6 border border-slate-200 dark:border-white/10">
                    <i data-lucide="layers" class="w-8 h-8 text-emerald-500"></i>
                </div>
                <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase">@lang('Secure Checkout')</h2>
                <div class="inline-flex items-center gap-2 px-3 py-1 bg-emerald-500/10 rounded-full mt-3">
                    <span class="w-1.5 h-1.5 rounded-full bg-emerald-500 animate-pulse"></span>
                    <span class="text-[9px] font-black text-emerald-500 uppercase tracking-widest">@lang('Razorpay Gateway Live')</span>
                </div>
            </div>

            <div class="p-10">
                <div class="space-y-4 bg-slate-50 dark:bg-white/5 rounded-3xl p-8 border border-slate-100 dark:border-white/5 relative overflow-hidden">
                    <div class="absolute -top-10 -right-10 w-32 h-32 bg-emerald-500/5 rounded-full blur-3xl"></div>
                    
                    <div class="flex justify-between items-center relative z-10">
                        <span class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em]">@lang('Payable Amount')</span>
                        <span class="text-xl font-black text-slate-900 dark:text-white tracking-tighter">
                            {{showAmount($deposit->final_amount, currencyFormat:false)}} {{__($deposit->method_currency)}}
                        </span>
                    </div>

                    <div class="h-px bg-dashed bg-slate-200 dark:bg-white/10 my-2"></div>

                    <div class="flex justify-between items-center relative z-10">
                        <span class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em]">@lang('Node Allocation')</span>
                        <span class="text-md font-bold text-emerald-500">
                            {{showAmount($deposit->amount)}}
                        </span>
                    </div>
                </div>

                <div class="mt-10 razorpay-form-wrapper">
                    <form action="{{$data->url}}" method="{{$data->method}}">
                        <input type="hidden" custom="{{$data->custom}}" name="hidden">
                        <script src="{{$data->checkout_js}}"
                                @foreach($data->val as $key=>$value)
                                data-{{$key}}="{{$value}}"
                            @endforeach >
                        </script>
                    </form>
                </div>

                <div class="mt-8 flex flex-col items-center gap-4">
                    <div class="flex items-center gap-3 opacity-40">
                        <i data-lucide="shield-check" class="w-3.5 h-3.5 text-slate-400"></i>
                        <p class="text-[9px] font-black text-slate-400 uppercase tracking-[0.2em]">@lang('PCI-DSS Compliant Encryption')</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .razorpay-payment-button {
        display: block !important;
        width: 100% !important;
        height: 64px !important;
        background: #0f172a !important; /* Slate-900 */
        color: white !important;
        border-radius: 1rem !important;
        font-size: 11px !important;
        font-weight: 900 !important;
        text-transform: uppercase !important;
        letter-spacing: 0.3em !important;
        border: none !important;
        box-shadow: 0 20px 25px -5px rgb(0 0 0 / 0.1) !important;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
        cursor: pointer !important;
    }
    .dark .razorpay-payment-button {
        background: white !important;
        color: #0f172a !important;
    }
    .razorpay-payment-button:hover {
        transform: translateY(-2px) !important;
        background: #10b981 !important; /* Emerald-500 */
        color: white !important;
    }
    .razorpay-payment-button:active {
        transform: scale(0.95) !important;
    }
</style>

<script src="https://unpkg.com/lucide@latest"></script>
<script>
    lucide.createIcons();
</script>
@endsection

@push('script')
    <script>
        (function ($) {
            "use strict";
            // Ensure the dynamic button matches the 'Execute' style of your other pages
            $(document).ready(function() {
                $('.razorpay-payment-button').text("@lang('Authorize Settlement')");
            });
        })(jQuery);
    </script>
@endpush