@extends('Template::layouts.dashboard')
@section('content')
<div class="min-h-screen py-20 px-4 flex items-center justify-center">
    <div class="relative w-full max-w-4xl">
        
        <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500 via-cyan-500 to-blue-500 rounded-[2.5rem] blur opacity-15"></div>
        
        <div class="relative bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2.5rem] shadow-2xl overflow-hidden">
            
            <div class="grid grid-cols-12">
                <div class="col-span-12 lg:col-span-5 bg-slate-50 dark:bg-white/[0.02] p-8 md:p-12 border-b lg:border-b-0 lg:border-r border-slate-100 dark:border-white/5">
                    <div class="mb-10">
                        <h3 class="text-[10px] font-black text-slate-400 uppercase tracking-[0.4em] mb-2">@lang('Secure Module')</h3>
                        <p class="text-xs font-bold text-slate-500 uppercase">@lang('Checkout.com Encryption')</p>
                    </div>

                    <div class="card-wrapper mb-10 transform scale-110 md:scale-100 origin-left"></div>

                    <div class="space-y-4 pt-10 border-t border-slate-200 dark:border-white/10">
                        <div class="flex justify-between items-center">
                            <span class="text-[9px] font-black uppercase tracking-widest text-slate-400">@lang('Asset Purchase')</span>
                            <span class="text-xs font-black text-slate-900 dark:text-white">{{ showAmount($deposit->amount) }}</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-[9px] font-black uppercase tracking-widest text-slate-400">@lang('Processing Fee')</span>
                            <span class="text-xs font-bold text-rose-500">+ {{ showAmount($deposit->charge) }}</span>
                        </div>
                        <div class="pt-2 flex justify-between items-center">
                            <span class="text-[9px] font-black uppercase tracking-widest text-slate-400">@lang('Total Impact')</span>
                            <span class="text-sm font-black text-emerald-500">{{ showAmount($deposit->final_amount, currencyFormat:false) }} {{ __($deposit->method_currency) }}</span>
                        </div>
                    </div>
                </div>

                <div class="col-span-12 lg:col-span-7 p-8 md:p-12">
                    <div class="flex items-center justify-between mb-12">
                        <h2 class="text-xl font-black text-slate-900 dark:text-white tracking-tighter uppercase">@lang('Card Entry')</h2>
                        <div class="flex gap-2">
                             <i data-lucide="shield-check" class="w-5 h-5 text-emerald-500"></i>
                             <i data-lucide="lock" class="w-5 h-5 text-slate-300"></i>
                        </div>
                    </div>

                    <form role="form" class="disableSubmission appPayment space-y-6" id="payment-form" method="{{ $data->method }}" action="{{ $data->url }}">
                        @csrf
                        <input type="hidden" value="{{ $data->track }}" name="track">

                        <div class="space-y-2">
                            <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest">@lang('Name on Card')</label>
                            <div class="relative group">
                                <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                    <i data-lucide="user" class="w-4 h-4 text-slate-400 group-focus-within:text-emerald-500 transition-colors"></i>
                                </div>
                                <input type="text" class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 pl-12 pr-4 text-sm font-bold text-slate-900 dark:text-white focus:ring-2 focus:ring-emerald-500 transition-all outline-none" name="name" value="{{ old('name') }}" required autocomplete="off" autofocus placeholder="JOHN DOE" />
                            </div>
                        </div>

                        <div class="space-y-2">
                            <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest">@lang('Card Number')</label>
                            <div class="relative group">
                                <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                    <i data-lucide="credit-card" class="w-4 h-4 text-slate-400 group-focus-within:text-emerald-500 transition-colors"></i>
                                </div>
                                <input type="tel" class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 pl-12 pr-4 text-sm font-mono font-bold text-slate-900 dark:text-white focus:ring-2 focus:ring-emerald-500 transition-all outline-none" name="cardNumber" autocomplete="off" value="{{ old('cardNumber') }}" required placeholder="0000 0000 0000 0000" />
                            </div>
                        </div>

                        <div class="grid grid-cols-2 gap-6">
                            <div class="space-y-2">
                                <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest">@lang('Expiry')</label>
                                <input type="tel" class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-bold text-slate-900 dark:text-white focus:ring-2 focus:ring-emerald-500 transition-all outline-none text-center" name="cardExpiry" value="{{ old('cardExpiry') }}" autocomplete="off" required placeholder="MM / YY" />
                            </div>
                            <div class="space-y-2">
                                <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest">@lang('CVC')</label>
                                <input type="tel" class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-bold text-slate-900 dark:text-white focus:ring-2 focus:ring-emerald-500 transition-all outline-none text-center" name="cardCVC" value="{{ old('cardCVC') }}" autocomplete="off" required placeholder="000" />
                            </div>
                        </div>

                        <div class="pt-8">
                            <button class="group relative w-full h-16 bg-slate-900 dark:bg-white rounded-2xl overflow-hidden transition-all active:scale-95 shadow-xl shadow-emerald-500/10" type="submit" id="btn-submit">
                                <div class="absolute inset-0 bg-gradient-to-r from-emerald-500 to-cyan-500 opacity-0 group-hover:opacity-100 transition-opacity"></div>
                                <div class="relative flex items-center justify-center gap-3">
                                    <span class="text-[11px] font-black text-white dark:text-slate-900 uppercase tracking-[0.3em] group-hover:text-white">@lang('Transmit Data')</span>
                                    <i data-lucide="send" class="w-4 h-4 text-emerald-400 dark:text-emerald-600 group-hover:text-white transition-all"></i>
                                </div>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
    <script src="https://unpkg.com/lucide@latest"></script>
    <script src="{{ asset('assets/global/js/card.js') }}"></script>

    <script>
        (function($) {
            "use strict";
            lucide.createIcons();

            var card = new Card({
                form: '#payment-form',
                container: '.card-wrapper',
                formSelectors: {
                    numberInput: 'input[name="cardNumber"]',
                    expiryInput: 'input[name="cardExpiry"]',
                    cvcInput: 'input[name="cardCVC"]',
                    nameInput: 'input[name="name"]'
                },
                placeholders: {
                    number: '•••• •••• •••• ••••',
                    name: 'CARDHOLDER NAME',
                    expiry: 'MM/YY',
                    cvc: '•••'
                }
            });

            const $form = $('#payment-form');
            const $btn = $('#btn-submit');

            $form.on('submit', function() {
                $btn.attr('disabled', true).addClass('opacity-70 cursor-not-allowed');
                $btn.find('span').text("@lang('Authorizing...')");
                
                @if ($deposit->from_api)
                    $btn.find('i').removeClass('send').addClass('animate-spin').html('<i class="las la-spinner"></i>');
                @endif
            });

        })(jQuery);
    </script>
@endpush