@extends('Template::layouts.dashboard')
@section('content')
<div class="min-h-[80vh] flex items-center justify-center py-20 px-4">
    <div class="relative w-full max-w-lg">
        
        <div class="absolute -inset-1 bg-gradient-to-r from-blue-600 via-indigo-500 to-emerald-500 rounded-[2.5rem] blur opacity-20"></div>
        
        <div class="relative bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2.5rem] shadow-2xl overflow-hidden">
            
            <div class="p-10 pb-4 text-center">
                <div class="w-16 h-16 bg-slate-100 dark:bg-white/5 rounded-2xl flex items-center justify-center mx-auto mb-6 border border-slate-200 dark:border-white/10">
                    <i data-lucide="shield-check" class="w-8 h-8 text-blue-500"></i>
                </div>
                <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase">@lang('Secure Gateway')</h2>
                <div class="inline-flex items-center gap-2 px-3 py-1 bg-blue-500/10 rounded-full mt-3 border border-blue-500/20">
                    <span class="w-1.5 h-1.5 rounded-full bg-blue-500 animate-pulse"></span>
                    <span class="text-[9px] font-black text-blue-500 uppercase tracking-widest">@lang('Stripe Protocol Encrypted')</span>
                </div>
            </div>

            <div class="p-10">
                <div class="space-y-4 bg-slate-50 dark:bg-white/5 rounded-3xl p-8 border border-slate-100 dark:border-white/5 relative">
                    
                    <div class="flex justify-between items-center relative z-10">
                        <span class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em]">@lang('Authorized Debit')</span>
                        <span class="text-xl font-black text-slate-900 dark:text-white tracking-tighter">
                            {{showAmount($deposit->final_amount, currencyFormat:false)}} {{__($deposit->method_currency)}}
                        </span>
                    </div>

                    <div class="h-px bg-dashed bg-slate-200 dark:bg-white/10 my-2"></div>

                    <div class="flex justify-between items-center relative z-10">
                        <span class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em]">@lang('Wallet Ingress')</span>
                        <span class="text-md font-bold text-emerald-500">
                            {{showAmount($deposit->amount)}}
                        </span>
                    </div>
                </div>

                <div class="mt-10 stripe-form-wrapper">
                    <form action="{{ $data->url }}" method="{{ $data->method }}">
                        <script src="{{ $data->src }}" class="stripe-button" 
                            @foreach ($data->val as $key => $value)
                                data-{{ $key }}="{{ $value }}" 
                            @endforeach>
                        </script>
                    </form>
                </div>

                <div class="mt-8 flex items-center justify-center gap-4 opacity-40">
                    <i data-lucide="lock" class="w-3.5 h-3.5 text-slate-400"></i>
                    <p class="text-[9px] font-black text-slate-400 uppercase tracking-[0.2em]">@lang('Stripe Secure SCA Compliant')</p>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    /* Styling for the Stripe-injected button to match our theme */
    .stripe-button-el {
        visibility: hidden !important;
        display: none !important;
    }
    
    .stripe-custom-btn {
        display: flex !important;
        align-items: center;
        justify-content: center;
        width: 100%;
        height: 64px;
        background: #0f172a; /* Slate-900 */
        color: white;
        border-radius: 1rem;
        font-size: 11px;
        font-weight: 900;
        text-transform: uppercase;
        letter-spacing: 0.3em;
        border: none;
        box-shadow: 0 20px 25px -5px rgb(0 0 0 / 0.1);
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        cursor: pointer;
        position: relative;
        overflow: hidden;
    }

    .dark .stripe-custom-btn {
        background: white;
        color: #0f172a;
    }

    .stripe-custom-btn:hover {
        background: #3b82f6; /* Stripe Blue */
        color: white;
        transform: translateY(-2px);
    }

    .stripe-custom-btn:active {
        transform: scale(0.98);
    }
</style>
@endsection

@push('stript-lib')
    <script src="https://js.stripe.com/v3/"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            lucide.createIcons();

            // Intercepting the Stripe button creation
            const observer = new MutationObserver((mutations) => {
                mutations.forEach((mutation) => {
                    if (mutation.addedNodes.length) {
                        $('button.stripe-button-el').each(function() {
                            const $btn = $(this);
                            $btn.removeClass("stripe-button-el")
                                .addClass("stripe-custom-btn")
                                .html("<span>@lang('Execute Payment')</span>");
                        });
                    }
                });
            });

            observer.observe(document.body, {
                childList: true,
                subtree: true
            });

        })(jQuery);
    </script>
@endpush