@extends($activeTemplate . 'layouts.master')
@section('content')
<div class="max-w-2xl mx-auto py-10">
    <div class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
        <div class="absolute inset-0 opacity-10">
            <div class="absolute top-0 right-0 w-32 h-32 bg-white rounded-full -translate-y-16 translate-x-16"></div>
            <div class="absolute bottom-0 left-0 w-16 h-16 bg-white rounded-full translate-y-8 -translate-x-8"></div>
        </div>
        <div class="relative z-10">
            <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                <div class="mb-4 lg:mb-0 lg:flex-1">
                    <h1 class="text-xl font-light mb-1">@lang('Deposit Funds')</h1>
                    <p class="text-gray-300 text-sm">@lang('Add money to your wallet using your preferred payment method')</p>
                </div>
                <div class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-64">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-xs text-gray-300 mb-1">@lang('Current Balance')</p>
                            <p class="text-lg font-light">{{ showAmount(auth()->user()->deposit_wallet) }}</p>
                        </div>
                        <div class="w-10 h-10 flex items-center justify-center">
                            <i data-lucide="wallet" class="w-5 h-5 text-white"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
        <form action="{{ route('user.deposit.insert') }}" method="POST" class="deposit-form space-y-6">
            @csrf
            <input type="hidden" name="currency">

            <div>
                <label for="amount" class="block text-sm font-medium text-gray-700 mb-2">@lang('Deposit Amount')</label>
                <div class="relative">
                    <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-500">{{ gs('cur_sym') }}</span>
                    <input type="number" id="amount" name="amount" step="any" class="amount w-full pl-8 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200" placeholder="0.00" value="{{ old('amount') }}" required>
                </div>
                <p class="mt-2 text-[10px] text-gray-400 uppercase tracking-widest">
                    @lang('Limit'): <span class="gateway-limit">0.00</span>
                </p>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-3">@lang('Select Payment Network')</label>
                <div class="space-y-3 gateway-option-list">
                    @foreach ($gatewayCurrency as $data)
                        <label class="flex items-center p-4 border border-gray-200 rounded-lg cursor-pointer hover:border-gray-300 hover:bg-gray-50 transition-all duration-200 group gateway-option @if ($loop->index > 3) d-none @endif">
                            <input type="radio" name="gateway" value="{{ $data->method_code }}" class="gateway-input w-4 h-4 text-black border-gray-300 focus:ring-black" 
                                data-gateway='@json($data)' 
                                data-min-amount="{{ showAmount($data->min_amount) }}" 
                                data-max-amount="{{ showAmount($data->max_amount) }}"
                                @checked(old('gateway', $loop->first) == $data->method_code) required>
                            
                            <div class="ml-3 flex items-center flex-1">
                                <img src="{{ getImage(getFilePath('gateway') . '/' . $data->method->image) }}" alt="{{ __($data->name) }}" class="w-8 h-8 mr-3 object-contain">
                                <div class="flex-1">
                                    <p class="font-medium text-black text-sm uppercase">{{ __($data->name) }}</p>
                                    <p class="text-[10px] text-gray-400 uppercase">@lang('Instant Processing')</p>
                                </div>
                                <div class="w-6 h-6 flex items-center justify-center group-hover:scale-110 transition-transform duration-200">
                                    <i data-lucide="arrow-right" class="w-4 h-4 text-gray-400 group-hover:text-gray-600"></i>
                                </div>
                            </div>
                        </label>
                    @endforeach
                </div>

                @if ($gatewayCurrency->count() > 4)
                    <button type="button" class="more-gateway-option w-full mt-4 py-3 text-xs font-bold text-gray-400 uppercase tracking-widest border border-dashed border-gray-200 rounded-lg hover:bg-gray-50 transition-all">
                        @lang('View All Networks')
                    </button>
                @endif
            </div>

            <div class="bg-gradient-to-br from-gray-50 to-gray-100 rounded-lg p-4 border border-gray-200">
                <div class="flex items-center justify-between mb-3">
                    <span class="text-xs font-medium text-gray-800 uppercase tracking-tighter">@lang('Transaction Summary')</span>
                    <i data-lucide="calculator" class="w-4 h-4 text-gray-400"></i>
                </div>
                <div class="space-y-2">
                    <div class="flex items-center justify-between">
                        <span class="text-xs text-gray-600">@lang('Amount'):</span>
                        <span class="text-xs font-medium text-gray-800">{{ gs('cur_sym') }}<span class="display-amount">0.00</span></span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-xs text-gray-600">@lang('Processing Fee'):</span>
                        <span class="text-xs font-medium text-rose-600">+ {{ gs('cur_sym') }}<span class="processing-fee">0.00</span></span>
                    </div>
                    
                    <div class="gateway-conversion d-none border-t border-gray-200 pt-2">
                        <div class="flex items-center justify-between italic">
                            <span class="text-[10px] text-gray-500">@lang('Exchange Rate'):</span>
                            <span class="text-[10px] text-gray-500 conversion-rate-text"></span>
                        </div>
                        <div class="flex items-center justify-between mt-1">
                            <span class="text-xs font-semibold text-emerald-600">@lang('Payable'):</span>
                            <span class="text-xs font-bold text-emerald-600 in-currency"></span>
                        </div>
                    </div>

                    <div class="border-t border-gray-300 pt-2">
                        <div class="flex items-center justify-between">
                            <span class="text-sm font-semibold text-black">@lang('Total Debit'):</span>
                            <span class="text-sm font-bold text-black">{{ gs('cur_sym') }}<span class="final-amount">0.00</span></span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="crypto-message d-none p-3 rounded-lg bg-amber-50 text-amber-700 text-[10px] font-bold uppercase text-center border border-amber-100">
                @lang('Crypto conversion finalized on next step')
            </div>

            <button type="submit" class="w-full bg-black text-white py-4 px-6 rounded-xl font-black uppercase tracking-[0.2em] hover:bg-gray-800 transition-all active:scale-[0.98] disabled:opacity-50" sdisabled>
                @lang('Execute Deposit')
            </button>
        </form>
    </div>
</div>
@endsection

@push('script')
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://unpkg.com/lucide@latest"></script>
<script>
    (function($) {
        "use strict";
        lucide.createIcons();

        var amount = parseFloat($('.amount').val() || 0);
        var gateway, minAmount, maxAmount;

        $('.amount').on('input', function() {
            amount = parseFloat($(this).val()) || 0;
            $('.display-amount').text(amount.toFixed(2));
            calculation();
        });

        $('.gateway-input').on('change', function() {
            gatewayChange();
        });

        function gatewayChange() {
            let gatewayElement = $('.gateway-input:checked');
            gateway = gatewayElement.data('gateway');
            minAmount = gatewayElement.data('min-amount');
            maxAmount = gatewayElement.data('max-amount');
            calculation();
        }

        $(".more-gateway-option").on("click", function() {
            $(".gateway-option").removeClass("d-none");
            $(this).fadeOut();
        });

        function calculation() {
            if (!gateway) return;
            $(".gateway-limit").text(minAmount + " - " + maxAmount + " {{ __(gs('cur_text')) }}");

            let percentCharge = parseFloat(gateway.percent_charge);
            let fixedCharge = parseFloat(gateway.fixed_charge);
            let totalPercentCharge = amount > 0 ? (amount / 100 * percentCharge) : 0;
            let totalCharge = totalPercentCharge + fixedCharge;
            let totalAmount = amount + totalCharge;

            $(".final-amount").text(totalAmount.toFixed(2));
            $(".processing-fee").text(totalCharge.toFixed(2));
            $("input[name=currency]").val(gateway.currency);

            // Validation
            if (amount < Number(gateway.min_amount) || amount > Number(gateway.max_amount) || amount <= 0) {
                $(".deposit-form button[type=submit]").attr('disabled', true);
            } else {
                $(".deposit-form button[type=submit]").removeAttr('disabled');
            }

            // Conversion Logic
            if (gateway.currency != "{{ gs('cur_text') }}" && gateway.method.crypto != 1) {
                $(".gateway-conversion").removeClass('d-none');
                $(".conversion-rate-text").html(`1 {{ __(gs('cur_text')) }} = ${parseFloat(gateway.rate).toFixed(4)} ${gateway.currency}`);
                $('.in-currency').text(parseFloat(totalAmount * gateway.rate).toFixed(2) + ' ' + gateway.currency);
            } else {
                $(".gateway-conversion").addClass('d-none');
            }

            if (gateway.method.crypto == 1) {
                $('.crypto-message').removeClass('d-none');
            } else {
                $('.crypto-message').addClass('d-none');
            }
        }

        gatewayChange(); // Initialize on load
    })(jQuery);
</script>
@endpush