<?php $__env->startSection('content'); ?>
    <div class="max-w-7xl mx-auto">
        <!-- Enhanced Header -->
        <div
            class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
                <div class="absolute bottom-0 left-0 w-24 h-24 bg-white rounded-full translate-y-12 -translate-x-12"></div>
            </div>

            <div class="relative z-10">
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                    <div class="mb-4 lg:mb-0 lg:flex-1">
                        <div class="flex items-center mb-1">
                            <h1 class="text-xl font-light">Portfolio Overview</h1>
                            <div class="ml-3 real-time-indicator">
                                <span
                                    class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-green-900 text-green-300">
                                    <i data-lucide="radio" class="w-3 h-3 mr-1"></i>
                                    Live
                                </span>
                            </div>
                        </div>
                        <p class="text-gray-300 text-sm">Track your investment performance and holdings</p>
                        <p class="text-xs text-gray-400 mt-1">Last updated: <span data-last-updated><?php echo e(now()); ?></span></p>
                    </div>

                    <!-- Enhanced Stats Card -->
                    <div
                        class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-80">
                        <div class="flex items-center justify-between mb-3">
                            <div>
                                <p class="text-xs text-gray-300 mb-1">Total Value</p>
                                <p class="text-lg font-light" data-portfolio-total-value="$0.00"
                                    data-balance-target="portfolio-total-value" data-balance-amount="0">
                                    <?php echo e(showAmount($totalInvest + $interests)); ?>

                                </p>
                                <p class="text-[11px] text-gray-300" data-btc-target="portfolio-total-value">—</p>
                            </div>
                            <div class="w-10 h-10 flex items-center justify-center">
                                <i data-lucide="trending-up" class="w-5 h-5 text-white"></i>
                            </div>
                        </div>
                        <div class="flex space-x-4 text-xs">
                            <div class="flex-1 text-center">
                                <p class="text-gray-300">Invested</p>
                                <p class="text-white font-medium" data-portfolio-total-cost="$0.00"
                                    data-balance-target="portfolio-total-invested" data-balance-amount="0">
                                    <?php echo e(showAmount($totalInvest)); ?>

                                </p>
                                <p class="text-[11px] text-gray-300" data-btc-target="portfolio-total-invested">—</p>
                            </div>
                            <div class="flex-1 text-center">
                                <p class="text-gray-300">Gain/Loss</p>
                                <p class="text-white font-medium text-green-400" data-portfolio-total-gain-loss="$0.00"
                                    data-balance-target="portfolio-total-gain-loss" data-balance-amount="0">
                                    +<?php echo e(showAmount($interests)); ?>

                                </p>
                                <p class="text-[11px] text-gray-300" data-btc-target="portfolio-total-gain-loss">—</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Portfolio Navigation -->
        <div class="bg-white rounded-xl p-4 shadow-sm border border-gray-100 mb-6">
            <div class="flex items-center justify-between mb-4">
                <div>
                    <h3 class="text-lg font-light text-black mb-1">Portfolio Tools</h3>
                    <p class="text-xs text-gray-500">Access detailed portfolio analysis and management</p>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-4 gap-3">
                <a href="<?php echo e(route('user.invest.log')); ?>"
                    class="group bg-gray-50 rounded-lg p-4 hover:bg-gray-100 transition-all duration-300">
                    <div class="flex items-center justify-between mb-2">
                        <div class="w-8 h-8 flex items-center justify-center">
                            <i data-lucide="pie-chart" class="w-4 h-4 text-blue-600"></i>
                        </div>
                        <i data-lucide="arrow-right"
                            class="w-4 h-4 text-gray-400 group-hover:text-gray-600 transition-colors duration-200"></i>
                    </div>
                    <h4 class="text-sm font-medium text-black mb-1">Holdings</h4>
                    <p class="text-xs text-gray-500">Detailed holdings breakdown</p>
                </a>

                <a href="<?php echo e(route('user.invest.statistics')); ?>"
                    class="group bg-gray-50 rounded-lg p-4 hover:bg-gray-100 transition-all duration-300">
                    <div class="flex items-center justify-between mb-2">
                        <div class="w-8 h-8 flex items-center justify-center">
                            <i data-lucide="bar-chart-3" class="w-4 h-4 text-green-600"></i>
                        </div>
                        <i data-lucide="arrow-right"
                            class="w-4 h-4 text-gray-400 group-hover:text-gray-600 transition-colors duration-200"></i>
                    </div>
                    <h4 class="text-sm font-medium text-black mb-1">Analytics</h4>
                    <p class="text-xs text-gray-500">Performance charts & analysis</p>
                </a>

                <a href="<?php echo e(route('user.transactions')); ?>"
                    class="group bg-gray-50 rounded-lg p-4 hover:bg-gray-100 transition-all duration-300">
                    <div class="flex items-center justify-between mb-2">
                        <div class="w-8 h-8 flex items-center justify-center">
                            <i data-lucide="activity" class="w-4 h-4 text-purple-600"></i>
                        </div>
                        <i data-lucide="arrow-right"
                            class="w-4 h-4 text-gray-400 group-hover:text-gray-600 transition-colors duration-200"></i>
                    </div>
                    <h4 class="text-sm font-medium text-black mb-1">Transactions</h4>
                    <p class="text-xs text-gray-500">Complete transaction history</p>
                </a>

                <a href="<?php echo e(route('user.invest.statistics')); ?>"
                    class="group bg-gray-50 rounded-lg p-4 hover:bg-gray-100 transition-all duration-300">
                    <div class="flex items-center justify-between mb-2">
                        <div class="w-8 h-8 flex items-center justify-center">
                            <i data-lucide="layout-dashboard" class="w-4 h-4 text-orange-600"></i>
                        </div>
                        <i data-lucide="arrow-right"
                            class="w-4 h-4 text-gray-400 group-hover:text-gray-600 transition-colors duration-200"></i>
                    </div>
                    <h4 class="text-sm font-medium text-black mb-1">Dashboard</h4>
                    <p class="text-xs text-gray-500">Investment dashboard overview</p>
                </a>
            </div>
        </div>

        <!-- Portfolio Performance -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
            <!-- Total Invested -->
            <div class="bg-white rounded-xl p-4 shadow-sm border border-gray-100">
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Total Invested</p>
                        <p class="text-lg font-light text-black" data-balance-target="portfolio-card-total-invested"
                            data-balance-amount="0">
                            <?php echo e(showAmount($totalInvest)); ?>

                        </p>
                        <p class="text-[11px] text-gray-500" data-btc-target="portfolio-card-total-invested">—</p>
                    </div>
                    <div class="w-8 h-8 flex items-center justify-center">
                        <i data-lucide="dollar-sign" class="w-4 h-4 text-blue-600"></i>
                    </div>
                </div>
            </div>

            <!-- Current Value -->
            <div class="bg-white rounded-xl p-4 shadow-sm border border-gray-100">
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Current Value</p>
                        <p class="text-lg font-light text-black" data-balance-target="portfolio-card-current-value"
                            data-balance-amount="0">
                            <?php echo e(showAmount($totalInvest + $interests)); ?>

                        </p>
                        <p class="text-[11px] text-gray-500" data-btc-target="portfolio-card-current-value">—</p>
                    </div>
                    <div class="w-8 h-8 flex items-center justify-center">
                        <i data-lucide="trending-up" class="w-4 h-4 text-green-600"></i>
                    </div>
                </div>
            </div>

            <!-- Total Gain/Loss -->
            <div class="bg-white rounded-xl p-4 shadow-sm border border-gray-100">
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Total Gain/Loss</p>
                        <p class="text-lg font-light text-green-600" data-balance-target="portfolio-card-total-gain-loss"
                            data-balance-amount="0">
                            +<?php echo e(showAmount($interests)); ?>

                        </p>
                        <p class="text-[11px] text-green-600" data-btc-target="portfolio-card-total-gain-loss">—</p>
                        <p class="text-xs text-green-600">
                            +0.00%
                        </p>
                    </div>
                    <div class="w-8 h-8 flex items-center justify-center">
                        <i data-lucide="arrow-up" class="w-4 h-4 text-green-600"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Holdings Section -->
        <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100 mb-6">
            <div class="flex items-center justify-between mb-4">
                <div>
                    <h3 class="text-lg font-light text-black mb-1">Your Holdings</h3>
                    <p class="text-xs text-gray-500"><?php echo e(count($invests)); ?> investment plans</p>
                </div>
                <a href="<?php echo e(route('user.invest.log')); ?>"
                    class="text-xs text-blue-600 hover:text-blue-800 transition-colors duration-200 font-medium">
                    Browse More
                    <i data-lucide="arrow-right" class="w-3 h-3 inline ml-1"></i>
                </a>
            </div>
            <?php if(count($invests) > 0): ?>
                <?php echo $__env->make('Template::partials.invest_history', ['invests' => $invests], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php else: ?>
            <div class="text-center py-8">
                <div class="w-12 h-12 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-3">
                    <i data-lucide="trending-up" class="w-6 h-6 text-gray-400"></i>
                </div>
                <h3 class="text-base font-light text-black mb-1">No holdings yet</h3>
                <p class="text-gray-600 text-xs mb-3">Start building your portfolio by investing in our plans</p>
                <a href="<?php echo e(route('user.invest.plan')); ?>s"
                    class="inline-flex items-center px-4 py-2 bg-black text-white text-xs font-medium rounded-lg hover:bg-gray-800 transition-colors duration-200">
                    <i data-lucide="plus" class="w-3 h-3 mr-1"></i>
                    Start Investing
                </a>
            </div>
            <?php endif; ?>
        </div>

        <!-- Recent Transactions -->
        <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
            <div class="flex items-center justify-between mb-4">
                <div>
                    <h3 class="text-lg font-light text-black mb-1">Recent Transactions</h3>
                    <p class="text-xs text-gray-500">Your latest investment activity</p>
                </div>
                <a href="<?php echo e(route('user.transactions')); ?>"
                    class="text-xs text-blue-600 hover:text-blue-800 transition-colors duration-200 font-medium">
                    View All
                    <i data-lucide="arrow-right" class="w-3 h-3 inline ml-1"></i>
                </a>
            </div>
            <?php if(count($investroi) > 0): ?>
                <?php echo $__env->make('Template::partials.invest_roi', ['investroi' => $investroi], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php else: ?>
            <div class="text-center py-6">
                <div class="w-8 h-8 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-2">
                    <i data-lucide="activity" class="w-4 h-4 text-gray-400"></i>
                </div>
                <p class="text-xs text-gray-500">No recent transactions</p>
            </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->startPush('script'); ?>
    <script>
        (function() {
            if (window.__btcRateScriptLoaded) {
                if (typeof window.reinitializeBtcBalanceWatchers === 'function') {
                    window.reinitializeBtcBalanceWatchers();
                }
                return;
            }

            window.__btcRateScriptLoaded = true;

            const BTC_SOURCES = [
                () => fetch('https://api.coindesk.com/v1/bpi/currentprice/BTC.json')
                .then((res) => res.ok ? res.json() : Promise.reject(res))
                .then((json) => json?.bpi?.USD?.rate_float ?? null),
                () => fetch('https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=usd')
                .then((res) => res.ok ? res.json() : Promise.reject(res))
                .then((json) => json?.bitcoin?.usd ?? null),
            ];

            let registries = [];
            let currentRate = null;

            const markUnavailable = () => {
                document.querySelectorAll('[data-btc-target]').forEach((node) => {
                    node.textContent = 'BTC rate unavailable';
                });
            };

            const formatBtc = (usdValue) => {
                if (!currentRate || currentRate <= 0) {
                    return null;
                }

                const btcValue = usdValue / currentRate;
                if (!isFinite(btcValue)) {
                    return null;
                }

                return btcValue.toLocaleString(undefined, {
                    minimumFractionDigits: 6,
                    maximumFractionDigits: 6,
                });
            };

            const updateDisplay = (targetName, usdValue) => {
                const displayNode = document.querySelector(`[data-btc-target="${targetName}"]`);
                if (!displayNode) {
                    return;
                }

                const formatted = formatBtc(usdValue);
                if (formatted === null) {
                    markUnavailable();
                    return;
                }

                displayNode.textContent = `≈ ${formatted} BTC`;
                displayNode.dataset.lastUsdValue = usdValue;
            };

            const extractUsd = (node) => {
                const explicit = node.dataset.balanceAmount;
                if (explicit !== undefined) {
                    const parsed = parseFloat(explicit);
                    return isNaN(parsed) ? 0 : parsed;
                }

                const numeric = (node.textContent || '').replace(/[^0-9.\-]/g, '');
                const parsed = parseFloat(numeric);
                return isNaN(parsed) ? 0 : parsed;
            };

            const registerNode = (node) => {
                const targetName = node.dataset.balanceTarget;
                if (!targetName) {
                    return;
                }

                const refresh = () => {
                    const usdValue = extractUsd(node);
                    updateDisplay(targetName, usdValue);
                };

                const observer = new MutationObserver(() => refresh());
                observer.observe(node, {
                    childList: true,
                    characterData: true,
                    subtree: true,
                    attributes: true,
                    attributeFilter: ['data-balance-amount'],
                });

                registries.push({
                    node,
                    observer,
                    refresh
                });
            };

            const scanNodes = () => {
                registries.forEach(({
                    observer
                }) => observer.disconnect());
                registries = [];
                document.querySelectorAll('[data-balance-target]').forEach(registerNode);
            };

            const applyRate = (rate) => {
                currentRate = rate;
                registries.forEach(({
                    refresh
                }) => refresh());
            };

            const fetchRate = async () => {
                for (const source of BTC_SOURCES) {
                    try {
                        const rate = await source();
                        if (rate && rate > 0) {
                            applyRate(rate);
                            return;
                        }
                    } catch (error) {
                        console.warn('BTC rate source failed', error);
                    }
                }

                markUnavailable();
            };

            const init = () => {
                scanNodes();
                fetchRate();
                setInterval(fetchRate, 60000);
            };

            window.refreshBtcEquivalents = () => registries.forEach(({
                refresh
            }) => refresh());
            window.reinitializeBtcBalanceWatchers = () => {
                scanNodes();
                window.refreshBtcEquivalents();
            };

            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', init);
            } else {
                init();
            }
        })();
    </script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Template::layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/user/invest/portfolio.blade.php ENDPATH**/ ?>