<?php $__env->startSection('content'); ?>
<div class="px-4 mx-auto py-8">

    
    <div class="flex flex-col md:flex-row md:items-center justify-between gap-6 mb-12 px-4">
        <div class="flex items-center gap-5">
            <div class="relative group">
                <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-2xl blur opacity-25"></div>
                <div class="relative w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white border border-white/10 shadow-2xl">
                    <i data-lucide="message-circle" class="w-7 h-7 text-emerald-400"></i>
                </div>
            </div>
            <div>
                <div class="flex items-center gap-3">
                    <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase"><?php echo app('translator')->get('Ticket'); ?> #<?php echo e($myTicket->ticket); ?></h2>
                    <div class="status-badge-wrapper"><?php echo $myTicket->statusBadge; ?></div>
                </div>
                <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-1"><?php echo e($myTicket->subject); ?></p>
            </div>
        </div>

        <?php if($myTicket->status != 3 && $myTicket->user): ?>
            <button class="confirmationBtn group flex items-center gap-3 px-6 py-3 bg-rose-500/10 text-rose-500 rounded-xl border border-rose-500/20 hover:bg-rose-500 hover:text-white transition-all font-black text-[10px] uppercase tracking-widest" 
                    data-question="<?php echo app('translator')->get('Are you sure to close this ticket?'); ?>" 
                    data-action="<?php echo e(route('ticket.close', $myTicket->id)); ?>">
                <i data-lucide="lock" class="w-4 h-4"></i>
                <?php echo app('translator')->get('Terminate Thread'); ?>
            </button>
        <?php endif; ?>
    </div>

    <div class="grid grid-cols-12 gap-8">
        
        <?php if($myTicket->status != 4): ?>
        <div class="col-span-12 order-2 lg:order-1">
            <div class="relative bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2.5rem] p-8 shadow-2xl">
                <form method="post" action="<?php echo e(route('ticket.reply', $myTicket->id)); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="space-y-6">
                        <div class="relative">
                            <textarea name="message" rows="4" class="w-full bg-slate-50 dark:bg-slate-950 border border-slate-100 dark:border-white/5 rounded-[2rem] p-6 text-sm font-bold text-slate-900 dark:text-white focus:ring-2 focus:ring-emerald-500 transition-all outline-none" placeholder="<?php echo app('translator')->get('Transmit your reply...'); ?>" required><?php echo e(old('message')); ?></textarea>
                        </div>

                        <div class="flex flex-wrap items-center justify-between gap-4">
                            <div class="flex flex-col gap-2">
                                <button type="button" class="addAttachment text-[9px] font-black text-emerald-500 uppercase tracking-widest flex items-center gap-2 hover:text-emerald-400">
                                    <i data-lucide="paperclip" class="w-4 h-4"></i> <?php echo app('translator')->get('Attach Intelligence'); ?>
                                </button>
                                <p class="text-[8px] font-bold text-slate-400 uppercase tracking-tight"><?php echo app('translator')->get('Max 5 files | Extensions: .jpg, .png, .pdf, .doc'); ?></p>
                            </div>

                            <button type="submit" class="px-10 py-4 bg-slate-900 dark:bg-white text-white dark:text-slate-900 rounded-2xl font-black text-[10px] uppercase tracking-[0.2em] hover:bg-emerald-500 hover:text-white transition-all flex items-center gap-3">
                                <i data-lucide="send" class="w-4 h-4"></i> <?php echo app('translator')->get('Transmit Reply'); ?>
                            </button>
                        </div>

                        <div class="fileUploadsContainer grid grid-cols-1 md:grid-cols-3 gap-4"></div>
                    </div>
                </form>
            </div>
        </div>
        <?php endif; ?>

        
        <div class="col-span-12 order-1 lg:order-2 space-y-8">
            <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $isAdmin = $message->admin_id != 0; ?>
                
                <div class="relative flex <?php echo e($isAdmin ? 'justify-start' : 'justify-end'); ?>">
                    <div class="max-w-[85%] md:max-w-[70%] w-full">
                        <div class="flex items-center gap-3 mb-2 <?php echo e($isAdmin ? 'flex-row' : 'flex-row-reverse'); ?>">
                            <span class="text-[10px] font-black text-slate-900 dark:text-white uppercase tracking-widest">
                                <?php echo e($isAdmin ? $message->admin->name : $message->ticket->fullname); ?>

                            </span>
                            <?php if($isAdmin): ?>
                                <span class="px-2 py-0.5 bg-blue-500 text-white text-[8px] font-black uppercase rounded"><?php echo app('translator')->get('STAFF'); ?></span>
                            <?php endif; ?>
                            <span class="text-[9px] font-bold text-slate-400 uppercase tracking-tight">
                                <?php echo e($message->created_at->format('M d, H:i')); ?>

                            </span>
                        </div>

                        <div class="relative group">
                            
                            <div class="relative p-6 rounded-[2rem] <?php echo e($isAdmin 
                                ? 'bg-white dark:bg-slate-900 border-l-4 border-l-blue-500 shadow-xl text-slate-700 dark:text-slate-300' 
                                : 'bg-slate-900 text-white rounded-tr-none shadow-2xl'); ?>">
                                
                                <p class="text-sm leading-relaxed font-medium"><?php echo e($message->message); ?></p>

                                <?php if($message->attachments->count() > 0): ?>
                                    <div class="mt-4 pt-4 border-t <?php echo e($isAdmin ? 'border-slate-100 dark:border-white/5' : 'border-white/10'); ?> flex flex-wrap gap-3">
                                        <?php $__currentLoopData = $message->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e(route('ticket.download', encrypt($image->id))); ?>" class="flex items-center gap-2 px-3 py-1.5 rounded-lg <?php echo e($isAdmin ? 'bg-slate-100 dark:bg-white/5 text-blue-500' : 'bg-white/10 text-emerald-400'); ?> text-[9px] font-black uppercase tracking-widest hover:scale-105 transition-transform">
                                                <i data-lucide="download-cloud" class="w-3 h-3"></i> <?php echo app('translator')->get('File'); ?> <?php echo e(++$k); ?>

                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>

<?php if (isset($component)) { $__componentOriginal198649c2376bbacd94125172b51704af = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal198649c2376bbacd94125172b51704af = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.confirmation-modal2','data' => ['closeBtn' => 'btn-danger btn-md','submitBtn' => 'btn--base btn-md']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal2'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['closeBtn' => 'btn-danger btn-md','submitBtn' => 'btn--base btn-md']); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal198649c2376bbacd94125172b51704af)): ?>
<?php $attributes = $__attributesOriginal198649c2376bbacd94125172b51704af; ?>
<?php unset($__attributesOriginal198649c2376bbacd94125172b51704af); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal198649c2376bbacd94125172b51704af)): ?>
<?php $component = $__componentOriginal198649c2376bbacd94125172b51704af; ?>
<?php unset($__componentOriginal198649c2376bbacd94125172b51704af); ?>
<?php endif; ?>

<style>
    /* Status Badge normalization */
    .status-badge-wrapper .badge {
        padding: 4px 10px !important;
        font-size: 8px !important;
        font-weight: 900 !important;
        text-transform: uppercase !important;
        border-radius: 6px !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script src="https://unpkg.com/lucide@latest"></script>
<script>
    (function($) {
        "use strict";
        lucide.createIcons();

        var fileAdded = 0;
        $('.addAttachment').on('click', function() {
            if (fileAdded >= 5) return;
            fileAdded++;
            if (fileAdded == 5) $(this).fadeOut();
            
            $(".fileUploadsContainer").append(`
                <div class="removeFileInput animate-in zoom-in-95 duration-200">
                    <div class="relative flex items-center">
                        <input type="file" name="attachments[]" class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-xl py-2 px-3 text-[10px] font-black text-slate-400 file:hidden" required>
                        <button type="button" class="removeFile absolute right-2 text-rose-500 hover:text-rose-400">
                            <i data-lucide="circle-x" class="w-4 h-4"></i>
                        </button>
                    </div>
                </div>
            `);
            lucide.createIcons();
        });

        $(document).on('click', '.removeFile', function() {
            $('.addAttachment').fadeIn();
            fileAdded--;
            $(this).closest('.removeFileInput').remove();
        });
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/support/view.blade.php ENDPATH**/ ?>