<?php $__env->startSection('content'); ?>
<div class="min-h-screen py-20 px-4 flex items-center justify-center">
    <div class="relative w-full max-w-2xl">
        
        <div class="absolute -inset-1 bg-gradient-to-br from-black to-gray-800 rounded-[2.5rem] blur-2xl opacity-5"></div>
        
        <div class="relative bg-white rounded-[2.5rem] shadow-2xl border border-gray-100 overflow-hidden">
            
            <div class="bg-gradient-to-br from-black via-gray-900 to-gray-800 p-8 text-white relative overflow-hidden">
                <div class="absolute inset-0 opacity-10">
                    <div class="absolute top-0 right-0 w-32 h-32 bg-white rounded-full -translate-y-16 translate-x-16"></div>
                </div>
                
                <div class="relative z-10 flex items-center gap-5">
                    <div class="w-14 h-14 bg-white/10 backdrop-blur-xl rounded-2xl flex items-center justify-center border border-white/20">
                        <i data-lucide="shield-check" class="w-7 h-7 text-white"></i>
                    </div>
                    <div>
                        <h2 class="text-xl font-light tracking-tight leading-none">
                            <?php echo e(__($data->gateway->name)); ?> <?php echo app('translator')->get('Settlement'); ?>
                        </h2>
                        <p class="text-[10px] font-bold text-gray-400 uppercase tracking-[0.2em] mt-2"><?php echo app('translator')->get('Manual Asset Verification'); ?></p>
                    </div>
                </div>
            </div>

            <div class="p-8 md:p-10">
                <form action="<?php echo e(route('user.deposit.manual.update')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    
                    <div class="space-y-8">
                        
                        <div class="relative group">
                            <div class="p-6 bg-gray-50 border border-gray-200 rounded-2xl transition-all group-hover:bg-gray-100">
                                <div class="flex items-start gap-4">
                                    <div class="mt-1 w-8 h-8 rounded-lg bg-black flex items-center justify-center">
                                        <i data-lucide="info" class="w-4 h-4 text-white"></i>
                                    </div>
                                    <div class="flex-1">
                                        <p class="text-xs font-medium text-gray-500 uppercase tracking-wider"><?php echo app('translator')->get('Requested Allocation'); ?></p>
                                        <p class="text-lg font-bold text-black"><?php echo e(showAmount($data['amount'])); ?></p>
                                        
                                        <div class="h-px bg-gray-200 my-3"></div>
                                        
                                        <p class="text-xs font-medium text-gray-500 uppercase tracking-wider"><?php echo app('translator')->get('Payable in'); ?> <?php echo e($data['method_currency']); ?></p>
                                        <p class="text-xl font-black text-black">
                                            <?php echo e(showAmount($data['final_amount'], currencyFormat:false) .' '.$data['method_currency']); ?>

                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="space-y-4">
                            <div class="flex items-center gap-3">
                                <span class="text-[10px] font-black text-black uppercase tracking-[0.3em]"><?php echo app('translator')->get('Payment Instructions'); ?></span>
                                <div class="h-px flex-1 bg-gray-100"></div>
                            </div>
                            <div class="prose prose-sm max-w-none bg-gray-50 p-6 rounded-2xl border border-gray-100 text-gray-600 font-medium leading-relaxed">
                                <?php echo $data->gateway->description ?>
                            </div>
                        </div>

                        <div class="space-y-6">
                            <div class="flex items-center gap-3">
                                <span class="text-[10px] font-black text-black uppercase tracking-[0.3em]"><?php echo app('translator')->get('Transfer Evidence'); ?></span>
                                <div class="h-px flex-1 bg-gray-100"></div>
                            </div>
                            
                            <div class="manual-form-wrapper custom-inputs">
                                <?php if (isset($component)) { $__componentOriginal3bd95de28203859144f617d3fb6afebc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3bd95de28203859144f617d3fb6afebc = $attributes; } ?>
<?php $component = App\View\Components\ViserForm::resolve(['identifier' => 'id','identifierValue' => ''.e($gateway->form_id).''] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('viser-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ViserForm::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3bd95de28203859144f617d3fb6afebc)): ?>
<?php $attributes = $__attributesOriginal3bd95de28203859144f617d3fb6afebc; ?>
<?php unset($__attributesOriginal3bd95de28203859144f617d3fb6afebc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3bd95de28203859144f617d3fb6afebc)): ?>
<?php $component = $__componentOriginal3bd95de28203859144f617d3fb6afebc; ?>
<?php unset($__componentOriginal3bd95de28203859144f617d3fb6afebc); ?>
<?php endif; ?>
                            </div>
                        </div>

                        <div class="pt-4">
                            <button type="submit" class="group relative w-full h-16 bg-black text-white rounded-2xl overflow-hidden transition-all active:scale-95 shadow-xl hover:shadow-gray-200">
                                <div class="relative flex items-center justify-center gap-3">
                                    <span class="text-[11px] font-black uppercase tracking-[0.3em]">
                                        <?php echo app('translator')->get('Submit Payment Data'); ?>
                                    </span>
                                    <i data-lucide="arrow-right" class="w-4 h-4 text-gray-400 group-hover:translate-x-1 transition-all"></i>
                                </div>
                            </button>
                            <div class="flex items-center justify-center gap-2 mt-6 opacity-60">
                                <i data-lucide="clock" class="w-3 h-3 text-gray-400"></i>
                                <p class="text-[9px] font-bold text-gray-400 uppercase tracking-widest">
                                    <?php echo app('translator')->get('Manual verification usually completes within 1-6 hours'); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
<style>
    /* Styling the Dynamic Viser Form to match the Sleek UI */
    .custom-inputs label {
        display: block;
        font-size: 12px;
        font-weight: 600;
        color: #374151;
        margin-bottom: 8px;
        text-transform: uppercase;
        letter-spacing: 0.05em;
    }
    .custom-inputs input, .custom-inputs select, .custom-inputs textarea {
        width: 100%;
        padding: 12px 16px;
        background-color: #F9FAFB;
        border: 1px solid #E5E7EB;
        border-radius: 12px;
        font-size: 14px;
        transition: all 0.2s;
    }
    .custom-inputs input:focus {
        background-color: #fff;
        border-color: #000;
        outline: none;
        ring: 2px solid #000;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script src="https://unpkg.com/lucide@latest"></script>
<script>
    (function($) {
        "use strict";
        lucide.createIcons();
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($activeTemplate . 'layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/user/payment/manual.blade.php ENDPATH**/ ?>