<?php $__env->startSection('content'); ?>
    <div class="px-4 mx-auto py-8">
      <?php $__env->startPush('breadcrumb_text'); ?>
            <div class="flex items-center gap-5">
                <div class="relative group">
                    <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-2xl blur opacity-25">
                    </div>
                    <div
                        class="relative w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white border border-white/10 shadow-2xl">
                        <i data-lucide="printer" class="w-7 h-7 text-emerald-400"></i>
                    </div>
                </div>
                <div>
                    <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase"><?php echo app('translator')->get('Transaction Log'); ?>
                    </h2>
                    <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-1"><?php echo app('translator')->get('Your Transaction history'); ?></p>
                </div>
            </div>
        <?php $__env->stopPush(); ?>

        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-12">
            <div class="relative group h-full">
                <div
                    class="absolute -inset-0.5 bg-gradient-to-r from-green-500 to-red-600 rounded-[2.5rem] blur opacity-20 group-hover:opacity-40 transition duration-500">
                </div>
                <div
                    class="relative h-full bg-slate-900 dark:bg-[#0b1121] border border-white/10 rounded-[2.5rem] p-10 shadow-2xl overflow-hidden backdrop-blur-md border border-white/10 rounded-[2.5rem] p-8 overflow-hidden flex flex-col justify-between shadow-2xl">
                    <div class="flex justify-between items-start mb-6">
                        <div
                            class="w-12 h-12 bg-green-500/20 rounded-2xl flex items-center justify-center text-green-400 border border-green-500/30">
                            <i data-lucide="trending-up" class="w-6 h-6"></i>
                        </div>
                        <span
                            class="text-[9px] font-black text-green-400 bg-green-500/10 px-3 py-1 rounded-full uppercase tracking-widest border border-green-500/20"><?php echo app('translator')->get('Credit'); ?></span>
                    </div>
                    <div>
                        <p class="text-[10px] font-black text-white/50 uppercase tracking-[0.2em] mb-1"><?php echo app('translator')->get('Total Credit Volume'); ?>
                        </p>
                        <h3 class="text-3xl font-black text-white tracking-tighter"><?php echo e(showAmount($totalCredit)); ?></h3>
                    </div>
                    <div class="absolute bottom-0 left-0 right-0 h-1.5 bg-gradient-to-r from-green-500 to-red-600"></div>
                </div>
            </div>

            <div class="relative group h-full">
                <div
                    class="absolute -inset-0.5 bg-gradient-to-r from-rose-500 to-red-600 rounded-[2.5rem] blur opacity-20 group-hover:opacity-40 transition duration-500">
                </div>
                <div
                    class="relative h-full bg-slate-900 dark:bg-[#0b1121] border border-white/10 rounded-[2.5rem] p-10 shadow-2xl overflow-hidden backdrop-blur-md border border-white/10 rounded-[2.5rem] p-8 overflow-hidden flex flex-col justify-between shadow-2xl">
                    <div class="flex justify-between items-start mb-6">
                        <div
                            class="w-12 h-12 bg-rose-500/20 rounded-2xl flex items-center justify-center text-rose-400 border border-rose-500/30">
                            <i data-lucide="trending-down" class="w-6 h-6"></i>
                        </div>
                        <span
                            class="text-[9px] font-black text-rose-400 bg-rose-500/10 px-3 py-1 rounded-full uppercase tracking-widest border border-rose-500/20"><?php echo app('translator')->get('Debit'); ?></span>
                    </div>
                    <div>
                        <p class="text-[10px] font-black text-white/50 uppercase tracking-[0.2em] mb-1"><?php echo app('translator')->get('Total Debit Volume'); ?>
                        </p>
                        <h3 class="text-3xl font-black text-white tracking-tighter"><?php echo e(showAmount($totalDebit)); ?></h3>
                    </div>
                    <div class="absolute bottom-0 left-0 right-0 h-1.5 bg-gradient-to-r from-rose-500 to-red-600"></div>
                </div>
            </div>




        </div>

        
        <div class="mb-8">
            <div class="flex justify-between items-center mb-6 px-4">
                <h4 class="text-[11px] font-black text-slate-900 dark:text-white uppercase tracking-[0.3em]">
                    <?php echo app('translator')->get('Protocol Filtering'); ?></h4>
                <button type="button"
                    class="showFilterBtn w-10 h-10 rounded-xl bg-slate-100 dark:bg-white/5 flex items-center justify-center text-slate-500 hover:bg-emerald-500 hover:text-white transition-all">
                    <i data-lucide="sliders-horizontal" class="w-5 h-5"></i>
                </button>
            </div>

            <div class="responsive-filter-card hidden mb-8">
                <div
                    class="bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2rem] p-8 shadow-xl">
                    <form action="" method="GET" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-6">
                        <div class="space-y-2">
                            <label
                                class="text-[9px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('TRX Number'); ?></label>
                            <input type="text" name="search" value="<?php echo e(request()->search); ?>"
                                class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-xl py-3 px-4 text-xs font-bold text-white outline-none focus:ring-1 focus:ring-emerald-500">
                        </div>
                        <div class="space-y-2">
                            <label
                                class="text-[9px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Wallet'); ?></label>
                            <select name="wallet_type"
                                class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-xl py-3 px-4 text-xs font-bold text-white outline-none">
                                <option value=""><?php echo app('translator')->get('All Wallets'); ?></option>
                                <option value="deposit_wallet" <?php if(request()->wallet_type == 'deposit_wallet'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Deposit'); ?></option>
                                <option value="interest_wallet" <?php if(request()->wallet_type == 'interest_wallet'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Interest'); ?></option>
                            </select>
                        </div>
                        <div class="space-y-2">
                            <label
                                class="text-[9px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Flow'); ?></label>
                            <select name="trx_type"
                                class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-xl py-3 px-4 text-xs font-bold text-white outline-none">
                                <option value=""><?php echo app('translator')->get('All Flows'); ?></option>
                                <option value="+" <?php if(request()->trx_type == '+'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Plus (+)'); ?></option>
                                <option value="-" <?php if(request()->trx_type == '-'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Minus (-)'); ?></option>
                            </select>
                        </div>
                        <div class="space-y-2">
                            <label
                                class="text-[9px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Remark'); ?></label>
                            <select name="remark"
                                class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-xl py-3 px-4 text-xs font-bold text-white outline-none">
                                <option value=""><?php echo app('translator')->get('Any Remark'); ?></option>
                                <?php $__currentLoopData = $remarks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $remark): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($remark->remark); ?>" <?php if(request()->remark == $remark->remark): echo 'selected'; endif; ?>>
                                        <?php echo e(__(keyToTitle($remark->remark))); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="flex items-end">
                            <button
                                class="w-full py-3 bg-slate-900 dark:bg-white text-white dark:text-slate-900 rounded-xl text-[10px] font-black uppercase tracking-widest hover:bg-emerald-500 hover:text-white transition-all">
                                <?php echo app('translator')->get('Apply Filter'); ?>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        
        <div
            class="bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2.5rem] overflow-hidden shadow-2xl">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="bg-slate-50 dark:bg-white/[0.02] border-b border-slate-100 dark:border-white/5">
                            <th class="px-8 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest">
                                <?php echo app('translator')->get('Reference'); ?></th>
                            <th class="px-6 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest">
                                <?php echo app('translator')->get('Timestamp'); ?></th>
                            <th
                                class="px-6 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest text-center">
                                <?php echo app('translator')->get('Amount'); ?></th>
                            <th
                                class="px-6 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest text-center">
                                <?php echo app('translator')->get('Post Balance'); ?></th>
                            <th
                                class="px-6 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest text-center">
                                <?php echo app('translator')->get('Wallet Type'); ?></th>
                            <th
                                class="px-8 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest text-right">
                                <?php echo app('translator')->get('Description'); ?></th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-100 dark:divide-white/5">
                        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="group hover:bg-slate-50/50 dark:hover:bg-white/[0.01] transition-all duration-300">
                                <td class="px-8 py-6">
                                    <span
                                        class="text-xs font-black text-slate-900 dark:text-white tracking-tighter uppercase"><?php echo e($trx->trx); ?></span>
                                </td>
                                <td class="px-6 py-6 text-nowrap">
                                    <p
                                        class="text-[11px] font-black text-slate-900 dark:text-white leading-none tracking-tight">
                                        <?php echo e(showDateTime($trx->created_at, 'd M, Y')); ?></p>
                                    <p class="text-[9px] font-bold text-slate-400 uppercase tracking-widest mt-1">
                                        <?php echo e(diffForHumans($trx->created_at)); ?></p>
                                </td>
                                <td class="px-6 py-6 text-center">
                                    <span
                                        class="text-xs font-black <?php if($trx->trx_type == '+'): ?> text-emerald-500 <?php else: ?> text-rose-500 <?php endif; ?>">
                                        <?php echo e($trx->trx_type); ?> <?php echo e(showAmount($trx->amount)); ?>

                                    </span>
                                </td>
                                <td class="px-6 py-6 text-center">
                                    <span
                                        class="text-xs font-black text-slate-900 dark:text-white tracking-tighter"><?php echo e(showAmount($trx->post_balance)); ?></span>
                                </td>
                                <td class="px-6 py-6 text-center">
                                    <?php if($trx->wallet_type == 'deposit_wallet'): ?>
                                        <span
                                            class="text-[9px] font-black px-3 py-1 bg-blue-500/10 text-blue-500 rounded-full border border-blue-500/20 uppercase tracking-widest"><?php echo app('translator')->get('Deposit'); ?></span>
                                    <?php else: ?>
                                        <span
                                            class="text-[9px] font-black px-3 py-1 bg-emerald-500/10 text-emerald-500 rounded-full border border-emerald-500/20 uppercase tracking-widest"><?php echo app('translator')->get('Interest'); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-8 py-6 text-right">
                                    <span
                                        class="text-[10px] font-bold text-slate-500 dark:text-slate-400 italic">"<?php echo e(__($trx->details)); ?>"</span>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="px-8 py-24 text-center" colspan="100%">
                                    <div class="flex flex-col items-center opacity-30">
                                        <i data-lucide="database-zap" class="w-12 h-12 mb-4"></i>
                                        <p class="text-[10px] font-black uppercase tracking-[0.3em]">
                                            <?php echo e(__($emptyMessage)); ?></p>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <?php if($transactions->hasPages()): ?>
            <div class="mt-10 flex justify-end">
                <?php echo e(paginateLinks($transactions)); ?>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="https://unpkg.com/lucide@latest"></script>
    <script>
        (function($) {
            "use strict";
            lucide.createIcons();

            $('.showFilterBtn').on('click', function() {
                $('.responsive-filter-card').slideToggle(300);
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/transactions.blade.php ENDPATH**/ ?>