<?php
    $testimonialCaption = getContent('testimonial.content',true);
    $testimonialElements = getContent('testimonial.element',false,null,true);
    // Split testimonials into two sets for the dual-direction effect
    $chunkSize = ceil($testimonialElements->count() / 2);
    $sets = $testimonialElements->chunk($chunkSize);
?>
<!--==========================  Testimonial Section Start  ==========================-->
    <section class="testimonial-section bg--black-two py-120">
        <div class="container position-relative">
            <div class="testimonial-shape d-none d-lg-block">
                <img src="<?php echo e(asset('assets/frontend/svg/twostar.svg')); ?>" alt="star">
                <img src="<?php echo e(asset('assets/frontend/svg/maneyPlant.svg')); ?>" alt="money Plant">
            </div>
            <div class="row row-gap-2">
                <div class="col-lg-6 align-self-end">
                    <div class="section-content">
                        <h6 class="right-reveal">Testimonial</h6>
                        <h2 class="mb-2 right-reveal"><?php echo e(__(@$testimonialCaption->data_values->heading_w)); ?></h2>
                    </div>
                </div>
                <div class="col-lg-6 align-self-end">
                    <div class="section-content">
                        <p class="right-reveal"><?php echo e(__(@$testimonialCaption->data_values->sub_heading)); ?> </p>
                    </div>
                </div>
            </div>
            <div class="row mt-60">
                <div class="col-12 position-relative bottom-reveal">
                    <div class="testimonial-slide swiper">
                        <div class="swiper-wrapper">
                            <?php $__currentLoopData = $testimonialElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonialElement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="swiper-slide">
                                <div class="testimonial-item">
                                    <div class="start-client">
                                        <img src="<?php echo e(asset('assets/frontend/svg/star-5.svg')); ?>" alt="star">
                                    </div>
                                    <div class="client-body">
                                        <img src="<?php echo e(asset('assets/frontend/svg/quite.svg')); ?>" alt="quite">
                                        <p class="client-text">
                                           <?php echo e(__(@$testimonialElement->data_values->quote)); ?>

                                        </p>
                                        <div class="client-info d-flex gap-3 align-self-center">
                                            <img src="<?php echo e(frontendImage('testimonial', @$testimonialElement->data_values->image,'69x75')); ?>"
                                                alt="client">
                                            <div class="text">
                                                <h4 class="mb-2"><?php echo e(__(@$testimonialElement->data_values->name)); ?></h4>
                                                <p><?php echo e(__(@$testimonialElement->data_values->designation)); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                             

                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                    <div class="slider-btn">
                        <div class="btn-slider-prev testi-prev">
                            <i class="fa-solid fa-chevron-left"></i>
                        </div>
                        <div class="btn-slider-next testi-next">
                            <i class="fa-solid fa-chevron-right"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--==========================  Testimonial Section End  ==========================-->
   
     <?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/sections/testimonial.blade.php ENDPATH**/ ?>