<?php
    $topInvestor = \App\Models\Invest::with('user')
        ->selectRaw('SUM(amount) as totalAmount, user_id')
        ->orderBy('totalAmount', 'desc')
        ->groupBy('user_id')
        ->limit(8)
        ->get();
    
    $top_investorContent = getContent('top_investor.content', true);
?>

<section class="py-32 bg-white dark:bg-slate-950 relative overflow-hidden">
    <div class="absolute inset-0 opacity-[0.03] dark:opacity-[0.07] pointer-events-none" 
         style="background-image: linear-gradient(#000 1px, transparent 1px), linear-gradient(90deg, #000 1px, transparent 1px); background-size: 50px 50px;"></div>

    <div class="container mx-auto px-6 relative z-10">
        
        <div class="flex flex-col md:flex-row justify-between items-end mb-24 gap-8">
            <div class="max-w-2xl">
                <div class="flex items-center gap-3 mb-6">
                    <span class="px-2 py-0.5 bg-emerald-500/10 text-emerald-500 text-[9px] font-black uppercase tracking-widest rounded">Network Ranking</span>
                    <span class="text-[9px] font-black text-slate-400 uppercase tracking-[0.4em]">Capital Allocation Index</span>
                </div>
                <h2 class="text-6xl font-black text-slate-900 dark:text-white uppercase tracking-tighter leading-none">
                    <?php echo e(__(@$top_investorContent->data_values->heading_w)); ?> <br> 
                    <span class="text-emerald-500"><?php echo e(__(@$top_investorContent->data_values->heading_c)); ?></span>
                </h2>
            </div>
            <div class="pb-2">
                <p class="text-sm font-medium text-slate-500 dark:text-slate-400 max-w-xs text-right italic">
                    <?php echo e(__(@$top_investorContent->data_values->sub_heading)); ?>

                </p>
            </div>
        </div>

        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
            <?php $__currentLoopData = $topInvestor; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="group relative p-8 bg-slate-50 dark:bg-white/[0.02] border border-slate-200 dark:border-white/5 rounded-[2.5rem] hover:bg-white dark:hover:bg-slate-900 hover:shadow-2xl hover:shadow-emerald-500/10 transition-all duration-500">
                    
                    <div class="absolute top-6 right-6">
                        <span class="text-[10px] font-black text-slate-300 dark:text-slate-700 uppercase tracking-tighter group-hover:text-emerald-500 transition-colors">
                            RANK #<?php echo e(str_pad($loop->iteration, 2, '0', STR_PAD_LEFT)); ?>

                        </span>
                    </div>

                    <div class="mb-10 flex flex-col items-center sm:items-start text-center sm:text-left">
                        <div class="w-16 h-16 rounded-2xl bg-slate-900 dark:bg-white mb-6 flex items-center justify-center shadow-lg group-hover:rotate-6 transition-transform">
                            <span class="text-2xl font-black text-white dark:text-slate-900">
                                <?php echo e(substr($data->user->fullname, 0, 1)); ?>

                            </span>
                        </div>
                        <h5 class="text-xl font-black text-slate-900 dark:text-white uppercase tracking-tighter mb-1">
                            <?php echo e($data->user->fullname); ?>

                        </h5>
                        <p class="text-[10px] font-bold text-emerald-500 uppercase tracking-widest">
                            @<span><?php echo e(@json_decode(json_encode($data->user->username))); ?></span>
                        </p>
                    </div>

                    <div class="pt-6 border-t border-slate-200 dark:border-white/5">
                        <p class="text-[9px] font-black text-slate-400 uppercase tracking-[0.2em] mb-2">Deployed Capital</p>
                        <div class="flex items-center justify-between">
                            <span class="text-xl font-black text-slate-900 dark:text-white italic tracking-tighter">
                                <?php echo e(showAmount($data->totalAmount)); ?>

                            </span>
                            <div class="w-8 h-8 rounded-full bg-emerald-500/10 flex items-center justify-center">
                                <i data-lucide="trending-up" class="w-4 h-4 text-emerald-500"></i>
                            </div>
                        </div>
                    </div>

                    <div class="absolute inset-0 rounded-[2.5rem] border-2 border-emerald-500/0 group-hover:border-emerald-500/20 pointer-events-none transition-all"></div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <div class="mt-24 pt-12 border-t border-slate-100 dark:border-white/5 flex justify-between items-center opacity-40">
            <span class="text-[9px] font-bold text-slate-400 uppercase tracking-[0.4em]">Audit Trail v.9.4 // Real-Time Liquidity Logs</span>
            <div class="flex items-center gap-4">
                <div class="w-2 h-2 rounded-full bg-emerald-500 animate-pulse"></div>
                <span class="text-[9px] font-bold text-slate-400 uppercase tracking-widest uppercase">Verified on Ledger</span>
            </div>
        </div>
    </div>
</section><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/sections/top_investor.blade.php ENDPATH**/ ?>