<?php $__env->startSection('content'); ?>
    <div class="px-4 mx-auto py-8">
        <?php $__env->startPush('breadcrumb_text'); ?>
            <div class="flex items-center gap-5">
                <div class="relative group">
                    <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-2xl blur opacity-25">
                    </div>
                    <div
                        class="relative w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white border border-white/10 shadow-2xl">
                        <i data-lucide="wallet-cards" class="w-7 h-7 text-emerald-400"></i>
                    </div>
                </div>
                <div>
                    <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase"><?php echo app('translator')->get('Withdrawal Log'); ?>
                    </h2>
                    <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-1"><?php echo app('translator')->get('Your payout/withdrawal history'); ?></p>
                </div>
            </div>
        <?php $__env->stopPush(); ?>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-12">

            <div class="relative group h-full">
                <div
                    class="absolute -inset-0.5 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-[2.5rem] blur opacity-20 group-hover:opacity-40 transition duration-500">
                </div>
                <div
                    class="relative h-full bg-slate-900 dark:bg-[#0b1121] border border-white/10 rounded-[2.5rem] p-10 shadow-2xl overflow-hidden backdrop-blur-md border border-white/10 rounded-[2.5rem] p-8 overflow-hidden flex flex-col justify-between shadow-2xl">
                    <div class="flex justify-between items-start mb-6">
                        <div
                            class="w-12 h-12 bg-emerald-500/20 rounded-2xl flex items-center justify-center text-emerald-400 border border-emerald-500/30 shadow-inner">
                            <i data-lucide="check-circle" class="w-6 h-6"></i>
                        </div>
                        <span
                            class="text-[9px] font-black text-emerald-400 bg-emerald-500/10 px-3 py-1 rounded-full uppercase tracking-widest border border-emerald-500/20"><?php echo app('translator')->get('Settled'); ?></span>
                    </div>
                    <div>
                        <p class="text-[10px] font-black text-white/50 uppercase tracking-[0.2em] mb-1"><?php echo app('translator')->get('Successful Payouts'); ?>
                        </p>
                        <h3 class="text-3xl font-black text-white tracking-tighter"><?php echo e(showAmount($successful)); ?></h3>
                    </div>
                    <div class="absolute bottom-0 left-0 right-0 h-1.5 bg-gradient-to-r from-emerald-500 to-blue-500"></div>
                </div>
            </div>

            <div class="relative group h-full">
                <div
                    class="absolute -inset-0.5 bg-gradient-to-r from-amber-500 to-orange-500 rounded-[2.5rem] blur opacity-20 group-hover:opacity-40 transition duration-500">
                </div>
                <div
                    class="relative h-full bg-slate-900 dark:bg-[#0b1121] border border-white/10 rounded-[2.5rem] p-10 shadow-2xl overflow-hidden backdrop-blur-md border border-white/10 rounded-[2.5rem] p-8 overflow-hidden flex flex-col justify-between shadow-2xl">
                    <div class="flex justify-between items-start mb-6">
                        <div
                            class="w-12 h-12 bg-amber-500/20 rounded-2xl flex items-center justify-center text-amber-400 border border-amber-500/30">
                            <i data-lucide="refresh-cw" class="w-6 h-6 animate-spin-slow"></i>
                        </div>
                        <span
                            class="text-[9px] font-black text-amber-400 bg-amber-500/10 px-3 py-1 rounded-full uppercase tracking-widest border border-amber-500/20"><?php echo app('translator')->get('Pending'); ?></span>
                    </div>
                    <div>
                        <p class="text-[10px] font-black text-white/50 uppercase tracking-[0.2em] mb-1"><?php echo app('translator')->get('Awaiting Verification'); ?>
                        </p>
                        <h3 class="text-3xl font-black text-white tracking-tighter"><?php echo e(showAmount($pending)); ?></h3>
                    </div>
                    <div class="absolute bottom-0 left-0 right-0 h-1.5 bg-gradient-to-r from-amber-500 to-orange-500"></div>
                </div>
            </div>

            <div class="relative group h-full">
                <div
                    class="absolute -inset-0.5 bg-gradient-to-r from-rose-500 to-red-600 rounded-[2.5rem] blur opacity-20 group-hover:opacity-40 transition duration-500">
                </div>
                <div
                    class="relative h-full bg-slate-900 dark:bg-[#0b1121] border border-white/10 rounded-[2.5rem] p-10 shadow-2xl overflow-hidden backdrop-blur-md border border-white/10 rounded-[2.5rem] p-8 overflow-hidden flex flex-col justify-between shadow-2xl">
                    <div class="flex justify-between items-start mb-6">
                        <div
                            class="w-12 h-12 bg-rose-500/20 rounded-2xl flex items-center justify-center text-rose-400 border border-rose-500/30">
                            <i data-lucide="x-octagon" class="w-6 h-6"></i>
                        </div>
                        <span
                            class="text-[9px] font-black text-rose-400 bg-rose-500/10 px-3 py-1 rounded-full uppercase tracking-widest border border-rose-500/20"><?php echo app('translator')->get('Rejected'); ?></span>
                    </div>
                    <div>
                        <p class="text-[10px] font-black text-white/50 uppercase tracking-[0.2em] mb-1"><?php echo app('translator')->get('Failed Protocols'); ?>
                        </p>
                        <h3 class="text-3xl font-black text-white tracking-tighter"><?php echo e(showAmount($rejected)); ?></h3>
                    </div>
                    <div class="absolute bottom-0 left-0 right-0 h-1.5 bg-gradient-to-r from-rose-500 to-red-600"></div>
                </div>
            </div>
        </div>

        <div class="flex flex-col md:flex-row justify-between items-center gap-6 mb-8 px-4">
            <h4 class="text-[11px] font-black text-slate-900 dark:text-white uppercase tracking-[0.3em]"><?php echo app('translator')->get('Withdrawal History'); ?>
            </h4>
            <form action="" method="GET" class="w-full md:w-auto">
                <div class="relative group">
                    <input type="text" name="search" value="<?php echo e(request()->search); ?>" placeholder="<?php echo app('translator')->get('Search Transaction ID...'); ?>"
                        class="w-full md:w-80 bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-2xl py-4 pl-12 pr-4 text-xs font-bold text-slate-900 dark:text-white outline-none focus:ring-1 focus:ring-emerald-500 transition-all shadow-sm">
                    <i data-lucide="search" class="absolute left-4 top-1/2 -translate-y-1/2 w-4 h-4 text-slate-400"></i>
                </div>
            </form>
        </div>

        <div
            class="absolute -inset-0.5 bg-gradient-to-r from-emerald-500/10 via-cyan-500/5 to-blue-500/10 rounded-[2.5rem] blur-sm">
        </div>
        <div
            class="glass-vault border border-slate-200 dark:border-white/10 bg-white/50 dark:bg-slate-900/50 backdrop-blur-xl rounded-xl overflow-hidden shadow-sm">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="bg-slate-50 dark:bg-white/[0.02] border-b border-slate-100 dark:border-white/5">
                            <th class="px-8 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest">
                                <?php echo app('translator')->get('Method | TRX'); ?></th>
                            <th class="px-6 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest">
                                <?php echo app('translator')->get('Initiated'); ?></th>
                            <th
                                class="px-6 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest text-center">
                                <?php echo app('translator')->get('Amount'); ?></th>
                            <th
                                class="px-6 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest text-center">
                                <?php echo app('translator')->get('Conversion'); ?></th>
                            <th
                                class="px-6 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest text-center">
                                <?php echo app('translator')->get('Status'); ?></th>
                            <th
                                class="px-8 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest text-right">
                                <?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-100 dark:divide-white/5">
                        <?php $__empty_1 = true; $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdraw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="group hover:bg-slate-50/50 dark:hover:bg-white/[0.01] transition-all duration-300">
                                <td class="px-8 py-6">
                                    <div class="flex items-center gap-4">
                                        <div
                                            class="w-10 h-10 rounded-xl bg-slate-100 dark:bg-white/5 p-1.5 border border-slate-200 dark:border-white/5">
                                            <img src="<?php echo e(getImage(getFilePath('withdrawMethod') . '/' . @$withdraw->method->image)); ?>"
                                                class="w-full h-full object-contain filter dark:brightness-125"
                                                alt="">
                                        </div>
                                        <div>
                                            <p
                                                class="text-xs font-black text-slate-900 dark:text-white tracking-tighter uppercase leading-none">
                                                <?php echo e(__(@$withdraw->method->name)); ?></p>
                                            <p
                                                class="text-[9px] font-mono font-bold text-slate-400 mt-1 uppercase tracking-tighter">
                                                <?php echo e($withdraw->trx); ?></p>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-6">
                                    <p
                                        class="text-[11px] font-black text-slate-900 dark:text-white leading-none tracking-tight">
                                        <?php echo e(showDateTime($withdraw->created_at, 'd M, Y')); ?></p>
                                    <p class="text-[9px] font-bold text-slate-400 uppercase tracking-widest mt-1">
                                        <?php echo e(diffForHumans($withdraw->created_at)); ?></p>
                                </td>
                                <td class="px-6 py-6 text-center">
                                    <p class="text-xs font-black text-slate-900 dark:text-white tracking-tighter">
                                        <?php echo e(showAmount($withdraw->amount)); ?></p>
                                    <p class="text-[9px] font-bold text-rose-500 mt-1 uppercase tracking-widest">-
                                        <?php echo e(showAmount($withdraw->charge)); ?> FEE</p>
                                </td>
                                <td class="px-6 py-6 text-center">
                                    <p class="text-[10px] font-bold text-slate-400 uppercase tracking-tight">1
                                        <?php echo e(gs('cur_text')); ?> = <?php echo e(showAmount($withdraw->rate, currencyFormat: false)); ?>

                                        <?php echo e(__($withdraw->currency)); ?></p>
                                    <p class="text-xs font-black text-emerald-500 tracking-tighter mt-1">
                                        <?php echo e(showAmount($withdraw->final_amount, currencyFormat: false)); ?>

                                        <?php echo e(__($withdraw->currency)); ?></p>
                                </td>
                                <td class="px-6 py-6 text-center">
                                    <div class="flex justify-center">
                                        <?php echo $withdraw->statusBadge ?>
                                    </div>
                                </td>
                                <td class="px-8 py-6 text-right">
                                    <button
                                        class="detailBtn group/btn relative w-10 h-10 rounded-xl bg-slate-900 dark:bg-white text-white dark:text-slate-900 flex items-center justify-center transition-all hover:scale-110 active:scale-95 shadow-xl shadow-slate-900/10 dark:shadow-white/5"
                                        data-user_data="<?php echo e(json_encode($withdraw->withdraw_information)); ?>"
                                        <?php if($withdraw->status == 3): ?> data-admin_feedback="<?php echo e($withdraw->admin_feedback); ?>" <?php endif; ?>>
                                        <i data-lucide="terminal" class="w-4 h-4"></i>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="px-8 py-24 text-center" colspan="100%">
                                    <div class="flex flex-col items-center opacity-30">
                                        <i data-lucide="layers" class="w-12 h-12 mb-4"></i>
                                        <p class="text-[10px] font-black uppercase tracking-[0.3em]">
                                            <?php echo e(__($emptyMessage)); ?></p>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <?php if($withdraws->hasPages()): ?>
        <div class="mt-10 flex justify-end">
            <?php echo e(paginateLinks($withdraws)); ?>

        </div>
    <?php endif; ?>
    </div>

    <div id="tailwindModal" class="fixed inset-0 z-[100] hidden">
        <div class="absolute inset-0 bg-slate-950/80 backdrop-blur-sm transition-opacity duration-300 backdrop-overlay">
        </div>

        <div class="absolute inset-0 flex items-center justify-center p-4 sm:p-6">
            <div class="relative w-full max-w-lg bg-white dark:bg-slate-900 rounded-[2.5rem] border border-slate-200 dark:border-white/10 shadow-2xl overflow-hidden transform transition-all scale-95 opacity-0 duration-300"
                id="modalContainer">

                <div class="p-8 sm:p-10">
                    <div class="flex justify-between items-start mb-10">
                        <div>
                            <div class="inline-flex items-center gap-2 px-2 py-1 bg-emerald-500/10 rounded-lg mb-2">
                                <span class="w-1.5 h-1.5 rounded-full bg-emerald-500 animate-pulse"></span>
                                <span
                                    class="text-[8px] font-black text-emerald-500 uppercase tracking-widest"><?php echo app('translator')->get('Secure Audit'); ?></span>
                            </div>
                            <h4 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase">
                                <?php echo app('translator')->get('Transaction Detail'); ?></h4>
                        </div>
                        <button type="button"
                            class="closeModal w-10 h-10 rounded-xl bg-slate-50 dark:bg-white/5 flex items-center justify-center hover:bg-rose-500 hover:text-white transition-all">
                            <i data-lucide="x" class="w-5 h-5"></i>
                        </button>
                    </div>

                    <div class="space-y-3 userData max-h-[350px] overflow-y-auto pr-2 custom-scrollbar">
                    </div>

                    <div class="feedback mt-6">
                    </div>

                    <div class="mt-10 pt-6 border-t border-slate-100 dark:border-white/5">
                        <button type="button"
                            class="closeModal w-full py-5 bg-slate-900 dark:bg-white text-white dark:text-slate-900 rounded-2xl text-[11px] font-black uppercase tracking-[0.3em] transition-all hover:bg-emerald-500 hover:text-white dark:hover:bg-emerald-500 dark:hover:text-white shadow-xl">
                            <?php echo app('translator')->get('Return to Ledger'); ?>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        /* Status Badge Refinement */
        .badge {
            padding: 6px 14px;
            border-radius: 8px;
            font-size: 9px;
            font-weight: 900;
            text-transform: uppercase;
            letter-spacing: 1px;
            border: 1px solid transparent;
        }

        .badge--success {
            background: rgba(16, 185, 129, 0.1) !important;
            color: #10b981 !important;
            border-color: rgba(16, 185, 129, 0.2) !important;
        }

        .badge--warning {
            background: rgba(245, 158, 11, 0.1) !important;
            color: #f59e0b !important;
            border-color: rgba(245, 158, 11, 0.2) !important;
        }

        .badge--danger {
            background: rgba(244, 63, 94, 0.1) !important;
            color: #f43f5e !important;
            border-color: rgba(244, 63, 94, 0.2) !important;
        }

        .animate-spin-slow {
            animation: spin 3s linear infinite;
        }

        @keyframes spin {
            from {
                transform: rotate(0deg);
            }

            to {
                transform: rotate(360deg);
            }
        }

        /* Custom Scrollbar for Modal */
        .custom-scrollbar::-webkit-scrollbar {
            width: 4px;
        }

        .custom-scrollbar::-webkit-scrollbar-track {
            background: transparent;
        }

        .custom-scrollbar::-webkit-scrollbar-thumb {
            background: rgba(0, 0, 0, 0.1);
            border-radius: 10px;
        }

        .dark .custom-scrollbar::-webkit-scrollbar-thumb {
            background: rgba(255, 255, 255, 0.1);
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="https://unpkg.com/lucide@latest"></script>
    <script>
        "use strict";
        (function($) {
            lucide.createIcons();

            const $modal = $('#tailwindModal');
            const $container = $('#modalContainer');

            $('.detailBtn').on('click', function() {
                let userData = $(this).data('user_data');
                let feedback = $(this).data('admin_feedback');
                let html = ``;

                if (userData) {
                    userData.forEach(el => {
                        if (el.type != 'file') {
                            html += `
                        <div class="p-5 rounded-2xl bg-slate-50 dark:bg-white/[0.03] border border-slate-100 dark:border-white/5 flex justify-between items-center transition-all hover:border-emerald-500/30">
                            <span class="text-[9px] font-black text-slate-400 uppercase tracking-[0.2em]">${el.name}</span>
                            <span class="text-xs font-black text-slate-900 dark:text-white">${el.value}</span>
                        </div>`;
                        }
                    });
                }
                $('.userData').html(html ||
                    '<p class="text-center text-slate-400 text-xs py-4"><?php echo app('translator')->get('No additional data available'); ?></p>');

                if (feedback) {
                    $('.feedback').html(`
                    <div class="p-6 rounded-2xl bg-rose-500/5 border border-rose-500/20 relative overflow-hidden">
                        <div class="absolute right-0 top-0 p-2 opacity-10">
                            <i data-lucide="alert-circle" class="w-12 h-12"></i>
                        </div>
                        <p class="text-[9px] font-black text-rose-500 uppercase tracking-widest mb-2 flex items-center gap-2">
                             <span class="w-1.5 h-1.5 rounded-full bg-rose-500"></span> <?php echo app('translator')->get('Rejection Reason'); ?>
                        </p>
                        <p class="text-xs font-bold text-slate-600 dark:text-slate-300 leading-relaxed italic">"${feedback}"</p>
                    </div>
                `);
                    lucide.createIcons(); // Re-init icons for dynamic HTML
                } else {
                    $('.feedback').empty();
                }

                // Show Tailwind Modal with Animation
                $modal.removeClass('hidden');
                setTimeout(() => {
                    $container.removeClass('scale-95 opacity-0').addClass('scale-100 opacity-100');
                }, 10);
            });

            // Close Modal Handlers
            $('.closeModal, .backdrop-overlay').on('click', function(e) {
                $container.removeClass('scale-100 opacity-100').addClass('scale-95 opacity-0');
                setTimeout(() => {
                    $modal.addClass('hidden');
                }, 300);
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/withdraw/log.blade.php ENDPATH**/ ?>