<script src="<?php echo e(asset('assets/global/js/firebase/firebase-app.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/firebase/firebase-messaging.js')); ?>"></script> 

<script>
    "use strict";

    let permission = null;
    const authenticated = <?php echo e(auth()->user() ? 'true' : 'false'); ?>;
    const pushNotify = <?php echo json_encode(gs('pn'), 15, 512) ?>;
    const firebaseConfig = <?php echo json_encode(gs('firebase_config'), 15, 512) ?>;

    function pushNotifyAction(){
        permission = Notification.permission;

        if(!('Notification' in window)){
            notify('info', 'Push notifications not available in your browser. Operational systems recommend Chromium.')
        }
        else if(permission === 'denied' || permission === 'default'){ 
            // TAILWIND INJECTION: THE SIGNAL ALERT (LUCIDE VERSION)
            $('.notice').append(`
                <div class="relative overflow-hidden bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/5 rounded-[2rem] p-6 mb-8 group transition-all hover:border-emerald-500/30">
                    <div class="absolute top-0 right-0 w-32 h-32 bg-emerald-500/5 rounded-bl-full pointer-events-none"></div>
                    <div class="flex items-center gap-6">
                        <div class="shrink-0 w-12 h-12 bg-amber-500/10 text-amber-500 rounded-xl flex items-center justify-center animate-pulse">
                            <i data-lucide="bell-ring" class="w-6 h-6"></i>
                        </div>
                        <div class="flex-grow">
                            <h5 class="text-sm font-black text-slate-900 dark:text-white uppercase tracking-tight italic">
                                <?php echo app('translator')->get('Signal Connection Interrupted'); ?>
                            </h5>
                            <p class="text-xs font-medium text-slate-500 dark:text-slate-400 mt-1">
                                <?php echo app('translator')->get('To receive real-time protocol updates and trade alerts, please allow browser notifications.'); ?>
                            </p>
                        </div>
                        <div class="hidden md:block">
                            <span class="text-[9px] font-black text-slate-300 dark:text-slate-700 uppercase tracking-widest italic">Protocol 403 // Access Needed</span>
                        </div>
                    </div>
                </div>
            `);
            
            // Re-initialize Lucide to render the newly injected icon
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();
            }
        }
    }

    if(pushNotify == 1){
        pushNotifyAction();
    }

    if(permission !== 'denied' && firebaseConfig){
        firebase.initializeApp(firebaseConfig);
        const messaging = firebase.messaging();

        navigator.serviceWorker.register("<?php echo e(asset('assets/global/js/firebase/firebase-messaging-sw.js')); ?>")
        .then((registration) => {
            messaging.useServiceWorker(registration);

            function initFirebaseMessagingRegistration() {
                messaging.requestPermission()
                .then(() => messaging.getToken())
                .then((token) => {
                    $.ajax({
                        url: '<?php echo e(route("user.add.device.token")); ?>',
                        type: 'POST',
                        data: {
                            token: token,
                            '_token': "<?php echo e(csrf_token()); ?>"
                        }
                    });
                }).catch((error) => console.error('Push Token Error:', error));
            }

            messaging.onMessage((payload) => {
                const title = payload.notification.title;
                const options = {
                    body: payload.notification.body,
                    icon: payload.data.icon,
                    image: payload.notification.image,
                    click_action: payload.data.click_action,
                    vibrate: [200, 100, 200]
                };
                new Notification(title, options);
            });

            if(authenticated){
                initFirebaseMessagingRegistration();
            }
        });
    }
</script><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/partials/push_script.blade.php ENDPATH**/ ?>