<!-- header-section start  -->
<?php
    $pages = App\Models\Page::where('tempname', activeTemplate())->where('is_default', 0)->get();
?>
<nav class="fixed top-0 left-0 right-0 z-50 bg-white border-b border-gray-200">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-16">
            <!-- Logo -->
            <div class="flex items-center">
                <a href="<?php echo e(url('/')); ?>" class="flex items-center">
                    <img src="<?php echo e(siteLogo()); ?>"
                        alt="Tesla Investments Platform" class="h-6 w-auto">
                </a>
            </div>

            <!-- Primary Nav -->
            <div class="hidden md:flex items-center space-x-6">
                <a href="<?php echo e(route('cars')); ?>"
                    class="text-sm font-medium text-gray-700 hover:text-black">Inventory</a>
                <a href="<?php echo e(route('user.login')); ?>" class="text-sm font-medium text-gray-700 hover:text-black">Invest</a>
                <a href="<?php echo e(route('user.login')); ?>" class="text-sm font-medium text-gray-700 hover:text-black">Stocks</a>
                <a href="<?php echo e(route('user.login')); ?>" class="text-sm font-medium text-gray-700 hover:text-black">Portfolio</a>
            </div>

            <!-- Right Side -->
            <div class="flex items-center space-x-2">
                <a href="<?php echo e(route('user.login')); ?>" class="text-sm font-medium text-gray-700 hover:text-black px-3 py-2">Account</a>

                <!-- Mobile menu button -->
                <button type="button" class="md:hidden p-2 text-gray-600 hover:text-black rounded-md hover:bg-gray-100"
                    id="mobile-menu-button">
                    <span class="sr-only">Open menu</span>
                    <i data-lucide="menu" class="w-5 h-5" id="menu-icon"></i>
                    <i data-lucide="x" class="w-5 h-5 hidden" id="close-icon"></i>
                </button>
            </div>
        </div>
    </div>

    <!-- Mobile Menu -->
    <div class="md:hidden hidden bg-white border-t border-gray-200" id="mobile-menu">
        <div class="px-4 pt-2 pb-4 space-y-1">
            <a href="<?php echo e(route('cars')); ?>"
                class="block px-3 py-2 text-sm font-medium text-gray-700 hover:bg-gray-50 rounded">Inventory</a>
            <a href="<?php echo e(route('cars')); ?>"
                class="block px-3 py-2 text-sm font-medium text-gray-700 hover:bg-gray-50 rounded">Invest</a>
            <a href="<?php echo e(route('user.login')); ?>"
                class="block px-3 py-2 text-sm font-medium text-gray-700 hover:bg-gray-50 rounded">Stocks</a>
            <a href="<?php echo e(route('user.login')); ?>"
                class="block px-3 py-2 text-sm font-medium text-gray-700 hover:bg-gray-50 rounded">Portfolio</a>
            <div class="border-t border-gray-200 mt-2 pt-2">
                <a href="<?php echo e(route('user.login')); ?>"
                    class="block px-3 py-2 text-sm font-medium text-gray-700 hover:bg-gray-50 rounded">Account</a>
            </div>
        </div>
    </div>
</nav>
<?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/partials/header_landing.blade.php ENDPATH**/ ?>