<?php $__env->startSection('content'); ?>
<div class="px-4 mx-auto py-2">

    
        <?php $__env->startPush('breadcrumb_text'); ?>

    <div class="flex flex-col md:flex-row md:items-center justify-between gap-6 mb-12 px-4">
        <div class="flex items-center gap-5">
            <div class="relative group">
                <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-2xl blur opacity-25"></div>
                <div class="relative w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white border border-white/10 shadow-2xl">
                    <i data-lucide="user-cog" class="w-7 h-7 text-emerald-400"></i>
                </div>
            </div>
            <div>
                <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase"><?php echo app('translator')->get('Profile Settings'); ?></h2>
                <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-1"><?php echo app('translator')->get('Manage account identity & localization'); ?></p>
            </div>
        </div>
    </div>
    <?php $__env->stopPush(); ?>

    <div class="grid grid-cols-12 gap-8">
        
        <div class="col-span-12 lg:col-span-4 space-y-6">
            <div class="relative group">
                <div class="absolute -inset-0.5 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-[2.5rem] blur opacity-10 group-hover:opacity-30 transition duration-500"></div>
                <div class="relative bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2.5rem] p-8 shadow-2xl">
                    
                    <div class="flex flex-col items-center text-center mb-8">
                        
                        <div class="w-24 h-24 rounded-full bg-gradient-to-br from-emerald-500 to-blue-500 flex items-center justify-center shadow-xl border-4 border-slate-900 mb-4">
                            <span class="text-3xl font-black text-white uppercase tracking-tighter">
                                <?php echo e(substr($user->username, 0, 2)); ?>

                            </span>
                        </div>
                        
                        <div class="flex items-center gap-2">
                            <h4 class="text-xl font-black text-slate-900 dark:text-white uppercase tracking-tighter"><?php echo e($user->fullname); ?></h4>
                            <?php if($user->userRanking && gs('user_ranking')): ?>
                                <img class="w-6 h-6 object-contain" src="<?php echo e(getImage(getFilePath('userRanking') . '/' . $user->userRanking->icon, getFileSize('userRanking'))); ?>" alt="rank">
                            <?php endif; ?>
                        </div>
                        <p class="text-[10px] font-black text-emerald-500 uppercase tracking-[0.2em] mt-1"><?php echo app('translator')->get('Verified Member'); ?></p>
                    </div>

                    <ul class="space-y-4 pt-6 border-t border-slate-100 dark:border-white/5">
                        <li class="flex justify-between items-center">
                            <span class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Username'); ?></span>
                            <span class="text-xs font-black text-slate-900 dark:text-white tracking-tight"><?php echo e($user->username); ?></span>
                        </li>
                        <li class="flex justify-between items-center">
                            <span class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Email'); ?></span>
                            <span class="text-xs font-black text-slate-900 dark:text-white tracking-tight"><?php echo e($user->email); ?></span>
                        </li>
                        <li class="flex justify-between items-center">
                            <span class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Mobile'); ?></span>
                            <span class="text-xs font-black text-slate-900 dark:text-white tracking-tight">+<?php echo e($user->mobileNumber); ?></span>
                        </li>
                        <li class="flex justify-between items-center">
                            <span class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Country'); ?></span>
                            <span class="text-xs font-black text-slate-900 dark:text-white tracking-tight"><?php echo e($user->country_name); ?></span>
                        </li>
                    </ul>

                    <div class="absolute bottom-0 left-0 right-0 h-1.5 bg-gradient-to-r from-emerald-500 to-blue-500"></div>
                </div>
            </div>
        </div>

        
        <div class="col-span-12 lg:col-span-8">
            <div class="relative group">
                <div class="absolute -inset-0.5 bg-gradient-to-b from-blue-500/20 to-transparent rounded-[2.5rem] blur-sm"></div>
                <div class="relative bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2.5rem] p-10 shadow-2xl">
                    
                    <form class="register space-y-8" method="post">
                        <?php echo csrf_field(); ?>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="space-y-2">
                                <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('First Name'); ?></label>
                                <input type="text" class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-emerald-500 transition-all outline-none" name="firstname" value="<?php echo e($user->firstname); ?>" required>
                            </div>
                            <div class="space-y-2">
                                <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Last Name'); ?></label>
                                <input type="text" class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-emerald-500 transition-all outline-none" name="lastname" value="<?php echo e($user->lastname); ?>" required>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="space-y-2">
                                <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Address'); ?></label>
                                <input type="text" class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-blue-500 transition-all outline-none" name="address" value="<?php echo e(@$user->address); ?>">
                            </div>
                            <div class="space-y-2">
                                <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('State'); ?></label>
                                <input type="text" class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-blue-500 transition-all outline-none" name="state" value="<?php echo e(@$user->state); ?>">
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="space-y-2">
                                <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Zip Code'); ?></label>
                                <input type="text" class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-emerald-500 transition-all outline-none" name="zip" value="<?php echo e(@$user->zip); ?>">
                            </div>
                            <div class="space-y-2">
                                <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('City'); ?></label>
                                <input type="text" class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-emerald-500 transition-all outline-none" name="city" value="<?php echo e(@$user->city); ?>">
                            </div>
                        </div>

                        <div class="pt-4">
                            <button type="submit" class="group relative w-full h-16 bg-slate-900 dark:bg-white rounded-2xl overflow-hidden transition-all active:scale-95 shadow-xl">
                                <div class="absolute inset-0 bg-gradient-to-r from-emerald-500 to-blue-500 opacity-0 group-hover:opacity-100 transition-opacity"></div>
                                <span class="relative text-[11px] font-black text-white dark:text-slate-900 uppercase tracking-[0.3em] group-hover:text-white"><?php echo app('translator')->get('Update Identity'); ?></span>
                            </button>
                        </div>
                    </form>

                    <div class="absolute bottom-0 left-0 right-0 h-1.5 bg-gradient-to-r from-blue-500 to-emerald-500"></div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script src="https://unpkg.com/lucide@latest"></script>
<script>
    "use strict";
    (function ($) {
        lucide.createIcons();
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/profile_setting.blade.php ENDPATH**/ ?>