<?php $__env->startSection('content'); ?>
<div class="px-4 mx-auto py-10">
    
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-10">
        <div class="bg-black rounded-2xl p-5 text-white shadow-xl flex flex-col justify-between">
            <p class="text-[9px] font-black uppercase tracking-[0.3em] opacity-50"><?php echo app('translator')->get('Total Liquidated'); ?></p>
            <h3 class="text-2xl font-light mt-2"><?php echo e(showAmount($successful)); ?></h3>
        </div>
        <div class="bg-white border border-gray-100 rounded-2xl p-5 shadow-sm flex flex-col justify-between">
            <p class="text-[9px] font-black text-gray-400 uppercase tracking-[0.3em]"><?php echo app('translator')->get('Pending Audit'); ?></p>
            <h3 class="text-2xl font-light text-black mt-2"><?php echo e(showAmount($pending)); ?></h3>
        </div>
        <div class="bg-white border border-gray-100 rounded-2xl p-5 shadow-sm flex flex-col justify-between">
            <p class="text-[9px] font-black text-gray-400 uppercase tracking-[0.3em]"><?php echo app('translator')->get('Rejected'); ?></p>
            <h3 class="text-2xl font-light text-rose-600 mt-2"><?php echo e(showAmount($rejected)); ?></h3>
        </div>
        <div class="bg-gray-50 border border-dashed border-gray-200 rounded-2xl p-5 flex items-center justify-center">
             <form action="" method="GET" class="w-full">
                <div class="relative">
                    <input type="text" name="search" value="<?php echo e(request()->search); ?>" placeholder="Search TRX..." class="w-full bg-transparent border-none text-xs font-bold focus:ring-0 p-0 placeholder:text-gray-300">
                    <i data-lucide="search" class="absolute right-0 top-1/2 -translate-y-1/2 w-4 h-4 text-gray-300"></i>
                </div>
            </form>
        </div>
    </div>

    <div class="bg-white border border-gray-100 rounded-[2rem] overflow-hidden shadow-2xl shadow-gray-200/50">
        <div class="overflow-x-auto">
            <table class="w-full text-left border-collapse">
                <thead>
                    <tr class="bg-gray-50/50 border-b border-gray-100">
                        <th class="px-8 py-5 text-[10px] font-black text-gray-400 uppercase tracking-widest"><?php echo app('translator')->get('Gateway | Transaction ID'); ?></th>
                        <th class="px-6 py-5 text-[10px] font-black text-gray-400 uppercase tracking-widest text-center"><?php echo app('translator')->get('Execution Date'); ?></th>
                        <th class="px-6 py-5 text-[10px] font-black text-gray-400 uppercase tracking-widest text-center"><?php echo app('translator')->get('Net Amount'); ?></th>
                        <th class="px-6 py-5 text-[10px] font-black text-gray-400 uppercase tracking-widest text-center"><?php echo app('translator')->get('Final Settlement'); ?></th>
                        <th class="px-6 py-5 text-[10px] font-black text-gray-400 uppercase tracking-widest text-center"><?php echo app('translator')->get('Status'); ?></th>
                        <th class="px-8 py-5 text-[10px] font-black text-gray-400 uppercase tracking-widest text-right"><?php echo app('translator')->get('Audit'); ?></th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-50">
                    <?php $__empty_1 = true; $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdraw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="group hover:bg-gray-50/50 transition-all duration-300">
                            <td class="px-8 py-6">
                                <div class="flex items-center gap-4">
                                    <div class="w-10 h-10 rounded-xl bg-white border border-gray-100 p-1.5 shadow-sm group-hover:scale-110 transition-transform">
                                        <img src="<?php echo e(getImage(getFilePath('withdrawMethod') . '/' . @$withdraw->method->image)); ?>" class="w-full h-full object-contain filter grayscale group-hover:grayscale-0 transition-all">
                                    </div>
                                    <div>
                                        <p class="text-xs font-black text-black uppercase tracking-tighter"><?php echo e(__(@$withdraw->method->name)); ?></p>
                                        <p class="text-[9px] font-mono text-gray-400 mt-1">#<?php echo e($withdraw->trx); ?></p>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-6 text-center">
                                <p class="text-[11px] font-bold text-black"><?php echo e(showDateTime($withdraw->created_at, 'd M, Y')); ?></p>
                                <p class="text-[9px] text-gray-400 uppercase tracking-tighter mt-1"><?php echo e(diffForHumans($withdraw->created_at)); ?></p>
                            </td>
                            <td class="px-6 py-6 text-center">
                                <p class="text-xs font-black text-black"><?php echo e(showAmount($withdraw->amount)); ?></p>
                                <p class="text-[9px] font-bold text-rose-500 mt-0.5">-<?php echo e(showAmount($withdraw->charge)); ?> <?php echo app('translator')->get('Fee'); ?></p>
                            </td>
                            <td class="px-6 py-6 text-center">
                                <p class="text-[10px] text-gray-400 font-bold uppercase tracking-tighter">@ <?php echo e(showAmount($withdraw->rate, 2)); ?></p>
                                <p class="text-xs font-black text-emerald-600 mt-0.5">
                                    <?php echo e(showAmount($withdraw->final_amount, currencyFormat: false)); ?> <?php echo e(__($withdraw->currency)); ?>

                                </p>
                            </td>
                            <td class="px-6 py-6 text-center">
                                <div class="flex justify-center">
                                    <?php echo $withdraw->statusBadge ?>
                                </div>
                            </td>
                            <td class="px-8 py-6 text-right">
                                <button class="detailBtn w-10 h-10 rounded-xl bg-gray-50 border border-gray-100 flex items-center justify-center text-black hover:bg-black hover:text-white transition-all shadow-sm active:scale-90"
                                    data-user_data="<?php echo e(json_encode($withdraw->withdraw_information)); ?>"
                                    <?php if($withdraw->status == 3): ?> data-admin_feedback="<?php echo e($withdraw->admin_feedback); ?>" <?php endif; ?>>
                                    <i data-lucide="shield-search" class="w-4 h-4"></i>
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td class="px-8 py-20 text-center" colspan="100%">
                                <div class="flex flex-col items-center opacity-20">
                                    <i data-lucide="inbox" class="w-12 h-12 mb-4"></i>
                                    <p class="text-[10px] font-black uppercase tracking-widest"><?php echo app('translator')->get('No transaction packets found'); ?></p>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <?php if($withdraws->hasPages()): ?>
        <div class="mt-8">
            <?php echo e(paginateLinks($withdraws)); ?>

        </div>
    <?php endif; ?>
</div>

<div id="tailwindModal" class="fixed inset-0 z-[100] hidden">
    <div class="absolute inset-0 bg-black/60 backdrop-blur-md backdrop-overlay"></div>
    <div class="absolute inset-0 flex items-center justify-center p-4">
        <div class="relative w-full max-w-lg bg-white rounded-[2.5rem] shadow-2xl overflow-hidden transform transition-all scale-95 opacity-0 duration-300" id="modalContainer">
            <div class="p-8 sm:p-12">
                <div class="flex justify-between items-start mb-8">
                    <div>
                        <p class="text-[10px] font-black text-gray-400 uppercase tracking-[0.4em] mb-1"><?php echo app('translator')->get('Audit Entry'); ?></p>
                        <h4 class="text-2xl font-light text-black tracking-tight uppercase"><?php echo app('translator')->get('Transaction Data'); ?></h4>
                    </div>
                    <button type="button" class="closeModal text-gray-400 hover:text-black transition-colors">
                        <i data-lucide="x" class="w-6 h-6"></i>
                    </button>
                </div>

                <div class="space-y-4 userData max-h-[40vh] overflow-y-auto pr-2 custom-scrollbar">
                    </div>

                <div class="feedback mt-6"></div>

                <button type="button" class="closeModal mt-10 w-full py-4 bg-black text-white rounded-xl text-[11px] font-black uppercase tracking-[0.3em] hover:bg-gray-800 transition-all">
                    <?php echo app('translator')->get('Close Audit'); ?>
                </button>
            </div>
        </div>
    </div>
</div>

<style>
    /* Premium Status Badges */
    .badge { padding: 6px 12px; border-radius: 8px; font-size: 9px; font-weight: 900; text-transform: uppercase; letter-spacing: 1px; }
    .badge--success { background: #ecfdf5; color: #059669; border: 1px solid #d1fae5; }
    .badge--warning { background: #fffbeb; color: #d97706; border: 1px solid #fef3c7; }
    .badge--danger { background: #fef2f2; color: #dc2626; border: 1px solid #fee2e2; }

    /* Modal Styling */
    .user-data-row { display: flex; justify-content: space-between; padding: 1rem 0; border-bottom: 1px solid #f3f4f6; }
    .user-data-label { font-size: 10px; font-weight: 800; color: #9ca3af; text-transform: uppercase; letter-spacing: 0.1em; }
    .user-data-value { font-size: 12px; font-weight: 700; color: #000; }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($activeTemplate . 'layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/user/withdraw/log.blade.php ENDPATH**/ ?>