<?php $__env->startSection('content'); ?>
<div class="min-h-screen py-20 px-4 flex items-center justify-center">
    <div class="relative w-full max-w-2xl">
        
        <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500 via-cyan-500 to-blue-500 rounded-[2.5rem] blur opacity-15"></div>
        
        <div class="relative bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2.5rem] shadow-2xl overflow-hidden">
            
            <div class="p-8 border-b border-slate-100 dark:border-white/5">
                <div class="flex items-center gap-5">
                    <div class="w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white border border-white/10 shadow-xl">
                        <i data-lucide="file-text" class="w-7 h-7 text-emerald-400"></i>
                    </div>
                    <div>
                        <h2 class="text-xl font-black text-slate-900 dark:text-white tracking-tighter uppercase leading-none">
                            <?php echo e($data->gateway->name); ?> <?php echo app('translator')->get('Terminal'); ?>
                        </h2>
                        <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-2"><?php echo app('translator')->get('Manual Asset Verification'); ?></p>
                    </div>
                </div>
            </div>

            <div class="p-8 md:p-10">
                <form action="<?php echo e(route('user.deposit.manual.update')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    
                    <div class="space-y-8">
                        <div class="relative group">
                            <div class="absolute -inset-0.5 bg-gradient-to-r from-emerald-500/20 to-cyan-500/20 rounded-2xl blur-sm"></div>
                            <div class="relative p-6 bg-emerald-500/5 border border-emerald-500/10 rounded-2xl">
                                <div class="flex items-start gap-4">
                                    <div class="mt-1">
                                        <i data-lucide="info" class="w-5 h-5 text-emerald-500"></i>
                                    </div>
                                    <p class="text-xs font-bold text-slate-600 dark:text-slate-300 leading-relaxed">
                                        <?php echo app('translator')->get('Requesting'); ?> <span class="text-emerald-500 font-black"><?php echo e(showAmount($data['amount'])); ?></span> <?php echo app('translator')->get('allocation.'); ?> 
                                        <br class="hidden md:block">
                                        <?php echo app('translator')->get('Final settlement required'); ?>: <span class="text-emerald-500 font-black"><?php echo e(showAmount($data['final_amount'], currencyFormat:false) .' '.$data['method_currency']); ?></span>
                                    </p>
                                </div>
                            </div>
                        </div>

                        <div class="prose prose-sm dark:prose-invert max-w-none bg-slate-50 dark:bg-white/5 p-6 rounded-2xl border border-slate-100 dark:border-white/5 text-slate-600 dark:text-slate-400 font-medium">
                            <div class="flex items-center gap-3 mb-4">
                                <span class="text-[10px] font-black text-slate-900 dark:text-white uppercase tracking-[0.3em]"><?php echo app('translator')->get('Transfer Instructions'); ?></span>
                                <div class="h-px flex-1 bg-slate-200 dark:bg-white/10"></div>
                            </div>
                            <?php echo $data->gateway->description ?>
                        </div>

                        <div class="space-y-6">
                            <div class="flex items-center gap-3">
                                <span class="text-[10px] font-black text-slate-900 dark:text-white uppercase tracking-[0.3em]"><?php echo app('translator')->get('Proof of Transfer'); ?></span>
                                <div class="h-px flex-1 bg-slate-200 dark:bg-white/10"></div>
                            </div>
                            
                            <div class="manual-form-wrapper">
                                <?php if (isset($component)) { $__componentOriginal3bd95de28203859144f617d3fb6afebc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3bd95de28203859144f617d3fb6afebc = $attributes; } ?>
<?php $component = App\View\Components\ViserForm::resolve(['identifier' => 'id','identifierValue' => ''.e($gateway->form_id).''] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('viser-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ViserForm::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3bd95de28203859144f617d3fb6afebc)): ?>
<?php $attributes = $__attributesOriginal3bd95de28203859144f617d3fb6afebc; ?>
<?php unset($__attributesOriginal3bd95de28203859144f617d3fb6afebc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3bd95de28203859144f617d3fb6afebc)): ?>
<?php $component = $__componentOriginal3bd95de28203859144f617d3fb6afebc; ?>
<?php unset($__componentOriginal3bd95de28203859144f617d3fb6afebc); ?>
<?php endif; ?>
                            </div>
                        </div>

                        <div class="pt-6">
                            <button type="submit" class="group relative w-full h-16 bg-slate-900 dark:bg-white rounded-2xl overflow-hidden transition-all active:scale-95 shadow-2xl">
                                <div class="absolute inset-0 bg-gradient-to-r from-emerald-500 to-cyan-500 opacity-0 group-hover:opacity-100 transition-opacity"></div>
                                <div class="relative flex items-center justify-center gap-3">
                                    <span class="text-[11px] font-black text-white dark:text-slate-900 uppercase tracking-[0.3em] group-hover:text-white">
                                        <?php echo app('translator')->get('Submit Verification Data'); ?>
                                    </span>
                                    <i data-lucide="send" class="w-4 h-4 text-emerald-400 dark:text-emerald-600 group-hover:text-white transition-all"></i>
                                </div>
                            </button>
                            <p class="text-center text-[9px] font-bold text-slate-400 uppercase tracking-widest mt-6 opacity-60">
                                <?php echo app('translator')->get('Manual audits usually complete within 1-6 hours'); ?>
                            </p>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
    /* Styling the dynamic form components to match our Black-Label style */
    .manual-form-wrapper label {
        display: block;
        font-size: 10px;
        font-weight: 900;
        text-transform: uppercase;
        letter-spacing: 0.15em;
        color: #94a3b8; /* slate-400 */
        margin-bottom: 0.75rem;
    }
    .manual-form-wrapper input, 
    .manual-form-wrapper select, 
    .manual-form-wrapper textarea {
        width: 100%;
        background-color: rgba(248, 250, 252, 0.5); /* slate-50/50 */
        border: 1px solid rgba(226, 232, 240, 1); /* slate-200 */
        border-radius: 1rem;
        padding: 1rem 1.25rem;
        font-size: 0.875rem;
        font-weight: 600;
        color: #1e293b; /* slate-800 */
        transition: all 0.2s;
        outline: none;
    }
    .dark .manual-form-wrapper input,
    .dark .manual-form-wrapper select,
    .dark .manual-form-wrapper textarea {
        background-color: rgba(255, 255, 255, 0.03);
        border-color: rgba(255, 255, 255, 0.08);
        color: #f8fafc;
    }
    .manual-form-wrapper input:focus {
        border-color: #10b981; /* emerald-500 */
        box-shadow: 0 0 0 4px rgba(16, 185, 129, 0.1);
    }
</style>

<script src="https://unpkg.com/lucide@latest"></script>
<script>
    lucide.createIcons();
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/payment/manual.blade.php ENDPATH**/ ?>