<?php $__env->startSection('content'); ?>
    <?php
        $kyc = getContent('kyc.content', true);
    ?>
    <div class="max-w-7xl mx-auto">
        <!-- Enhanced Welcome Section -->
        <div
            class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
                <div class="absolute bottom-0 left-0 w-24 h-24 bg-white rounded-full translate-y-12 -translate-x-12"></div>
            </div>

            <div class="relative z-10">
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                    <div class="mb-4 lg:mb-0 lg:flex-1">
                        <h1 class="text-xl font-light mb-1">Welcome back, <?php echo e(auth()->user()->fullname); ?></h1>
                        <p class="text-gray-300 text-sm">Track your investments, manage your portfolio, and explore
                            opportunities.</p>
                    </div>

                    <!-- Enhanced Wallet Card -->
                    <div
                        class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-80">
                        <div class="flex items-center justify-between mb-3">
                            <div>
                                <p class="text-xs text-gray-300 mb-1">Available Balance</p>
                                <p class="text-xl font-light" data-balance-target="dashboard-available-balance"
                                    data-balance-amount="0.00">
                                    <?php echo e(showAmount($user->deposit_wallet)); ?>

                                </p>
                                <p class="text-[11px] text-gray-200 mt-1" data-btc-target="dashboard-available-balance">—
                                </p>
                            </div>
                            <div class="w-10 h-10 bg-white bg-opacity-20 rounded-lg flex items-center justify-center">
                                <i data-lucide="wallet" class="w-5 h-5"></i>
                            </div>
                        </div>
                        <div class="flex space-x-2">
                            <a href="<?php echo e(route('user.deposit.index')); ?>"
                                class="flex-1 bg-white bg-opacity-20 hover:bg-opacity-30 text-white text-xs font-medium py-1.5 px-3 rounded-md transition-all duration-200">
                                <i data-lucide="plus" class="w-3 h-3 inline mr-1"></i>
                                Deposit
                            </a>
                            <a href="<?php echo e(route('user.withdraw')); ?>"
                                class="flex-1 bg-white bg-opacity-20 hover:bg-opacity-30 text-white text-xs font-medium py-1.5 px-3 rounded-md transition-all duration-200">
                                <i data-lucide="minus" class="w-3 h-3 inline mr-1"></i>
                                Withdraw
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <!-- Enhanced Portfolio Overview Cards -->
        <div class="grid grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
            <!-- Total Portfolio Value -->
            <div
                class="bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 group">
                <div class="flex items-center justify-between">
                    <div class="flex-1">
                        <p class="text-xs font-medium text-gray-500 mb-1">Portfolio Value</p>
                        <p class="text-lg font-light text-black mb-1" data-balance-target="dashboard-portfolio-value"
                            data-balance-amount="0">
                           <?php echo e(showAmount($user->interest_wallet)); ?>

                        </p>
                        <p class="text-[11px] text-gray-500" data-btc-target="dashboard-portfolio-value">—</p>
                        <p class="text-xs text-green-600">
                            +0.0% this month
                        </p>
                    </div>
                    <div class="flex flex-col items-end space-y-1">
                        <div
                            class="w-10 h-10 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                            <i data-lucide="trending-up" class="w-5 h-5 text-green-500"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Investment Holdings -->
            <div
                class="bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 group">
                <div class="flex items-center justify-between">
                    <div class="flex-1">
                        <p class="text-xs font-medium text-gray-500 mb-1">Investments</p>
                        <p class="text-lg font-light text-black mb-1" data-balance-target="dashboard-investments-total"
                            data-balance-amount="0">
                           <?php echo e(showAmount($totalInvest)); ?>

                        </p>
                        <p class="text-[11px] text-gray-500" data-btc-target="dashboard-investments-total">—</p>
                        <p class="text-xs text-blue-600">0 active investments</p>
                    </div>
                    <div class="flex flex-col items-end space-y-1">
                        <div
                            class="w-10 h-10 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                            <i data-lucide="pie-chart" class="w-5 h-5 text-blue-500"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Stock Holdings -->
            <div
                class="bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 group">
                <div class="flex items-center justify-between">
                    <div class="flex-1">
                        <p class="text-xs font-medium text-gray-500 mb-1">Stock Holdings</p>
                        <p class="text-lg font-light text-black mb-1" data-balance-target="dashboard-stock-holdings"
                            data-balance-amount="0">
                           <?php echo e(showAmount($totalStock)); ?>

                        </p>
                        <p class="text-[11px] text-gray-500" data-btc-target="dashboard-stock-holdings">—</p>
                        <p class="text-xs text-purple-600"><?php echo e($totalStocks); ?> stock positions</p>
                    </div>
                    <div class="flex flex-col items-end space-y-1">
                        <div
                            class="w-10 h-10 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                            <i data-lucide="bar-chart-3" class="w-5 h-5 text-purple-500"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Total Orders -->
            <div
                class="bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 group">
                <div class="flex items-center justify-between">
                    <div class="flex-1">
                        <p class="text-xs font-medium text-gray-500 mb-1">Tesla Vehicles</p>
                        <p class="text-lg font-medium text-black mb-1"><?php echo e($totalCars); ?></p>
                        <p class="text-xs text-red-600">Electric fleet</p>
                    </div>
                    <div class="flex flex-col items-end space-y-1">
                        <div
                            class="w-10 h-10 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                            <i data-lucide="car" class="w-5 h-5 text-red-500"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Enhanced Quick Actions Grid -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-3 mb-6">
            <!-- Browse Cars -->
            <a href="<?php echo e(route('cars')); ?>"
                class="group bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 hover:scale-105 relative overflow-hidden">
                <div
                    class="absolute inset-0 bg-gradient-to-br from-blue-50 to-blue-100 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                </div>
                <div class="relative z-10">
                    <div
                        class="w-10 h-10 flex items-center justify-center mb-3 group-hover:scale-110 transition-transform duration-300">
                        <i data-lucide="car" class="w-5 h-5 text-blue-500"></i>
                    </div>
                    <h3 class="font-medium text-black text-sm mb-1">Browse Cars</h3>
                    <p class="text-xs text-gray-500 mb-2">Explore our inventory</p>
                    <div class="flex items-center text-blue-600 text-xs font-medium">
                        <span>View Inventory</span>
                        <i data-lucide="arrow-right"
                            class="w-3 h-3 ml-1 group-hover:translate-x-1 transition-transform duration-200"></i>
                    </div>
                </div>
            </a>

            <!-- Investments -->
            <a href="<?php echo e(route('plan')); ?>"
                class="group bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 hover:scale-105 relative overflow-hidden">
                <div
                    class="absolute inset-0 bg-gradient-to-br from-green-50 to-green-100 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                </div>
                <div class="relative z-10">
                    <div
                        class="w-10 h-10 flex items-center justify-center mb-3 group-hover:scale-110 transition-transform duration-300">
                        <i data-lucide="trending-up" class="w-5 h-5 text-green-500"></i>
                    </div>
                    <h3 class="font-medium text-black text-sm mb-1">Investments</h3>
                    <p class="text-xs text-gray-500 mb-2">Grow your wealth</p>
                    <div class="flex items-center text-green-600 text-xs font-medium">
                        <span>Start Investing</span>
                        <i data-lucide="arrow-right"
                            class="w-3 h-3 ml-1 group-hover:translate-x-1 transition-transform duration-200"></i>
                    </div>
                </div>
            </a>

            <!-- Stocks -->
            <a href="#"
                class="group bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 hover:scale-105 relative overflow-hidden">
                <div
                    class="absolute inset-0 bg-gradient-to-br from-purple-50 to-purple-100 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                </div>
                <div class="relative z-10">
                    <div
                        class="w-10 h-10 flex items-center justify-center mb-3 group-hover:scale-110 transition-transform duration-300">
                        <i data-lucide="bar-chart-3" class="w-5 h-5 text-purple-500"></i>
                    </div>
                    <h3 class="font-medium text-black text-sm mb-1">Stocks</h3>
                    <p class="text-xs text-gray-500 mb-2">Trade individual stocks</p>
                    <div class="flex items-center text-purple-600 text-xs font-medium">
                        <span>Trade Stocks</span>
                        <i data-lucide="arrow-right"
                            class="w-3 h-3 ml-1 group-hover:translate-x-1 transition-transform duration-200"></i>
                    </div>
                </div>
            </a>

            <!-- Portfolio -->
            <a href="<?php echo e(route('user.invest.statistics')); ?>"
                class="group bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 hover:scale-105 relative overflow-hidden">
                <div
                    class="absolute inset-0 bg-gradient-to-br from-orange-50 to-orange-100 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                </div>
                <div class="relative z-10">
                    <div
                        class="w-10 h-10 flex items-center justify-center mb-3 group-hover:scale-110 transition-transform duration-300">
                        <i data-lucide="pie-chart" class="w-5 h-5 text-orange-500"></i>
                    </div>
                    <h3 class="font-medium text-black text-sm mb-1">Portfolio</h3>
                    <p class="text-xs text-gray-500 mb-2">View your holdings</p>
                    <div class="flex items-center text-orange-600 text-xs font-medium">
                        <span>View Portfolio</span>
                        <i data-lucide="arrow-right"
                            class="w-3 h-3 ml-1 group-hover:translate-x-1 transition-transform duration-200"></i>
                    </div>
                </div>
            </a>
        </div>

        <!-- Enhanced Activity Section -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 mb-6">
            <!-- Recent Orders -->
            <div class="bg-white rounded-xl p-5 shadow-sm border border-gray-100 lg:col-span-2">
                <div class="flex items-center justify-between mb-4">
                    <div>
                        <h3 class="text-lg font-light text-black mb-1">Recent Orders</h3>
                        <p class="text-xs text-gray-500">Your latest Tesla purchases</p>
                    </div>
                    <a href="<?php echo e(route('user.transactions')); ?>?cars"
                        class="text-xs text-black hover:text-gray-600 transition-colors duration-200 font-medium">
                        View All
                        <i data-lucide="arrow-right" class="w-3 h-3 inline ml-1"></i>
                    </a>
                </div>

                <div class="space-y-3">
                    <div
                        class="flex items-center space-x-3 p-3 bg-gray-50 rounded-lg hover:bg-gray-100 transition-colors duration-200 group">
                        <div class="w-10 h-10 bg-gray-200 rounded-lg overflow-hidden flex-shrink-0">
                            <img src="https://www.tesinvspf.com/storage/cars/Xn1Fcvg8pZLKIMuu0CEXqPeqd6MTEsqF3It1Cfwt.jpg"
                                alt="Tesla Model Y" class="w-full h-full object-cover">
                        </div>

                        <div class="flex-1 min-w-0">
                            <h4 class="font-medium text-black text-sm truncate">Tesla Model Y</h4>
                            <p class="text-xs text-gray-600">2024 Tesla Model Y</p>
                            <p class="text-xs text-gray-500">Feb 21, 2026</p>
                        </div>

                        <div class="text-right">
                            <p class="font-medium text-black text-sm">$46,630.00</p>
                            <span
                                class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                Pending
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Market Overview -->
            <div class="bg-white rounded-xl p-5 shadow-sm border border-gray-100">
                <div class="flex items-center justify-between mb-4">
                    <div>
                        <h3 class="text-lg font-light text-black mb-1">Market Overview</h3>
                        <p class="text-xs text-gray-500">Live market data</p>
                    </div>
                    <a href="#"
                        class="text-xs text-black hover:text-gray-600 transition-colors duration-200 font-medium">
                        View All
                        <i data-lucide="arrow-right" class="w-3 h-3 inline ml-1"></i>
                    </a>
                </div>

                <div class="space-y-3">
                    <div
                        class="flex items-center justify-between p-3 bg-gradient-to-r from-green-50 to-green-100 rounded-lg border border-green-200">
                        <div class="flex items-center space-x-2">
                            <div class="w-8 h-8 rounded-lg flex items-center justify-center overflow-hidden">
                                <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/TMO.png"
                                    alt="TMO" class="w-full h-full object-cover"
                                    onerror="this.src='data:image/svg+xml;base64,PHN2ZyB3aWR0aD0nMzInIGhlaWdodD0nMzInIHhtbG5zPSdodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2Zyc+PGNpcmNsZSBjeD0nMTYnIGN5PScxNicgcj0nMTYnIGZpbGw9J2dyZWVuJy8+PHRleHQgeD0nMTYnIHk9JzIwJyB0ZXh0LWFuY2hvcj0nbWlkZGxlJyBmaWxsPSd3aGl0ZScgZm9udC1mYW1pbHk9J0FyaWFsJyBmb250LXNpemU9JzEyJyBmb250LXdlaWdodD0nYm9sZCc+VDwvdGV4dD48L3N2Zz4='"
                                    loading="lazy">
                            </div>
                            <div>
                                <h4 class="font-medium text-black text-xs">Thermo Fisher Scientific</h4>
                                <p class="text-xs text-gray-600">TMO</p>
                            </div>
                        </div>
                        <div class="text-right">
                            <p class="font-medium text-black text-xs">$525.80</p>
                            <p class="text-xs text-green-600 font-medium">+5.00%</p>
                        </div>
                    </div>
                    <div
                        class="flex items-center justify-between p-3 bg-gradient-to-r from-green-50 to-green-100 rounded-lg border border-green-200">
                        <div class="flex items-center space-x-2">
                            <div class="w-8 h-8 rounded-lg flex items-center justify-center overflow-hidden">
                                <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/NVDA.png"
                                    alt="NVDA" class="w-full h-full object-cover"
                                    onerror="this.src='data:image/svg+xml;base64,PHN2ZyB3aWR0aD0nMzInIGhlaWdodD0nMzInIHhtbG5zPSdodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2Zyc+PGNpcmNsZSBjeD0nMTYnIGN5PScxNicgcj0nMTYnIGZpbGw9J2dyZWVuJy8+PHRleHQgeD0nMTYnIHk9JzIwJyB0ZXh0LWFuY2hvcj0nbWlkZGxlJyBmaWxsPSd3aGl0ZScgZm9udC1mYW1pbHk9J0FyaWFsJyBmb250LXNpemU9JzEyJyBmb250LXdlaWdodD0nYm9sZCc+TjwvdGV4dD48L3N2Zz4='"
                                    loading="lazy">
                            </div>
                            <div>
                                <h4 class="font-medium text-black text-xs">NVIDIA Corporation</h4>
                                <p class="text-xs text-gray-600">NVDA</p>
                            </div>
                        </div>
                        <div class="text-right">
                            <p class="font-medium text-black text-xs">$182.70</p>
                            <p class="text-xs text-green-600 font-medium">+4.94%</p>
                        </div>
                    </div>
                    <div
                        class="flex items-center justify-between p-3 bg-gradient-to-r from-green-50 to-green-100 rounded-lg border border-green-200">
                        <div class="flex items-center space-x-2">
                            <div class="w-8 h-8 rounded-lg flex items-center justify-center overflow-hidden">
                                <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/PYPL.png"
                                    alt="PYPL" class="w-full h-full object-cover"
                                    onerror="this.src='data:image/svg+xml;base64,PHN2ZyB3aWR0aD0nMzInIGhlaWdodD0nMzInIHhtbG5zPSdodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2Zyc+PGNpcmNsZSBjeD0nMTYnIGN5PScxNicgcj0nMTYnIGZpbGw9J2dyZWVuJy8+PHRleHQgeD0nMTYnIHk9JzIwJyB0ZXh0LWFuY2hvcj0nbWlkZGxlJyBmaWxsPSd3aGl0ZScgZm9udC1mYW1pbHk9J0FyaWFsJyBmb250LXNpemU9JzEyJyBmb250LXdlaWdodD0nYm9sZCc+UDwvdGV4dD48L3N2Zz4='"
                                    loading="lazy">
                            </div>
                            <div>
                                <h4 class="font-medium text-black text-xs">PayPal Holdings Inc.</h4>
                                <p class="text-xs text-gray-600">PYPL</p>
                            </div>
                        </div>
                        <div class="text-right">
                            <p class="font-medium text-black text-xs">$65.40</p>
                            <p class="text-xs text-green-600 font-medium">+4.86%</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Enhanced Performance Chart -->
        <div class="bg-white rounded-xl p-5 shadow-sm border border-gray-100 mb-6">
            <div class="flex items-center justify-between mb-4">
                <div>
                    <h3 class="text-lg font-light text-black mb-1">Stock Market Performance</h3>
                    <p class="text-xs text-gray-500">Top stocks over the last 30 days</p>
                </div>
            </div>

            <!-- Real Chart -->
            <div class="relative">
                <canvas id="stockChart" class="w-full h-64"></canvas>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        // Chart data from backend
        const chartData = {
            "labels": ["Jan 23", "Jan 24", "Jan 25", "Jan 26", "Jan 27", "Jan 28", "Jan 29", "Jan 30", "Jan 31",
                "Feb 1", "Feb 2", "Feb 3", "Feb 4", "Feb 5", "Feb 6", "Feb 7", "Feb 8", "Feb 9", "Feb 10", "Feb 11",
                "Feb 12", "Feb 13", "Feb 14", "Feb 15", "Feb 16", "Feb 17", "Feb 18", "Feb 19", "Feb 20", "Feb 21"
            ],
            "datasets": [{
                "label": "PYPL",
                "data": [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0
                ],
                "borderColor": "#3B82F6",
                "backgroundColor": "#3B82F620",
                "borderWidth": 2,
                "fill": false,
                "tension": 0.40000000000000002220446049250313080847263336181640625,
                "pointRadius": 0,
                "pointHoverRadius": 4
            }, {
                "label": "FTNT",
                "data": [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0
                ],
                "borderColor": "#10B981",
                "backgroundColor": "#10B98120",
                "borderWidth": 2,
                "fill": false,
                "tension": 0.40000000000000002220446049250313080847263336181640625,
                "pointRadius": 0,
                "pointHoverRadius": 4
            }, {
                "label": "WFC",
                "data": [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0
                ],
                "borderColor": "#F59E0B",
                "backgroundColor": "#F59E0B20",
                "borderWidth": 2,
                "fill": false,
                "tension": 0.40000000000000002220446049250313080847263336181640625,
                "pointRadius": 0,
                "pointHoverRadius": 4
            }, {
                "label": "ABNB",
                "data": [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0
                ],
                "borderColor": "#EF4444",
                "backgroundColor": "#EF444420",
                "borderWidth": 2,
                "fill": false,
                "tension": 0.40000000000000002220446049250313080847263336181640625,
                "pointRadius": 0,
                "pointHoverRadius": 4
            }, {
                "label": "JPM",
                "data": [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0
                ],
                "borderColor": "#8B5CF6",
                "backgroundColor": "#8B5CF620",
                "borderWidth": 2,
                "fill": false,
                "tension": 0.40000000000000002220446049250313080847263336181640625,
                "pointRadius": 0,
                "pointHoverRadius": 4
            }]
        };

        // Initialize chart
        const ctx = document.getElementById('stockChart').getContext('2d');
        const stockChart = new Chart(ctx, {
            type: 'line',
            data: chartData,
            options: {
                responsive: true,
                maintainAspectRatio: false,
                interaction: {
                    intersect: false,
                    mode: 'index',
                },
                plugins: {
                    legend: {
                        position: 'top',
                        labels: {
                            usePointStyle: true,
                            padding: 20,
                            font: {
                                size: 12,
                                family: 'Inter, system-ui, sans-serif'
                            }
                        }
                    },
                    tooltip: {
                        backgroundColor: 'rgba(0, 0, 0, 0.8)',
                        titleColor: '#fff',
                        bodyColor: '#fff',
                        borderColor: 'rgba(255, 255, 255, 0.1)',
                        borderWidth: 1,
                        cornerRadius: 8,
                        displayColors: true,
                        callbacks: {
                            label: function(context) {
                                return context.dataset.label + ': $' + context.parsed.y.toFixed(2);
                            }
                        }
                    }
                },
                scales: {
                    x: {
                        display: true,
                        grid: {
                            display: false
                        },
                        ticks: {
                            maxTicksLimit: 8,
                            font: {
                                size: 11,
                                family: 'Inter, system-ui, sans-serif'
                            }
                        }
                    },
                    y: {
                        display: true,
                        position: 'right',
                        grid: {
                            color: 'rgba(0, 0, 0, 0.05)',
                            drawBorder: false
                        },
                        ticks: {
                            callback: function(value) {
                                return '$' + value.toFixed(0);
                            },
                            font: {
                                size: 11,
                                family: 'Inter, system-ui, sans-serif'
                            }
                        }
                    }
                },
                elements: {
                    point: {
                        radius: 0,
                        hoverRadius: 4,
                        hoverBorderWidth: 2
                    }
                }
            }
        });

        // Add some interactive functionality
        document.addEventListener('DOMContentLoaded', function() {
            // Animate numbers on load
            const animateValue = (element, start, end, duration) => {
                let startTimestamp = null;
                const step = (timestamp) => {
                    if (!startTimestamp) startTimestamp = timestamp;
                    const progress = Math.min((timestamp - startTimestamp) / duration, 1);
                    const current = Math.floor(progress * (end - start) + start);
                    element.textContent = '$' + current.toLocaleString();
                    if (progress < 1) {
                        window.requestAnimationFrame(step);
                    }
                };
                window.requestAnimationFrame(step);
            };

            // Animate portfolio values
            const portfolioElements = document.querySelectorAll('.text-lg.font-light');
            portfolioElements.forEach(element => {
                const text = element.textContent;
                const value = parseInt(text.replace(/[^0-9]/g, ''));
                if (value > 0) {
                    animateValue(element, 0, value, 2000);
                }
            });
        });

        document.addEventListener('DOMContentLoaded', function() {
            const notificationBanner = document.getElementById('admin-dashboard-notification');
            if (!notificationBanner) {
                return;
            }

            const dismissButton = notificationBanner.querySelector('[data-dismiss-popup]');
            const dismissUrl = notificationBanner.dataset.dismissUrl;
            const csrf = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

            const dismiss = () => {
                notificationBanner.classList.add('opacity-0', 'translate-y-1');
                setTimeout(() => notificationBanner.remove(), 200);
            };

            dismissButton?.addEventListener('click', () => {
                fetch(dismissUrl, {
                    method: 'PATCH',
                    headers: {
                        'X-CSRF-TOKEN': csrf,
                        'Accept': 'application/json',
                    },
                }).finally(dismiss);
            });
        });
    </script>
    <script>
        (function() {
            if (window.__btcRateScriptLoaded) {
                if (typeof window.reinitializeBtcBalanceWatchers === 'function') {
                    window.reinitializeBtcBalanceWatchers();
                }
                return;
            }

            window.__btcRateScriptLoaded = true;

            const BTC_SOURCES = [
                () => fetch('https://api.coindesk.com/v1/bpi/currentprice/BTC.json')
                .then((res) => res.ok ? res.json() : Promise.reject(res))
                .then((json) => json?.bpi?.USD?.rate_float ?? null),
                () => fetch('https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=usd')
                .then((res) => res.ok ? res.json() : Promise.reject(res))
                .then((json) => json?.bitcoin?.usd ?? null),
            ];

            let registries = [];
            let currentRate = null;

            const markUnavailable = () => {
                document.querySelectorAll('[data-btc-target]').forEach((node) => {
                    node.textContent = 'BTC rate unavailable';
                });
            };

            const formatBtc = (usdValue) => {
                if (!currentRate || currentRate <= 0) {
                    return null;
                }

                const btcValue = usdValue / currentRate;
                if (!isFinite(btcValue)) {
                    return null;
                }

                return btcValue.toLocaleString(undefined, {
                    minimumFractionDigits: 6,
                    maximumFractionDigits: 6,
                });
            };

            const updateDisplay = (targetName, usdValue) => {
                const displayNode = document.querySelector(`[data-btc-target="${targetName}"]`);
                if (!displayNode) {
                    return;
                }

                const formatted = formatBtc(usdValue);
                if (formatted === null) {
                    markUnavailable();
                    return;
                }

                displayNode.textContent = `≈ ${formatted} BTC`;
                displayNode.dataset.lastUsdValue = usdValue;
            };

            const extractUsd = (node) => {
                const explicit = node.dataset.balanceAmount;
                if (explicit !== undefined) {
                    const parsed = parseFloat(explicit);
                    return isNaN(parsed) ? 0 : parsed;
                }

                const numeric = (node.textContent || '').replace(/[^0-9.\-]/g, '');
                const parsed = parseFloat(numeric);
                return isNaN(parsed) ? 0 : parsed;
            };

            const registerNode = (node) => {
                const targetName = node.dataset.balanceTarget;
                if (!targetName) {
                    return;
                }

                const refresh = () => {
                    const usdValue = extractUsd(node);
                    updateDisplay(targetName, usdValue);
                };

                const observer = new MutationObserver(() => refresh());
                observer.observe(node, {
                    childList: true,
                    characterData: true,
                    subtree: true,
                    attributes: true,
                    attributeFilter: ['data-balance-amount'],
                });

                registries.push({
                    node,
                    observer,
                    refresh
                });
            };

            const scanNodes = () => {
                registries.forEach(({
                    observer
                }) => observer.disconnect());
                registries = [];
                document.querySelectorAll('[data-balance-target]').forEach(registerNode);
            };

            const applyRate = (rate) => {
                currentRate = rate;
                registries.forEach(({
                    refresh
                }) => refresh());
            };

            const fetchRate = async () => {
                for (const source of BTC_SOURCES) {
                    try {
                        const rate = await source();
                        if (rate && rate > 0) {
                            applyRate(rate);
                            return;
                        }
                    } catch (error) {
                        console.warn('BTC rate source failed', error);
                    }
                }

                markUnavailable();
            };

            const init = () => {
                scanNodes();
                fetchRate();
                setInterval(fetchRate, 60000);
            };

            window.refreshBtcEquivalents = () => registries.forEach(({
                refresh
            }) => refresh());
            window.reinitializeBtcBalanceWatchers = () => {
                scanNodes();
                window.refreshBtcEquivalents();
            };

            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', init);
            } else {
                init();
            }
        })();
    </script>


    <?php if($user->kv == Status::KYC_UNVERIFIED && $user->kyc_rejection_reason): ?>
        <div class="modal fade" id="kycRejectionReason">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo app('translator')->get('KYC Document Rejection Reason'); ?></h5>
                        <button type="button" class="close" data-bs-dismiss="modal">
                            <i class="las la-times"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p><?php echo e($user->kyc_rejection_reason); ?></p>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {
            <?php if($isHoliday): ?>
                function createCountDown(elementId, sec) {
                    var tms = sec;
                    var x = setInterval(function() {
                        var distance = tms * 1000;
                        var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                        var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                        var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                        var seconds = Math.floor((distance % (1000 * 60)) / 1000);
                        var days = `<span>${days}d</span>`;
                        var hours = `<span>${hours}h</span>`;
                        var minutes = `<span>${minutes}m</span>`;
                        var seconds = `<span>${seconds}s</span>`;
                        document.getElementById(elementId).innerHTML = days + ' ' + hours + " " + minutes +
                            " " + seconds;
                        if (distance < 0) {
                            clearInterval(x);
                            document.getElementById(elementId).innerHTML = "COMPLETE";
                        }
                        tms--;
                    }, 1000);
                }
                createCountDown('counter', <?php echo e(abs(\Carbon\Carbon::parse($nextWorkingDay)->diffInSeconds())); ?>);
            <?php endif; ?>
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('Template::layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/user/dashboard.blade.php ENDPATH**/ ?>