<div id="confirmationModal" class="hidden fixed inset-0 z-[10000] flex items-center justify-center p-4">
    <div class="absolute inset-0 bg-slate-900/60 backdrop-blur-sm opacity-0 transition-opacity duration-300" id="confirmBackdrop"></div>

    <div class="relative w-full max-w-md bg-white dark:bg-slate-900 rounded-xl border border-slate-200 dark:border-white/10 shadow-2xl overflow-hidden transform scale-95 opacity-0 transition-all duration-300" id="confirmContent">
        
        <form method="POST" class="m-0">
            <?php echo csrf_field(); ?>
            <div class="p-6 border-b border-slate-100 dark:border-white/5 flex justify-between items-center bg-slate-50/50 dark:bg-slate-800/30">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-amber-500/10 rounded-lg flex items-center justify-center text-amber-500">
                        <i data-lucide="alert-triangle" class="w-5 h-5"></i>
                    </div>
                    <h5 class="text-sm font-black text-slate-900 dark:text-white uppercase tracking-widest"><?php echo app('translator')->get('Confirmation Alert'); ?></h5>
                </div>
                <button type="button" class="closeConfirm text-slate-400 hover:text-slate-900 dark:hover:text-white transition-colors">
                    <i data-lucide="x" class="w-5 h-5"></i>
                </button>
            </div>

            <div class="p-8 text-center">
                <p class="question text-sm font-bold text-slate-600 dark:text-slate-300 leading-relaxed"></p>
                <?php if(isset($slot)): ?>
                    <div class="mt-4">
                        <?php echo e($slot); ?>

                    </div>
                <?php endif; ?>
            </div>

            <div class="p-6 bg-slate-50/50 dark:bg-slate-800/30 flex gap-3">
                <button type="button" class="closeConfirm flex-1 py-3 px-6 rounded-lg bg-white dark:bg-white/5 border border-slate-200 dark:border-white/10 text-[10px] font-black uppercase tracking-widest text-slate-500 hover:bg-slate-100 dark:hover:bg-white/10 transition-all">
                    <?php echo app('translator')->get('No, Abort'); ?>
                </button>
                <button type="submit" class="flex-1 py-3 px-6 rounded-lg bg-slate-900 dark:bg-white text-white dark:text-slate-900 text-[10px] font-black uppercase tracking-widest hover:bg-emerald-600 dark:hover:bg-emerald-500 transition-all shadow-lg">
                    <?php echo app('translator')->get('Yes, Confirm'); ?>
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->startPush('script'); ?>
<script>
    (function ($) {
        "use strict";

        const modal = $('#confirmationModal');
        const backdrop = $('#confirmBackdrop');
        const content = $('#confirmContent');

        $(document).on('click', '.confirmationBtn', function (e) {
            e.preventDefault();
            let data = $(this).data();
            
            // Set Data
            modal.find('.question').text(`${data.question}`);
            modal.find('form').attr('action', `${data.action}`);

            // Tailwind Open Sequence
            modal.removeClass('hidden').addClass('flex');
            setTimeout(() => {
                backdrop.removeClass('opacity-0').addClass('opacity-100');
                content.removeClass('opacity-0 scale-95').addClass('opacity-100 scale-100');
            }, 10);
        });

        // Close Logic
        function closeConfirmModal() {
            backdrop.removeClass('opacity-100').addClass('opacity-0');
            content.removeClass('opacity-100 scale-100').addClass('opacity-0 scale-95');
            setTimeout(() => modal.addClass('hidden').removeClass('flex'), 300);
        }

        $(document).on('click', '.closeConfirm, #confirmBackdrop', function () {
            closeConfirmModal();
        });

    })(jQuery);
</script>
<?php $__env->stopPush(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/components/confirmation-modal2.blade.php ENDPATH**/ ?>