<?php $__env->startSection('content'); ?>
<div class="px-4 mx-auto py-2">

    
    <?php $__env->startPush('breadcrumb_text'); ?>
    <div class="flex flex-col md:flex-row md:items-center justify-between gap-6 mb-12 px-4">
        <div class="flex items-center gap-5">
            <div class="relative group">
                <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-2xl blur opacity-25"></div>
                <div class="relative w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white border border-white/10 shadow-2xl">
                    <i data-lucide="megaphone" class="w-7 h-7 text-emerald-400"></i>
                </div>
            </div>
            <div>
                <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase"><?php echo app('translator')->get('Promotional Tools'); ?></h2>
                <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-1"><?php echo app('translator')->get('Deploy marketing banners & tracking nodes'); ?></p>
            </div>
        </div>
    </div>
    <?php $__env->stopPush(); ?>

    
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
        <?php $__currentLoopData = $banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="relative group">
                
                <div class="absolute -inset-0.5 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-[2.5rem] blur opacity-10 group-hover:opacity-30 transition duration-500"></div>
                
                <div class="relative h-full bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2.5rem] overflow-hidden flex flex-col shadow-2xl">
                    
                    
                    <div class="p-6">
                        <div class="relative aspect-video rounded-3xl overflow-hidden bg-slate-100 dark:bg-white/5 border border-slate-200 dark:border-white/5">
                            <img src="<?php echo e(getImage(fileManager()->promotions()->path.  '/'. @$banner->banner)); ?>" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-700">
                            <div class="absolute inset-0 bg-gradient-to-t from-slate-950/60 to-transparent opacity-0 group-hover:opacity-100 transition-opacity flex items-end p-4">
                                <span class="text-[9px] font-black text-white uppercase tracking-widest"><?php echo app('translator')->get('Asset Preview'); ?></span>
                            </div>
                        </div>
                    </div>

                    
                    <div class="px-8 pb-10 flex-1 flex flex-col">
                        <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest mb-3 flex items-center gap-2">
                            <i data-lucide="code-2" class="w-3 h-3 text-blue-500"></i> <?php echo app('translator')->get('HTML Embed Code'); ?>
                        </label>
                        
                        <?php
                            $string = '<a href="'.route('home').'?reference='.auth()->user()->username.'" target="_blank"> <img src="'.getImage(fileManager()->promotions()->path.  '/'. @$banner->banner) .'" alt="image"/></a>';
                        ?>

                        <div class="relative flex-1">
                            <textarea id="reflink<?php echo e($banner->id); ?>" class="w-full bg-slate-50 dark:bg-slate-950 border border-slate-100 dark:border-white/5 rounded-2xl p-4 text-[11px] font-mono text-slate-600 dark:text-emerald-500/80 leading-relaxed resize-none h-32 focus:ring-1 focus:ring-emerald-500 outline-none transition-all" readonly><?php echo e($string); ?></textarea>
                            
                            
                            <button type="button" data-copytarget="#reflink<?php echo e($banner->id); ?>" class="copybtn absolute bottom-3 right-3 p-3 bg-slate-900 dark:bg-white text-white dark:text-slate-900 rounded-xl hover:bg-emerald-500 dark:hover:bg-emerald-500 hover:text-white transition-all shadow-lg active:scale-90">
                                <i data-lucide="copy" class="w-4 h-4"></i>
                            </button>
                        </div>
                    </div>

                    
                    <div class="absolute bottom-0 left-0 right-0 h-1.5 bg-gradient-to-r from-emerald-500 to-blue-500"></div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<style>
    /* Flash effect for copied state */
    .copybtn.copied {
        background-color: #10b981 !important;
        color: white !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script src="https://unpkg.com/lucide@latest"></script>
<script>
    "use strict";
    (function ($) {
        lucide.createIcons();

        $('.copybtn').on('click', function() {
            var target = $(this).data('copytarget');
            var $inp = $(target);
            var $btn = $(this);

            if ($inp.length) {
                $inp.select();
                try {
                    document.execCommand('copy');
                    $btn.addClass('copied');
                    // Change icon temporarily to checkmark
                    $btn.html('<i data-lucide="check" class="w-4 h-4"></i>');
                    lucide.createIcons();

                    setTimeout(function() {
                        $btn.removeClass('copied');
                        $btn.html('<i data-lucide="copy" class="w-4 h-4"></i>');
                        lucide.createIcons();
                    }, 1500);
                } catch (err) {
                    alert("<?php echo app('translator')->get('Please press Ctrl/Cmd+C to copy'); ?>");
                }
            }
        });
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/promo_tools.blade.php ENDPATH**/ ?>