<!DOCTYPE html>
<html lang="en" class="h-full bg-white">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> <?php echo e(gs()->siteName(__($pageTitle))); ?></title>
    <?php echo $__env->make('partials.seo', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; }
    </style>
</head>
<body class="h-full antialiased">

<div class="flex min-h-full">
    
    <div class="flex flex-1 flex-col justify-center px-4 py-12 sm:px-6 lg:flex-none lg:px-20 xl:px-24">
        <div class="mx-auto w-full max-w-sm lg:w-96">
            
            <div class="mb-10">
                <a href="<?php echo e(route('user.login')); ?>" class="inline-flex items-center gap-2 text-sm font-semibold text-slate-500 hover:text-emerald-600 transition-colors">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/></svg>
                    Back to Sign In
                </a>
            </div>

            <div class="mb-8">
                <div class="flex h-12 w-12 items-center justify-center rounded-2xl bg-emerald-50 text-emerald-600 mb-6">
                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z" />
                    </svg>
                </div>
                <h2 class="text-3xl font-extrabold tracking-tight text-slate-900">Forgot password?</h2>
                <p class="mt-2 text-sm text-slate-500">
                    No worries! Enter your details and we'll send you recovery instructions.
                </p>
            </div>

            <div class="mt-8">
                <form action="<?php echo e(route('user.password.email')); ?>" method="POST" class="verify-gcaptcha space-y-6">
                    <?php echo csrf_field(); ?>

                    <?php if(session('status')): ?>
                        <div class="rounded-lg bg-emerald-50 p-4 border border-emerald-100 text-sm font-medium text-emerald-800">
                            <?php echo e(session('status')); ?>

                        </div>
                    <?php endif; ?>

                    <div>
                        <label for="value" class="block text-sm font-semibold text-slate-700">Email or Username</label>
                        <div class="mt-1">
                            <input id="value" name="value" type="text" value="<?php echo e(old('value')); ?>" required autofocus="off"
                                class="block w-full rounded-xl border border-slate-200 px-4 py-3 text-slate-900 shadow-sm placeholder:text-slate-400 focus:border-emerald-500 focus:ring-4 focus:ring-emerald-500/10 sm:text-sm transition-all"
                                placeholder="Enter your email or username">
                        </div>
                    </div>

                    <div class="py-2">
                        <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
                    </div>

                    <button type="submit" class="flex w-full justify-center rounded-xl bg-slate-900 px-4 py-3.5 text-sm font-bold text-white shadow-lg hover:bg-slate-800 active:scale-[0.98] transition-all">
                        Reset Password
                    </button>
                </form>

                <div class="mt-8 text-center">
                    <p class="text-sm text-slate-500">
                        Still having trouble? <a href="#" class="font-semibold text-emerald-600 hover:underline">Contact Support</a>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <div class="relative hidden w-0 flex-1 lg:block">
        <div class="absolute inset-0 h-full w-full bg-slate-900">
            <div class="absolute inset-0" style="background: radial-gradient(circle at 50% 50%, rgba(16, 185, 129, 0.1) 0%, rgba(15, 23, 42, 1) 100%);"></div>
            
            <div class="relative flex h-full flex-col justify-center px-20 text-white">
                <div class="max-w-md">
                    <h3 class="text-2xl font-bold mb-4">Security is our Priority</h3>
                    <p class="text-slate-400 leading-relaxed">
                        We use multi-factor authentication and institutional-grade encryption to ensure your investment portfolio remains accessible only to you.
                    </p>
                    
                    <div class="mt-10 flex items-center gap-4 p-4 rounded-2xl bg-white/5 border border-white/10">
                        <div class="flex-shrink-0 text-emerald-400">
                            <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/></svg>
                        </div>
                        <p class="text-sm text-slate-300">Your account recovery link will expire in 60 minutes for security purposes.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
    <?php echo $__env->make('partials.notify', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

</body>
</html><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/auth/passwords/email.blade.php ENDPATH**/ ?>