<?php $__env->startSection('content'); ?>
    <?php
        $kyc = getContent('kyc.content', true);
    ?> 
    <style>
        /* Premium UI Core */
        .elite-card {
            @apply bg-white/80 dark:bg-slate-900/50 backdrop-blur-2xl transition-all duration-500 relative;
            border: 1.5px solid #e2e8f0;
            box-shadow: inset 0 1px 1px 0 rgba(255, 255, 255, 0.9), 0 10px 15px -3px rgba(0, 0, 0, 0.05);
        }

        .dark .elite-card {
            border: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: inset 0 1px 1px 0 rgba(255, 255, 255, 0.05), 0 20px 25px -5px rgba(0, 0, 0, 0.3);
        }

        /* Hover Lift Effect */
        .elite-card:hover {
            @apply transform -translate-y-1;
            border-color: #10b981;
        }

        .dark .elite-card:hover {
            border-color: rgba(16, 185, 129, 0.5);
            box-shadow: 0 0 20px rgba(16, 185, 129, 0.1);
        }

        .premium-badge {
            @apply px-3 py-1 rounded-full text-[10px] font-black uppercase tracking-tighter border shadow-sm;
        }
    </style>
    <?php $__env->startPush('breadcrumb_text'); ?>
        <div class="flex items-center gap-5">
            <div class="relative group">
                <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-2xl blur opacity-25"></div>
                <div class="relative w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white border border-white/10 shadow-2xl">
                    <i data-lucide="home" class="w-7 h-7 text-emerald-400"></i>
                </div>
            </div>
            <div>
                <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase"><?php echo app('translator')->get('Dashboard'); ?></h2>
                <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-1"><?php echo app('translator')->get('All inbound asset movements'); ?></p>
            </div>
        </div>
        <?php $__env->stopPush(); ?>
    <div class="w-full  mx-auto space-y-8 px-4 animate-in fade-in zoom-in-95 duration-700">

        <div class="space-y-4">
            <div class="notice"></div>

            <?php if($user->kv == Status::KYC_UNVERIFIED && $user->kyc_rejection_reason): ?>
                <div
                    class="elite-card rounded-2xl p-4 border-rose-500/50 bg-rose-50/50 dark:bg-rose-500/5 flex items-center gap-4">
                    <div
                        class="h-12 w-12 rounded-xl bg-rose-500 text-white flex items-center justify-center shadow-lg shadow-rose-500/20">
                        <i class="fas fa-times-circle text-xl"></i>
                    </div>
                    <div class="flex-1">
                        <h4 class="text-sm font-black text-rose-600 dark:text-rose-400 uppercase tracking-widest">
                            <?php echo app('translator')->get('KYC Documents Rejected'); ?></h4>
                        <p class="text-xs text-slate-500 dark:text-slate-400">
                            <?php echo e(__(@$kyc->data_values->reject)); ?>

                            <a href="javascript::void(0)" class="font-bold underline decoration-2" data-bs-toggle="modal"
                                data-bs-target="#kycRejectionReason"><?php echo app('translator')->get('Show Reason'); ?></a> •
                            <a href="<?php echo e(route('user.kyc.form')); ?>" class="font-bold text-rose-600"><?php echo app('translator')->get('Re-submit'); ?></a>
                        </p>
                    </div>
                </div>
            <?php elseif($user->kv == Status::KYC_UNVERIFIED): ?>
                <div
                    class="elite-card rounded-2xl p-4 border-blue-500/50 bg-blue-50/50 dark:bg-blue-500/5 flex items-center gap-4">
                    <div
                        class="h-12 w-12 rounded-xl bg-blue-500 text-white flex items-center justify-center shadow-lg shadow-blue-500/20">
                        <i class="fas fa-exclamation-circle text-xl"></i>
                    </div>
                    <div class="flex-1">
                        <h4 class="text-sm font-black text-blue-600 dark:text-blue-400 uppercase tracking-widest">
                            <?php echo app('translator')->get('KYC Verification Required'); ?></h4>
                        <p class="text-xs text-slate-500 dark:text-slate-400"><?php echo e(__(@$kyc->data_values->required)); ?> <a
                                href="<?php echo e(route('user.kyc.form')); ?>" class="font-bold underline"><?php echo app('translator')->get('Submit Now'); ?></a></p>
                    </div>
                </div>
            <?php elseif($user->kv == Status::KYC_PENDING): ?>
                <div
                    class="elite-card rounded-2xl p-4 border-amber-500/50 bg-amber-50/50 dark:bg-amber-500/5 flex items-center gap-4">
                    <div
                        class="h-12 w-12 rounded-xl bg-amber-500 text-white flex items-center justify-center animate-pulse">
                        <i class="las la-hourglass-half text-xl"></i>
                    </div>
                    <div class="flex-1">
                        <h4 class="text-sm font-black text-amber-600 dark:text-amber-400 uppercase tracking-widest">
                            <?php echo app('translator')->get('KYC Pending Review'); ?></h4>
                        <p class="text-xs text-slate-500 dark:text-slate-400"><?php echo e(__(@$kyc->data_values->pending)); ?> <a
                                href="<?php echo e(route('user.kyc.data')); ?>" class="font-bold underline"><?php echo app('translator')->get('View Data'); ?></a></p>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <div class="space-y-4 mb-8">
    
    
    <?php if($user->deposit_wallet <= 0 && $user->interest_wallet <= 0): ?>
        <div class="relative group overflow-hidden">
            <div class="absolute -inset-1 bg-gradient-to-r from-rose-500/20 to-orange-500/20 rounded-2xl blur opacity-30"></div>
            <div class="relative flex items-center gap-4 p-4 bg-white dark:bg-slate-900 border border-rose-200 dark:border-rose-500/20 rounded-2xl shadow-xl">
                <div class="w-10 h-10 shrink-0 bg-rose-500/10 rounded-xl flex items-center justify-center">
                    <i data-lucide="alert-octagon" class="w-5 h-5 text-rose-500 animate-pulse"></i>
                </div>
                <div class="flex-1">
                    <h4 class="text-[10px] font-black text-rose-500 uppercase tracking-[0.2em] mb-0.5"><?php echo app('translator')->get('Liquidity Alert'); ?></h4>
                    <p class="text-[11px] font-bold text-slate-600 dark:text-slate-400 leading-tight">
                        <?php echo app('translator')->get('Zero-balance detected across all nodes.'); ?> 
                        <a href="<?php echo e(route('user.deposit.index')); ?>" class="text-rose-600 dark:text-rose-400 underline decoration-rose-500/30 underline-offset-4 hover:decoration-rose-500 transition-all"><?php echo app('translator')->get('Initiate Deposit Protocol'); ?></a>
                    </p>
                </div>
            </div>
        </div>
    <?php endif; ?>

    
    <?php if($pendingWithdrawals || $pendingDeposits): ?>
        <div class="flex flex-wrap gap-3">
            <?php if($pendingWithdrawals): ?>
                <div class="flex items-center gap-3 px-4 py-2.5 bg-blue-500/5 border border-blue-500/20 rounded-xl">
                    <span class="relative flex h-2 w-2">
                        <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-blue-400 opacity-75"></span>
                        <span class="relative inline-flex rounded-full h-2 w-2 bg-blue-500"></span>
                    </span>
                    <span class="text-[10px] font-black text-blue-600 dark:text-blue-400 uppercase tracking-widest">
                        <?php echo app('translator')->get('Withdrawal Syncing'); ?>: <span class="ml-1 text-slate-900 dark:text-white"><?php echo e(showAmount($pendingWithdrawals)); ?></span>
                    </span>
                </div>
            <?php endif; ?>

            <?php if($pendingDeposits): ?>
                <div class="flex items-center gap-3 px-4 py-2.5 bg-emerald-500/5 border border-emerald-500/20 rounded-xl">
                    <span class="relative flex h-2 w-2">
                        <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-emerald-400 opacity-75"></span>
                        <span class="relative inline-flex rounded-full h-2 w-2 bg-emerald-500"></span>
                    </span>
                    <span class="text-[10px] font-black text-emerald-600 dark:text-emerald-400 uppercase tracking-widest">
                        <?php echo app('translator')->get('Deposit Verifying'); ?>: <span class="ml-1 text-slate-900 dark:text-white"><?php echo e(showAmount($pendingDeposits)); ?></span>
                    </span>
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    
    <?php if($isHoliday): ?>
        <div class="relative overflow-hidden group">
            <div class="absolute inset-0 bg-indigo-500/[0.03] dark:bg-indigo-500/[0.05]"></div>
            <div class="relative p-5 border border-indigo-200 dark:border-indigo-500/20 rounded-[2rem] flex flex-col md:flex-row md:items-center justify-between gap-4">
                <div class="flex items-center gap-4">
                    <div class="w-12 h-12 bg-indigo-500/10 rounded-2xl flex items-center justify-center">
                        <i data-lucide="calendar-off" class="w-6 h-6 text-indigo-500"></i>
                    </div>
                    <div>
                        <h4 class="text-[11px] font-black text-indigo-700 dark:text-indigo-400 uppercase tracking-[0.2em]"><?php echo app('translator')->get('Market Standby Mode'); ?></h4>
                        <p class="text-[10px] font-bold text-slate-500 uppercase tracking-tight"><?php echo app('translator')->get('Profit generation paused for scheduled holiday'); ?></p>
                    </div>
                </div>
                
                <div class="bg-slate-900 dark:bg-black/40 px-6 py-3 rounded-2xl border border-white/5 flex items-center gap-4">
                    <span class="text-[9px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Resuming In'); ?></span>
                    <span id="counter" class="font-mono text-sm font-black text-indigo-400 tracking-wider"></span>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

        <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-6">
            <div class="elite-card rounded-[2.5rem] p-8 group overflow-hidden">
                <div class="relative z-10 flex justify-between">
                    <div>
                        <p class="text-[10px] font-black uppercase tracking-[0.2em] text-slate-400 mb-1"><?php echo app('translator')->get('Deposit Wallet Balance'); ?>
                        </p>
                        <h2 class="text-4xl font-black text-slate-900 dark:text-white tracking-tighter">
                            <?php echo e(showAmount($user->deposit_wallet)); ?></h2>
                    </div>
                    <div
                        class="h-14 w-14 rounded-2xl bg-emerald-500/10 border border-emerald-500/20 flex items-center justify-center text-emerald-600 shadow-inner">
                        <i class="las la-dollar-sign text-2xl"></i>
                    </div>
                </div>
                <div class="mt-8 flex gap-2">
                    <a href="<?php echo e(route('user.deposit.index')); ?>"
                        class="flex-1 py-3 bg-slate-900 dark:bg-emerald-500 text-white text-center rounded-xl text-[10px] font-black uppercase tracking-widest hover:shadow-lg transition-all"><?php echo app('translator')->get('Deposit'); ?></a>
                </div>
            </div>

            <div class="elite-card rounded-[2.5rem] p-8 overflow-hidden">
                <div class="flex justify-between">
                    <div>
                        <p class="text-[10px] font-black uppercase tracking-[0.2em] text-slate-400 mb-1"><?php echo app('translator')->get('Interest Wallet Balance'); ?>
                        </p>
                        <h2 class="text-4xl font-black text-slate-900 dark:text-white tracking-tighter">
                            <?php echo e(showAmount($user->interest_wallet)); ?></h2>
                    </div>
                    <div
                        class="h-14 w-14 rounded-2xl bg-blue-500/10 border border-blue-500/20 flex items-center justify-center text-blue-600">
                        <i class="las la-wallet text-2xl"></i>
                    </div>
                </div>
                <div class="mt-4 flex items-center gap-2">
                    <span class="h-1.5 w-1.5 rounded-full bg-emerald-500 animate-pulse"></span>
                    <span class="text-[9px] font-bold text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Accumulating Yield'); ?></span>
                </div>
            </div>

            <div class="elite-card rounded-[2.5rem] p-8">
                <div class="flex justify-between">
                    <div>
                        <p class="text-[10px] font-black uppercase tracking-[0.2em] text-slate-400 mb-1"><?php echo app('translator')->get('Total Invest'); ?>
                        </p>
                        <h2 class="text-4xl font-black text-slate-900 dark:text-white tracking-tighter">
                            <?php echo e(showAmount($totalInvest)); ?></h2>
                    </div>
                    <div
                        class="h-14 w-14 rounded-2xl bg-purple-500/10 border border-purple-500/20 flex items-center justify-center text-purple-600">
                        <i class="las la-cubes text-2xl"></i>
                    </div>
                </div>
                <a href="<?php echo e(route('user.invest.statistics')); ?>"
                    class="mt-8 block text-center py-3 border border-slate-200 dark:border-white/10 rounded-xl text-[10px] font-black uppercase text-slate-600 dark:text-slate-400 hover:bg-slate-50"><?php echo app('translator')->get('Manage Investment'); ?></a>
            </div>

            <div class="elite-card rounded-[2.5rem] p-8">
                <div class="flex justify-between items-center">
                    <div
                        class="h-12 w-12 rounded-xl bg-slate-100 dark:bg-white/5 flex items-center justify-center text-slate-600 dark:text-slate-400">
                        <i class="las la-credit-card text-xl"></i>
                    </div>
                    <div class="text-right">
                        <p class="text-[10px] font-black uppercase tracking-widest text-slate-400"><?php echo app('translator')->get('Total Deposit'); ?></p>
                        <h4 class="text-2xl font-black text-slate-900 dark:text-white"><?php echo e(showAmount($totalDeposit)); ?></h4>
                    </div>
                </div>
            </div>

            <div class="elite-card rounded-[2.5rem] p-8">
                <div class="flex justify-between items-center">
                    <div
                        class="h-12 w-12 rounded-xl bg-slate-100 dark:bg-white/5 flex items-center justify-center text-slate-600 dark:text-slate-400">
                        <i class="las la-cloud-download-alt text-xl"></i>
                    </div>
                    <div class="text-right">
                        <p class="text-[10px] font-black uppercase tracking-widest text-slate-400"><?php echo app('translator')->get('Total Withdraw'); ?></p>
                        <h4 class="text-2xl font-black text-slate-900 dark:text-white"><?php echo e(showAmount($totalWithdraw)); ?>

                        </h4>
                    </div>
                </div>
            </div>

            <div class="elite-card rounded-[2.5rem] p-8">
                <div class="flex justify-between items-center">
                    <div
                        class="h-12 w-12 rounded-xl bg-emerald-100 dark:bg-emerald-500/10 flex items-center justify-center text-emerald-600">
                        <i class="las la-user-friends text-xl"></i>
                    </div>
                    <div class="text-right">
                        <p class="text-[10px] font-black uppercase tracking-widest text-slate-400"><?php echo app('translator')->get('Referral Earnings'); ?></p>
                        <h4 class="text-2xl font-black text-emerald-600 dark:text-emerald-500">
                            <?php echo e(showAmount($referralEarnings)); ?></h4>
                    </div>
                </div>
            </div>
        </div>

        <div class="elite-card rounded-[2.5rem] overflow-hidden">
            <div class="p-8 border-b border-slate-100 dark:border-white/5 flex justify-between items-center">
                <h3 class="text-xs font-black uppercase tracking-widest text-slate-900 dark:text-white"><?php echo app('translator')->get('Recent Transactions Ledger'); ?>
                </h3>
                <div class="flex items-center gap-2">
                    <span class="h-2 w-2 rounded-full bg-emerald-500 animate-pulse"></span>
                    <span class="text-[10px] font-mono text-slate-400 uppercase">Live Update</span>
                </div>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-left">
                    <thead class="bg-slate-50 dark:bg-white/[0.02] text-[10px] uppercase font-black text-slate-400">
                        <tr>
                            <th class="px-8 py-4"><?php echo app('translator')->get('Timeline'); ?></th>
                            <th class="px-8 py-4"><?php echo app('translator')->get('Identifier'); ?></th>
                            <th class="px-8 py-4"><?php echo app('translator')->get('Volume'); ?></th>
                            <th class="px-8 py-4"><?php echo app('translator')->get('Wallet Status'); ?></th>
                            <th class="px-8 py-4 text-right"><?php echo app('translator')->get('Post Balance'); ?></th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-100 dark:divide-white/5">
                        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-slate-50 dark:hover:bg-white/5 transition-colors group">
                                <td class="px-8 py-5">
                                    <p class="text-xs font-bold text-slate-900 dark:text-white">
                                        <?php echo e(showDatetime($trx->created_at, 'd/m/Y')); ?></p>
                                </td>
                                <td class="px-8 py-5">
                                    <span
                                        class="text-xs font-mono font-bold text-emerald-600 dark:text-emerald-500"><?php echo e($trx->trx); ?></span>
                                </td>
                                <td class="px-8 py-5">
                                    <span
                                        class="text-sm font-black <?php echo e($trx->trx_type == '+' ? 'text-emerald-600' : 'text-rose-600'); ?>">
                                        <?php echo e($trx->trx_type); ?><?php echo e(__(gs('cur_sym'))); ?><?php echo e(getAmount($trx->amount)); ?>

                                    </span>
                                </td>
                                <td class="px-8 py-5">
                                    <span
                                        class="px-3 py-1 rounded-lg bg-slate-100 dark:bg-slate-800 text-[9px] font-black uppercase text-slate-500">
                                        <?php echo e($trx->wallet_type == 'deposit_wallet' ? __('Deposit') : __('Interest')); ?>

                                    </span>
                                </td>
                                <td class="px-8 py-5 text-right font-mono text-xs font-bold text-slate-400">
                                    <?php echo e(__(gs('cur_sym'))); ?><?php echo e(getAmount($trx->post_balance)); ?>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="100%"
                                    class="px-8 py-20 text-center text-slate-400 uppercase text-[10px] font-black tracking-widest">
                                    <?php echo app('translator')->get('No Transaction Found'); ?>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>


    <?php if($user->kv == Status::KYC_UNVERIFIED && $user->kyc_rejection_reason): ?>
        <div class="modal fade" id="kycRejectionReason">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo app('translator')->get('KYC Document Rejection Reason'); ?></h5>
                        <button type="button" class="close" data-bs-dismiss="modal">
                            <i class="las la-times"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p><?php echo e($user->kyc_rejection_reason); ?></p>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        #copyBoard {
            cursor: pointer;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {
            <?php if($isHoliday): ?>
                function createCountDown(elementId, sec) {
                    var tms = sec;
                    var x = setInterval(function() {
                        var distance = tms * 1000;
                        var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                        var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                        var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                        var seconds = Math.floor((distance % (1000 * 60)) / 1000);
                        var days = `<span>${days}d</span>`;
                        var hours = `<span>${hours}h</span>`;
                        var minutes = `<span>${minutes}m</span>`;
                        var seconds = `<span>${seconds}s</span>`;
                        document.getElementById(elementId).innerHTML = days + ' ' + hours + " " + minutes +
                            " " + seconds;
                        if (distance < 0) {
                            clearInterval(x);
                            document.getElementById(elementId).innerHTML = "COMPLETE";
                        }
                        tms--;
                    }, 1000);
                }
                createCountDown('counter', <?php echo e(abs(\Carbon\Carbon::parse($nextWorkingDay)->diffInSeconds())); ?>);
            <?php endif; ?>
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/dashboard.blade.php ENDPATH**/ ?>