<?php $__env->startSection('content'); ?>
    <div class="max-w-7xl mx-auto">
        <!-- Enhanced Header -->
        <div
            class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
                <div class="absolute bottom-0 left-0 w-24 h-24 bg-white rounded-full translate-y-12 -translate-x-12"></div>
            </div>

            <div class="relative z-10">
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                    <div class="mb-4 lg:mb-0 lg:flex-1">
                        <h1 class="text-xl font-light mb-1">Holdings</h1>
                        <p class="text-gray-300 text-sm">Detailed view of your investment holdings</p>
                    </div>

                    <!-- Enhanced Stats Card -->
                    <div
                        class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-80">
                        <div class="flex items-center justify-between mb-3">
                            <div>
                                <p class="text-xs text-gray-300 mb-1">Total Holdings</p>
                                <p class="text-lg font-light"><?php echo e(count($invests)); ?></p>
                            </div>
                            <div class="w-10 h-10 flex items-center justify-center">
                                <i data-lucide="pie-chart" class="w-5 h-5 text-white"></i>
                            </div>
                        </div>
                        <div class="flex space-x-4 text-xs">
                            <div class="flex-1 text-center">
                                <p class="text-gray-300">Value</p>
                                <p class="text-white font-medium"><?php echo e(showAmount($totalInvest)); ?></p>
                            </div>
                            <div class="flex-1 text-center">
                                <p class="text-gray-300">Gain/Loss</p>
                                <p class="text-white font-medium text-green-400">
                                    +<?php echo e(showAmount($interests)); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Holdings Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-100">
                <div class="flex items-center justify-between">
                    <div>
                        <h3 class="text-lg font-light text-black mb-1">Investment Holdings</h3>
                        <p class="text-xs text-gray-500">Detailed breakdown of your investments</p>
                    </div>
                    <a href="<?php echo e(route('user.invest.statistics')); ?>"
                        class="text-xs text-blue-600 hover:text-blue-800 transition-colors duration-200 font-medium">
                        Browse More
                        <i data-lucide="arrow-right" class="w-3 h-3 inline ml-1"></i>
                    </a>
                </div>
            </div>

            <div class="text-center py-12">
                <?php if(count($invests) > 0): ?>
                <?php echo $__env->make('Template::partials.invest_history', ['invests' => $invests], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <?php else: ?>
                <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i data-lucide="trending-up" class="w-8 h-8 text-gray-400"></i>
                </div>

                <p class="text-gray-600 text-sm mb-4">Start building your portfolio by investing in our plans</p>
                <a href="<?php echo e(route('user.invest.plan')); ?>"
                    class="inline-flex items-center px-4 py-2 bg-black text-white text-sm font-medium rounded-lg hover:bg-gray-800 transition-colors duration-200">
                    <i data-lucide="plus" class="w-4 h-4 mr-2"></i>
                    Start Investing
                </a>
                <?php endif; ?>
            </div>
        </div>

        <!-- Summary Cards -->
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('Template::layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/user/invest/log.blade.php ENDPATH**/ ?>