<?php $__env->startSection('content'); ?>
    <div class="px-4 mx-auto py-2 flex justify-center">
        <div class="w-full max-w-2xl">

            
            <?php $__env->startPush('breadcrumb_text'); ?>
                <div class="flex items-center gap-5 mb-10 px-4">
                    <div class="relative group">
                        <div class="absolute -inset-1 bg-gradient-to-r from-rose-500 to-blue-600 rounded-2xl blur opacity-25">
                        </div>
                        <div
                            class="relative w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white border border-white/10 shadow-2xl">
                            <i data-lucide="shield" class="w-7 h-7 text-rose-400"></i>
                        </div>
                    </div>
                    <div>
                        <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase">
                            <?php echo app('translator')->get('Security Credentials'); ?></h2>
                        <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-1"><?php echo app('translator')->get('Update authentication access tokens'); ?></p>
                    </div>
                </div>
            <?php $__env->stopPush(); ?>

            
            <div class="relative group">
                <div
                    class="absolute -inset-0.5 bg-gradient-to-r from-rose-500/20 to-blue-500/20 rounded-[2.5rem] blur opacity-20 group-hover:opacity-40 transition duration-500">
                </div>

                <div
                    class="relative bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2.5rem] p-8 md:p-12 shadow-2xl overflow-hidden">
                    <form method="post" class="space-y-8">
                        <?php echo csrf_field(); ?>

                        
                        <div class="space-y-3">
                            <label
                                class="text-[10px] font-black text-slate-400 uppercase tracking-widest flex items-center gap-2">
                                <i data-lucide="key-round" class="w-3 h-3"></i> <?php echo app('translator')->get('Current Password'); ?>
                            </label>
                            <input type="password" name="current_password"
                                class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-rose-500 transition-all outline-none"
                                required autocomplete="current-password" placeholder="••••••••">
                        </div>

                        
                        <div class="space-y-3">
                            <label
                                class="text-[10px] font-black text-slate-400 uppercase tracking-widest flex items-center gap-2">
                                <i data-lucide="lock-keyhole" class="w-3 h-3"></i> <?php echo app('translator')->get('New Password'); ?>
                            </label>
                            <input type="password" name="password"
                                class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-emerald-500 transition-all outline-none <?php if(gs('secure_password')): ?> secure-password <?php endif; ?>"
                                required autocomplete="new-password" placeholder="••••••••">
                        </div>

                        
                        <div class="space-y-3">
                            <label
                                class="text-[10px] font-black text-slate-400 uppercase tracking-widest flex items-center gap-2">
                                <i data-lucide="shield-check" class="w-3 h-3"></i> <?php echo app('translator')->get('Confirm New Password'); ?>
                            </label>
                            <input type="password" name="password_confirmation"
                                class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-emerald-500 transition-all outline-none"
                                required autocomplete="new-password" placeholder="••••••••">
                        </div>

                        
                        <div class="pt-6">
                            <button type="submit"
                                class="group relative w-full h-16 bg-slate-900 dark:bg-white rounded-2xl overflow-hidden transition-all active:scale-95 shadow-xl">
                                <div
                                    class="absolute inset-0 bg-gradient-to-r from-rose-500 to-blue-600 opacity-0 group-hover:opacity-100 transition-opacity">
                                </div>
                                <div class="relative flex items-center justify-center gap-3">
                                    <span
                                        class="text-[11px] font-black text-white dark:text-slate-900 uppercase tracking-[0.3em] group-hover:text-white transition-colors"><?php echo app('translator')->get('Execute Update'); ?></span>
                                    <i data-lucide="zap"
                                        class="w-4 h-4 text-rose-500 group-hover:text-white transition-all group-hover:translate-x-1"></i>
                                </div>
                            </button>
                        </div>
                    </form>

                    
                    <div
                        class="absolute bottom-0 left-0 right-0 h-1.5 bg-gradient-to-r from-rose-500 via-blue-500 to-emerald-500">
                    </div>
                </div>

                
                <p
                    class="mt-8 text-center text-[9px] font-black text-slate-500 uppercase tracking-widest opacity-60 flex items-center justify-center gap-2 italic">
                    <i data-lucide="info" class="w-3 h-3"></i> <?php echo app('translator')->get('Use at least 8 characters with a mix of letters, numbers, and symbols.'); ?>
                </p>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php if(gs('secure_password')): ?>
    <?php $__env->startPush('script-lib'); ?>
        <script src="<?php echo e(asset('assets/global/js/secure_password.js')); ?>"></script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php $__env->startPush('script'); ?>
    <script src="https://unpkg.com/lucide@latest"></script>
    <script>
        "use strict";
        (function($) {
            lucide.createIcons();
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/password.blade.php ENDPATH**/ ?>