<!DOCTYPE html>
<html lang="en" class="h-full bg-white">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> <?php echo e(gs()->siteName(__($pageTitle))); ?></title>
    <?php echo $__env->make('partials.seo', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; }
    </style>
</head>
<body class="h-full antialiased">

<div class="flex min-h-full">
    
    <div class="flex flex-1 flex-col justify-center px-4 py-12 sm:px-6 lg:flex-none lg:px-20 xl:px-24">
        <div class="mx-auto w-full max-w-sm lg:w-96">
            
            <div class="mb-10">
                <div class="inline-flex h-12 w-12 items-center justify-center rounded-2xl bg-emerald-600 text-white shadow-lg shadow-emerald-200 mb-6">
                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                    </svg>
                </div>
                <h2 class="text-3xl font-extrabold tracking-tight text-slate-900">Reset Password</h2>
                <p class="mt-2 text-sm text-slate-500">
                    Almost there! Choose a strong password to protect your account.
                </p>
            </div>

            <form action="<?php echo e(route('user.password.update')); ?>" method="POST" class="space-y-6">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="email" value="<?php echo e($email); ?>">
                <input type="hidden" name="token" value="<?php echo e($token); ?>">

                <div>
                    <label for="password" class="block text-sm font-semibold text-slate-700">New Password</label>
                    <div class="mt-1 relative">
                        <input id="password" name="password" type="password" required 
                            class="block w-full rounded-xl border border-slate-200 px-4 py-3 text-slate-900 shadow-sm focus:border-emerald-500 focus:ring-4 focus:ring-emerald-500/10 sm:text-sm transition-all <?php if(gs('secure_password')): ?> secure-password <?php endif; ?>"
                            placeholder="••••••••">
                    </div>
                    <?php if(gs('secure_password')): ?>
                        <p class="mt-2 text-xs text-slate-400">Password must include symbols, numbers, and capital letters.</p>
                    <?php endif; ?>
                </div>

                <div>
                    <label for="password_confirmation" class="block text-sm font-semibold text-slate-700">Confirm New Password</label>
                    <div class="mt-1">
                        <input id="password_confirmation" name="password_confirmation" type="password" required 
                            class="block w-full rounded-xl border border-slate-200 px-4 py-3 text-slate-900 shadow-sm focus:border-emerald-500 focus:ring-4 focus:ring-emerald-500/10 sm:text-sm transition-all"
                            placeholder="••••••••">
                    </div>
                </div>

                <button type="submit" class="flex w-full justify-center rounded-xl bg-slate-900 px-4 py-4 text-sm font-bold text-white shadow-xl hover:bg-slate-800 active:scale-[0.98] transition-all">
                    Update Password & Login
                </button>
            </form>
        </div>
    </div>

    <div class="relative hidden w-0 flex-1 lg:block">
        <div class="absolute inset-0 h-full w-full bg-slate-900">
            <div class="absolute inset-0 opacity-30" style="background: linear-gradient(135deg, #064e3b 0%, #0f172a 100%);"></div>
            
            <div class="relative flex h-full flex-col justify-center px-20 text-white">
                <div class="max-w-md">
                    <div class="mb-10 inline-flex items-center gap-2 px-3 py-1 rounded-full bg-emerald-500/10 border border-emerald-500/20 text-emerald-400 text-xs font-bold uppercase tracking-widest">
                        <span class="relative flex h-2 w-2">
                            <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-emerald-400 opacity-75"></span>
                            <span class="relative inline-flex rounded-full h-2 w-2 bg-emerald-500"></span>
                        </span>
                        Verified Session
                    </div>
                    <h3 class="text-4xl font-bold leading-tight mb-6">Your security is our commitment.</h3>
                    <p class="text-slate-400 text-lg leading-relaxed">
                        Once you update your password, all other active sessions will be logged out to ensure your portfolio remains under your exclusive control.
                    </p>
                    
                    <div class="mt-10 grid grid-cols-1 gap-6">
                        <div class="flex items-center gap-4 text-sm text-slate-300">
                            <div class="h-8 w-8 rounded-full bg-emerald-500/20 flex items-center justify-center text-emerald-400">
                                <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"/></svg>
                            </div>
                            256-bit AES Encryption
                        </div>
                        <div class="flex items-center gap-4 text-sm text-slate-300">
                            <div class="h-8 w-8 rounded-full bg-emerald-500/20 flex items-center justify-center text-emerald-400">
                                <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"/></svg>
                            </div>
                            Automatic Session Timeout
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if(gs('secure_password')): ?>
    <script src="<?php echo e(asset('assets/global/js/secure_password.js')); ?>"></script>
<?php endif; ?>
</body>
</html><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/auth/passwords/reset.blade.php ENDPATH**/ ?>