<?php
    $subscribeContent = getContent('subscribe.content', true);
?>
<!--==========================  Call-to-action Section Start  ==========================-->
<section class="call-to-action-section bg--black-two">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="call-action-box">
                    <div class="call-shape">
                        <img src="<?php echo e(asset('assets/frontend/svg/twostar.svg')); ?>" alt="star">
                    </div>
                    <div class="row row-gap-5">
                        <div class="col-lg-6 align-self-center order-1 order-lg-0">
                            <div class="call-text text-center text-lg-start">
                                <span
                                    class="text--base pb-3 right-reveal"><?php echo e(__(@$subscribeContent->data_values->sub_heading)); ?></span>
                                <h2 class="mb-4 right-reveal"><?php echo e(__(@$subscribeContent->data_values->heading)); ?></h2>
                                <form class="subscribe-form relative group" action="<?php echo e(route('subscribe')); ?>"
                                    method="post">
                                    <?php echo csrf_field(); ?>
                                    <input type="email" name="email" id="email"
                                        class="form-control w-full bg-transparent border-none outline-none text-white font-bold placeholder:text-slate-500 placeholder:uppercase placeholder:text-[10px] placeholder:tracking-widest"
                                        placeholder="<?php echo app('translator')->get('Enter Encrypted Email'); ?>" required>
                                    <button type="submit" class="btn btn--base-two right-reveal">
                                        Register Now <i class="flaticon-arrow-upper-right"></i>
                                    </button>
                                </form>
                            </div>
                        </div>
                        <div class="col-lg-6 align-self-center">
                            <div class="call-img text-lg-end text-center scaleUp">
                                <img src="<?php echo e(asset('assets/frontend/images/call/call-img.png')); ?>" alt="call"
                                    class="img-fluid m-auto">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--==========================  Call-to-action Section End  ==========================-->
<?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/sections/subscribe.blade.php ENDPATH**/ ?>