<?php $__env->startSection('content'); ?>
    <?php
        $nav = \App\Models\Invest::wherePlanId($plan->id)->sum('amount');
        $risk = strToLower($plan->risk);
    ?>
    <div class="max-w-2xl mx-auto">
        <!-- Enhanced Header -->
        <div
            class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-32 h-32 bg-white rounded-full -translate-y-16 translate-x-16"></div>
                <div class="absolute bottom-0 left-0 w-16 h-16 bg-white rounded-full translate-y-8 -translate-x-8"></div>
            </div>

            <div class="relative z-10">
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                    <div class="mb-4 lg:mb-0 lg:flex-1">
                        <h1 class="text-xl font-light mb-1">Buy <?php echo e($plan->name); ?></h1>
                        <p class="text-gray-300 text-sm">Growth • <?php echo e($plan->risk); ?> Risk</p>
                    </div>

                    <!-- Enhanced Plan Stats Card -->
                    <div
                        class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-64">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-xs text-gray-300 mb-1">Current NAV</p>
                                <p class="text-lg font-light"><?php echo e(showAmount($nav)); ?></p>
                            </div>
                            <div class="w-10 h-10 flex items-center justify-center">
                                <i data-lucide="trending-up" class="w-5 h-5 text-white"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Enhanced Buy Form -->
        <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
            <form action="<?php echo e(route('user.invest.submit')); ?>" method="POST" class="space-y-6">
            <?php echo csrf_field(); ?>
                <!-- Investment Amount -->
                <div>
                    <label for="amount" class="block text-sm font-medium text-gray-700 mb-2">Investment Amount</label>
                    <div class="relative">
                        <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-500"><?php echo e(gs()->cur_sym); ?></span>
                        <input 
                            type="number" 
                            id="amount" 
                            name="amount" 
                            step="0.01" 
                            onkeyup="updateCalculation()"
                            <?php if($plan->fixed_amount > 0): ?>
                                value="<?php echo e(getAmount($plan->fixed_amount)); ?>" 
                                readonly 
                            <?php else: ?>
                                min="<?php echo e(getAmount($plan->minimum)); ?>" 
                                max="<?php echo e(getAmount($plan->maximum)); ?>"
                                placeholder="0.00" 
                            <?php endif; ?>
                            class="w-full pl-8 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200" 
                            required
                        >

                    <input name="wallet_type" value="deposit_wallet"  hidden>
                    <input name="invest_time" value="invest_now"  hidden>
                    <input name="plan_id" value="<?php echo e($plan->id); ?>" hidden>
                    </div>
                    <p class="text-xs text-gray-500 mt-1">Minimum investment: 
                         <?php if($plan->fixed_amount == 0): ?>
                                    <?php echo e(showAmount($plan->minimum)); ?>

                                <?php else: ?>
                                    <?php echo e(showAmount($plan->fixed_amount)); ?>

                                <?php endif; ?>
                    </p>
                </div>

                <!-- Plan Information -->
                <div class="bg-gradient-to-br from-blue-50 to-blue-100 rounded-lg p-4 border border-blue-200">
                    <div class="flex items-center justify-between mb-3">
                        <span class="text-xs font-medium text-blue-800">Plan Information</span>
                        <div class="w-8 h-8 flex items-center justify-center">
                            <i data-lucide="info" class="w-4 h-4 text-blue-600"></i>
                        </div>
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <p class="text-xs text-blue-700 mb-1">Current NAV</p>
                            <p class="text-sm font-medium text-blue-800"><?php echo e(showAmount($nav)); ?></p>
                        </div>
                        <div>
                            <p class="text-xs text-blue-700 mb-1">1Y Return</p>
                            <p class="text-sm font-medium text-green-600">
                                +<?php echo e(showAmount($plan->interest, currencyFormat: false)); ?><?php echo e($plan->interest_type == 1 ? '%' : ' ' . __(gs('cur_text'))); ?>

                            </p>
                        </div>
                        <div>
                            <p class="text-xs text-blue-700 mb-1">Management Fee</p>
                            <p class="text-sm font-medium text-blue-800"><?php echo e(number_format($plan->fee,2)); ?></p>
                        </div>
                        <div>
                            <p class="text-xs text-blue-700 mb-1">Risk Level</p>
                            <p class="text-sm font-medium text-blue-800"><?php echo e($plan->risk); ?></p>
                        </div>
                    </div>
                </div>

                <!-- Enhanced Calculation Breakdown -->
                <div class="bg-gradient-to-br from-green-50 to-green-100 rounded-lg p-4 border border-green-200">
                    <div class="flex items-center justify-between mb-3">
                        <span class="text-xs font-medium text-green-800">Investment Breakdown</span>
                        <div class="w-8 h-8 flex items-center justify-center">
                            <i data-lucide="calculator" class="w-4 h-4 text-green-600"></i>
                        </div>
                    </div>
                    <div class="space-y-2">
                        <div class="flex items-center justify-between">
                            <span class="text-xs text-green-700">Investment Amount:</span>
                            <span class="text-xs font-medium text-green-800" id="investment-amount">$0.00</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-xs text-green-700">Units to Buy:</span>
                            <span class="text-xs font-medium text-green-800" id="units-to-buy">0.0000</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-xs text-green-700">Processing Fee:</span>
                            <span class="text-xs font-medium text-green-800" id="processing-fee">$0.00</span>
                        </div>
                        <div class="border-t border-green-300 pt-2">
                            <div class="flex items-center justify-between">
                                <span class="text-xs font-semibold text-green-800">Total Cost:</span>
                                <span class="text-xs font-bold text-green-900" id="total-cost">$0.00</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Wallet Balance Check -->
                <div class="bg-gradient-to-br from-gray-50 to-gray-100 rounded-lg p-4 border border-gray-200">
                    <div class="flex items-center justify-between mb-3">
                        <span class="text-xs font-medium text-gray-800">Wallet Balance</span>
                        <div class="w-8 h-8 flex items-center justify-center">
                            <i data-lucide="wallet" class="w-4 h-4 text-gray-600"></i>
                        </div>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-xs text-gray-700">Available Balance:</span>
                        <span class="text-xs font-medium text-gray-800">
                            <?php echo e(showAmount(auth()->user()->deposit_wallet)); ?>

                        </span>
                    </div>
                    <div class="flex items-center justify-between mt-1">
                        <span class="text-xs text-gray-700">After Purchase:</span>
                        <span class="text-xs font-medium text-gray-800" id="remaining-balance">$0.00</span>
                    </div>
                </div>

                <!-- User Holdings (if any) -->

                <!-- Submit Button -->
                <div class="pt-4">
                    <button type="submit"
                        class="w-full bg-black text-white py-3 px-6 rounded-lg font-medium hover:bg-gray-800 transition-colors duration-200 flex items-center justify-center">
                        <i data-lucide="plus" class="w-4 h-4 mr-2"></i>
                        Buy Investment
                    </button>
                </div>
            </form>
        </div>
    </div>

<?php $__env->startPush('script'); ?>
<script>
    // 1. Convert Blade strings to actual Numbers immediately
        const walletBalance = parseFloat("<?php echo e(auth()->user()->balance_wallet); ?>") || 0;
        const nav = parseFloat("<?php echo e($nav); ?>") || 1; // Prevent division by zero
        const processFeePercent = parseFloat("<?php echo e($plan->fee); ?>") / 100; // Assuming fee is like 0.25

        const amountInput = document.getElementById('amount');
        const investmentAmount = document.getElementById('investment-amount');
        const unitsToBuy = document.getElementById('units-to-buy');
        const processingFee = document.getElementById('processing-fee');
        const totalCost = document.getElementById('total-cost');
        const remainingBalance = document.getElementById('remaining-balance');

    function updateCalculation() {
 
       
        // 2. Convert input value to a Number

         
        const amount = parseFloat(amountInput.value) || 0;
        
        const units = amount / nav;
        const fee = amount * processFeePercent;
        const total = amount + fee; // Now this performs addition, not concatenation
        const remaining = walletBalance - total;

        // 3. Update the UI
        investmentAmount.textContent = `$${amount.toLocaleString(undefined, {minimumFractionDigits: 2})}`;
        unitsToBuy.textContent = units.toFixed(4);
        processingFee.textContent = `$${fee.toFixed(2)}`;
        totalCost.textContent = `$${total.toFixed(2)}`;
        remainingBalance.textContent = `$${remaining.toFixed(2)}`;

        // Update button state
        const submitButton = document.querySelector('button[type="submit"]');
        if (total > walletBalance || amount <= 0) {
            submitButton.disabled = true;
            submitButton.classList.add('opacity-50', 'cursor-not-allowed');
            submitButton.innerHTML = '<i data-lucide="alert-circle" class="w-4 h-4 mr-2"></i>Insufficient Funds';
        } else {
            submitButton.disabled = false;
            submitButton.classList.remove('opacity-50', 'cursor-not-allowed');
            submitButton.innerHTML = '<i data-lucide="plus" class="w-4 h-4 mr-2"></i>Buy Investment';
        }
        
        // Refresh Lucide icons if you are using them
        if (typeof lucide !== 'undefined') lucide.createIcons();
      
    }

    // 4. THE CRITICAL FIX: Listen for typing/input
    amountInput.addEventListener('input', updateCalculation);
</script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('Template::layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/user/plan/buy.blade.php ENDPATH**/ ?>