<?php $__env->startSection('content'); ?>
<div class="min-h-screen py-12 px-4 flex justify-center items-start">
    <div class="w-full max-w-2xl">
        
        <div class="flex items-center justify-between mb-8 px-6">
            <div class="flex items-center gap-3">
                <div class="w-1.5 h-1.5 rounded-full bg-black animate-pulse"></div>
                <span class="text-[10px] font-black text-black uppercase tracking-[0.2em]"><?php echo app('translator')->get('Secure Payout Node Active'); ?></span>
            </div>
            <span class="text-[10px] font-bold text-gray-400 uppercase tracking-widest">TRX: <?php echo e($withdraw->trx); ?></span>
        </div>

        <div class="relative bg-white border border-gray-100 rounded-[2.5rem] shadow-2xl overflow-hidden">
            
            <div class="p-10 text-center bg-gray-50 border-b border-gray-100">
                <div class="inline-flex items-center justify-center w-16 h-16 rounded-2xl bg-white shadow-sm border border-gray-100 mb-6">
                    <img src="<?php echo e(getImage(getFilePath('withdrawMethod') . '/' . $withdraw->method->image)); ?>" class="w-8 h-8 object-contain" alt="method">
                </div>
                <h2 class="text-[10px] font-black text-gray-400 uppercase tracking-[0.4em] mb-2"><?php echo app('translator')->get('Liquidating via'); ?> <?php echo e(__($withdraw->method->name)); ?></h2>
                <div class="flex items-center justify-center gap-3">
                    <span class="text-4xl font-black text-black tracking-tighter"><?php echo e(showAmount($withdraw->final_amount, currencyFormat:false)); ?></span>
                    <span class="text-xl font-light text-gray-400 uppercase"><?php echo e(__($withdraw->currency)); ?></span>
                </div>
            </div>

            <div class="p-8 md:p-12">
                <form action="<?php echo e(route('user.withdraw.submit')); ?>" method="post" enctype="multipart/form-data" class="space-y-10" id="withdraw-form">
                    <?php echo csrf_field(); ?>
                    
                    <div class="grid grid-cols-2 gap-4 p-6 bg-gray-50 rounded-3xl border border-gray-100">
                        <div class="space-y-1">
                            <p class="text-[9px] font-black text-gray-400 uppercase tracking-widest"><?php echo app('translator')->get('Request'); ?></p>
                            <p class="text-sm font-bold text-black"><?php echo e(showAmount($withdraw->amount)); ?></p>
                        </div>
                        <div class="space-y-1 text-right">
                            <p class="text-[9px] font-black text-gray-400 uppercase tracking-widest"><?php echo app('translator')->get('Protocol Fee'); ?></p>
                            <p class="text-sm font-bold text-rose-500">- <?php echo e(showAmount($withdraw->charge)); ?></p>
                        </div>
                    </div>

                    <?php if($withdraw->method->description): ?>
                    <div class="space-y-4">
                        <div class="flex items-center gap-3">
                            <span class="text-[10px] font-black text-black uppercase tracking-[0.3em]"><?php echo app('translator')->get('Settlement Instructions'); ?></span>
                            <div class="h-px flex-1 bg-gray-100"></div>
                        </div>
                        <div class="text-xs font-medium text-gray-600 bg-gray-50 p-6 rounded-2xl border border-gray-100 leading-relaxed">
                            <?php echo $withdraw->method->description; ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    <div class="viser-form-custom space-y-6">
                        <div class="flex items-center gap-3 mb-2">
                            <span class="text-[10px] font-black text-black uppercase tracking-[0.3em]"><?php echo app('translator')->get('Destination Data'); ?></span>
                            <div class="h-px flex-1 bg-gray-100"></div>
                        </div>
                        <?php if (isset($component)) { $__componentOriginal3bd95de28203859144f617d3fb6afebc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3bd95de28203859144f617d3fb6afebc = $attributes; } ?>
<?php $component = App\View\Components\ViserForm::resolve(['identifier' => 'id','identifierValue' => ''.e($withdraw->method->form_id).''] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('viser-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ViserForm::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3bd95de28203859144f617d3fb6afebc)): ?>
<?php $attributes = $__attributesOriginal3bd95de28203859144f617d3fb6afebc; ?>
<?php unset($__attributesOriginal3bd95de28203859144f617d3fb6afebc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3bd95de28203859144f617d3fb6afebc)): ?>
<?php $component = $__componentOriginal3bd95de28203859144f617d3fb6afebc; ?>
<?php unset($__componentOriginal3bd95de28203859144f617d3fb6afebc); ?>
<?php endif; ?>
                    </div>

                    <?php if(auth()->user()->ts): ?>
                    <div class="relative group mt-8">
                        <div class="p-6 bg-black rounded-2xl transition-all shadow-xl">
                            <label class="text-[10px] font-black text-gray-400 uppercase tracking-widest mb-4 flex items-center gap-2">
                                <i data-lucide="shield-check" class="w-3.5 h-3.5 text-white"></i>
                                <?php echo app('translator')->get('Security Protocol: 2FA Verification'); ?>
                            </label>
                            <input type="text" name="authenticator_code" class="w-full bg-transparent border-none p-0 text-2xl font-black tracking-[0.5em] text-white focus:ring-0 placeholder:text-gray-800" required placeholder="000000">
                        </div>
                    </div>
                    <?php endif; ?>

                    <div class="pt-6">
                        <button type="submit" class="w-full group relative flex items-center justify-between px-8 py-6 bg-black text-white rounded-2xl transition-all hover:scale-[1.01] active:scale-95 shadow-2xl">
                            <span class="text-[11px] font-black uppercase tracking-[0.4em]"><?php echo app('translator')->get('Finalize Settlement'); ?></span>
                            <div class="flex items-center gap-3">
                                <div class="h-8 w-px bg-white/10"></div>
                                <i data-lucide="arrow-right" class="w-5 h-5 text-gray-400 group-hover:translate-x-1 transition-all"></i>
                            </div>
                        </button>
                        
                        <div class="mt-10 flex items-center justify-center gap-6 opacity-30 grayscale grayscale-100">
                            <i data-lucide="shield-check" class="w-5 h-5"></i>
                            <i data-lucide="lock" class="w-5 h-5"></i>
                            <i data-lucide="cpu" class="w-5 h-5"></i>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
    /* Styling the Dynamic Viser Form to match the Black/Gray Terminal UI */
    .viser-form-custom label {
        display: block;
        font-size: 11px;
        font-weight: 800;
        color: #9ca3af;
        margin-bottom: 8px;
        text-transform: uppercase;
        letter-spacing: 0.1em;
    }
    .viser-form-custom input, 
    .viser-form-custom select, 
    .viser-form-custom textarea {
        width: 100%;
        padding: 12px 0;
        background-color: transparent;
        border: none;
        border-bottom: 1px solid #e5e7eb;
        border-radius: 0;
        font-size: 14px;
        font-weight: 600;
        color: #000;
        transition: all 0.2s;
    }
    .viser-form-custom input:focus {
        border-bottom-color: #000;
        outline: none;
    }
    .viser-form-custom input[type="file"] {
        background-color: #f9fafb;
        border: 1px dashed #e5e7eb;
        border-radius: 12px;
        padding: 15px;
        margin-top: 10px;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script src="https://unpkg.com/lucide@latest"></script>
<script>
    (function ($) {
        "use strict";
        lucide.createIcons();
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($activeTemplate . 'layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/user/withdraw/preview.blade.php ENDPATH**/ ?>