<?php if(gs('user_ranking')): ?>
    <?php
        $userRanking = getContent('ranking.content', true);
        $userRankings = App\Models\UserRanking::active()->get();
    ?>

    <?php if($userRankings->count()): ?>
        <section class="py-32 bg-white dark:bg-slate-950 border-t border-slate-100 dark:border-white/5 relative overflow-hidden">
            
            <div class="absolute inset-0 opacity-[0.02] dark:opacity-[0.05] pointer-events-none" 
                 style="background-image: radial-gradient(#000 1px, transparent 1px); background-size: 30px 30px;"></div>

            <div class="container mx-auto px-6 relative z-10">
                
                <div class="text-center max-w-3xl mx-auto mb-24">
                    <div class="inline-flex items-center gap-3 mb-6">
                        <span class="text-[10px] font-black text-emerald-500 uppercase tracking-[0.5em]">Network Status Protocol</span>
                        <div class="h-px w-12 bg-emerald-500/30"></div>
                    </div>
                    <h2 class="text-5xl md:text-7xl font-black text-slate-900 dark:text-white uppercase tracking-tighter leading-none mb-8">
                        <?php echo e(__(@$userRanking->data_values->heading_w)); ?> <span class="text-slate-400"><?php echo e(__(@$userRanking->data_values->heading_c)); ?></span>
                    </h2>
                    <p class="text-lg text-slate-500 dark:text-slate-400 font-medium italic">
                        <?php echo e(__(@$userRanking->data_values->sub_heading)); ?>

                    </p>
                </div>

                <div class="max-w-5xl mx-auto space-y-6">
                    <?php
                        $firstPercent = 20;
                        $lastPercent = 100;
                        $count = $userRankings->count();
                        $perItem = ($lastPercent - $firstPercent) / ($count > 1 ? $count - 1 : 1);
                    ?>

                    <?php $__currentLoopData = $userRankings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="group relative">
                            <div class="flex flex-col md:flex-row items-center gap-6 p-8 bg-slate-50 dark:bg-white/[0.02] border border-slate-200 dark:border-white/5 rounded-[2rem] hover:bg-white dark:hover:bg-slate-900 transition-all duration-500">
                                
                                <div class="flex items-center gap-6 w-full md:w-1/3">
                                    <div class="relative w-16 h-16 shrink-0 bg-white dark:bg-slate-800 rounded-2xl p-2 shadow-lg group-hover:scale-110 transition-transform duration-500">
                                        <img src="<?php echo e(getImage(getFilePath('userRanking') . '/' . $rank->icon, getFileSize('userRanking'))); ?>" 
                                             alt="rank" class="w-full h-full object-contain">
                                    </div>
                                    <div>
                                        <p class="text-[10px] font-black text-emerald-500 uppercase tracking-widest mb-1">Level <?php echo e(__($rank->level)); ?></p>
                                        <h4 class="text-2xl font-black text-slate-900 dark:text-white uppercase tracking-tighter italic">
                                            <?php echo e(__($rank->name)); ?>

                                        </h4>
                                    </div>
                                </div>

                                <div class="w-full md:w-1/3 flex flex-col gap-2">
                                    <div class="h-2 w-full bg-slate-200 dark:bg-white/5 rounded-full overflow-hidden">
                                        <div class="custom-width h-full bg-gradient-to-r from-emerald-600 to-emerald-400 rounded-full" 
                                             data-custom_width="<?php echo e($perItem * $loop->index + $firstPercent); ?>"></div>
                                    </div>
                                    <div class="flex justify-between items-center text-[9px] font-black text-slate-400 uppercase tracking-widest">
                                        <span>Status Index</span>
                                        <span class="text-emerald-500"><?php echo e(round($perItem * $loop->index + $firstPercent)); ?>%</span>
                                    </div>
                                </div>

                                <div class="w-full md:w-1/3 flex items-center justify-between md:justify-end gap-8">
                                    <div class="text-right">
                                        <p class="text-[9px] font-black text-slate-400 uppercase tracking-widest">Tier Bonus</p>
                                        <p class="text-xl font-black text-slate-900 dark:text-white italic">
                                            <i class="las la-coins text-emerald-500"></i> <?php echo e(showAmount($rank->bonus)); ?>

                                        </p>
                                    </div>
                                    
                                    <div class="relative group/tooltip">
                                        <div class="w-10 h-10 rounded-xl bg-slate-900 dark:bg-white flex items-center justify-center cursor-help transition-all group-hover/tooltip:bg-emerald-500">
                                            <i data-lucide="info" class="w-5 h-5 text-white dark:text-slate-900"></i>
                                        </div>

                                        <div class="absolute bottom-full right-0 mb-4 w-72 p-6 bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-3xl shadow-2xl opacity-0 translate-y-4 pointer-events-none group-hover/tooltip:opacity-100 group-hover/tooltip:translate-y-0 transition-all duration-300 z-50">
                                            <p class="text-[10px] font-black text-emerald-500 uppercase tracking-widest mb-6">Credential Requirements</p>
                                            <ul class="space-y-4">
                                                <li class="flex justify-between items-center border-b border-slate-100 dark:border-white/5 pb-2">
                                                    <span class="text-[9px] font-bold text-slate-400 uppercase">Personal</span>
                                                    <span class="text-xs font-black text-slate-900 dark:text-white"><?php echo e(showAmount($rank->minimum_invest)); ?></span>
                                                </li>
                                                <li class="flex justify-between items-center border-b border-slate-100 dark:border-white/5 pb-2">
                                                    <span class="text-[9px] font-bold text-slate-400 uppercase">Team Flow</span>
                                                    <span class="text-xs font-black text-slate-900 dark:text-white"><?php echo e(showAmount($rank->min_referral_invest)); ?></span>
                                                </li>
                                                <li class="flex justify-between items-center">
                                                    <span class="text-[9px] font-bold text-slate-400 uppercase">Directs</span>
                                                    <span class="text-xs font-black text-slate-900 dark:text-white"><?php echo e($rank->min_referral); ?></span>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php $__env->startPush('script'); ?>
        <script>
            (function($) {
                "use strict";
                $(document).ready(function() {
                    $('.custom-width').each(function(index, value) {
                        $(value).css("width", `${$(value).data('custom_width')}%`);
                    });
                });
            })(jQuery);
        </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/sections/ranking.blade.php ENDPATH**/ ?>