<?php $__env->startSection('content'); ?>
<div class="px-4 mx-auto py-3">

    <?php $__env->startPush('breadcrumb_text'); ?>
    <div class="flex items-center gap-5">
        <div class="relative group">
            <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-2xl blur opacity-25"></div>
            <div class="relative w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white border border-white/10 shadow-2xl">
                <i data-lucide="wallet-cards" class="w-7 h-7 text-emerald-400"></i>
            </div>
        </div>
        <div>
            <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase"><?php echo app('translator')->get('Withdraw Funds'); ?></h2>
            <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-1"><?php echo app('translator')->get('Extract/Liquidate wallet assets'); ?></p>
        </div>
    </div>
    <?php $__env->stopPush(); ?>

    <div class="flex flex-col md:flex-row md:items-center justify-between gap-6 mb-12">
        <?php $__env->startPush('breadcrumb'); ?>
        <a href="<?php echo e(route('user.withdraw.history')); ?>" class="group relative px-6 py-3 bg-slate-100 dark:bg-white/5 rounded-xl transition-all hover:bg-slate-900 dark:hover:bg-white overflow-hidden">
            <span class="relative z-10 text-[10px] font-black uppercase tracking-widest text-slate-600 dark:text-slate-400 group-hover:text-white dark:group-hover:text-slate-900"><?php echo app('translator')->get('Withdrawal History'); ?></span>
        </a>
        <?php $__env->stopPush(); ?>
    </div>

    <?php if($isHoliday && !gs('holiday_withdraw')): ?>
    <div class="relative max-w-4xl mx-auto mt-10">
        <div class="absolute -inset-1 bg-gradient-to-r from-rose-500 to-orange-500 rounded-[2.5rem] blur opacity-20"></div>
        <div class="relative bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2.5rem] p-12 text-center">
            <div class="w-20 h-20 bg-rose-500/10 rounded-3xl flex items-center justify-center mx-auto mb-6 border border-rose-500/20">
                <i data-lucide="calendar-off" class="w-10 h-10 text-rose-500"></i>
            </div>
            <h3 class="text-xl font-black text-slate-900 dark:text-white uppercase tracking-tighter mb-4"><?php echo app('translator')->get('Withdrawal Protocol Suspended'); ?></h3>
            <p class="text-slate-500 dark:text-slate-400 text-sm max-w-md mx-auto mb-10 font-bold uppercase tracking-tight"><?php echo app('translator')->get('Requests are disabled today. Access will be restored in:'); ?></p>
            
            <div id="counter" class="flex justify-center gap-4 sm:gap-8 font-mono text-3xl font-black text-emerald-500 tracking-tighter shadow-inner py-6 bg-slate-50 dark:bg-white/5 rounded-3xl">
                </div>
        </div>
    </div>
    <script>
        "use strict"
        function createCountDown(elementId, sec) {
            var tms = sec;
            var x = setInterval(function() {
                var distance = tms * 1000;
                var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                var seconds = Math.floor((distance % (1000 * 60)) / 1000);
                
                document.getElementById(elementId).innerHTML = `
                    <div class="flex flex-col"><span class="leading-none">${days}d</span><span class="text-[9px] uppercase tracking-widest text-slate-400 mt-2">Days</span></div>
                    <div class="flex flex-col"><span class="leading-none">${hours}h</span><span class="text-[9px] uppercase tracking-widest text-slate-400 mt-2">Hours</span></div>
                    <div class="flex flex-col"><span class="leading-none">${minutes}m</span><span class="text-[9px] uppercase tracking-widest text-slate-400 mt-2">Mins</span></div>
                    <div class="flex flex-col"><span class="leading-none">${seconds}s</span><span class="text-[9px] uppercase tracking-widest text-slate-400 mt-2">Secs</span></div>
                `;
                if (distance < 0) {
                    clearInterval(x);
                    document.getElementById(elementId).innerHTML = "PROTOCOL READY";
                }
                tms--;
            }, 1000);
        }
        createCountDown('counter', <?php echo e(abs(\Carbon\Carbon::parse($nextWorkingDay)->diffInSeconds())); ?>);
    </script>
    <?php else: ?>

    <form action="<?php echo e(route('user.withdraw.money')); ?>" method="post" class="withdraw-form">
        <?php echo csrf_field(); ?>
        <div class="grid grid-cols-12 gap-8">
            <div class="col-span-12 lg:col-span-7 space-y-6">
                <div class="flex items-center gap-4 mb-4">
                    <span class="text-[11px] font-black text-slate-900 dark:text-white uppercase tracking-[0.3em]">01. <?php echo app('translator')->get('Withdrawal Method'); ?></span>
                    <div class="h-px flex-1 bg-slate-200 dark:bg-white/10"></div>
                </div>

                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 gateway-option-list">
                    <?php $__currentLoopData = $withdrawMethod; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <label for="<?php echo e(titleToKey($data->name)); ?>" class="group relative cursor-pointer gateway-option <?php if($loop->index > 3): ?> d-none <?php endif; ?>">
                            <input class="payment-item__radio gateway-input hidden" id="<?php echo e(titleToKey($data->name)); ?>" data-gateway='<?php echo json_encode($data, 15, 512) ?>' type="radio" name="method_code" value="<?php echo e($data->id); ?>" <?php if(old('method_code', $loop->first) == $data->id): echo 'checked'; endif; ?> data-min-amount="<?php echo e(showAmount($data->min_limit)); ?>" data-max-amount="<?php echo e(showAmount($data->max_limit)); ?>">
                            
                            <div class="method-card relative p-5 rounded-2xl bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 transition-all duration-300 group-hover:border-emerald-500/50 group-has-[:checked]:border-emerald-500 group-has-[:checked]:ring-1 group-has-[:checked]:ring-emerald-500">
                                <div class="flex items-center gap-4">
                                    <div class="w-12 h-12 rounded-xl bg-slate-50 dark:bg-white/5 p-2 flex items-center justify-center overflow-hidden border border-slate-100 dark:border-white/5">
                                        <img src="<?php echo e(getImage(getFilePath('withdrawMethod') . '/' . $data->image)); ?>" class="w-full h-full object-contain filter grayscale group-has-[:checked]:grayscale-0 transition-all" alt="gateway">
                                    </div>
                                    <div class="flex-1">
                                        <p class="text-xs font-black text-slate-900 dark:text-white uppercase tracking-tighter"><?php echo e(__($data->name)); ?></p>
                                        <p class="text-[9px] font-bold text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Secure Payout'); ?></p>
                                    </div>
                                    <div class="w-5 h-5 rounded-full border-2 border-slate-200 dark:border-white/10 flex items-center justify-center group-has-[:checked]:border-emerald-500 group-has-[:checked]:bg-emerald-500 transition-all">
                                        <i data-lucide="check" class="w-3 h-3 text-white hidden group-has-[:checked]:block"></i>
                                    </div>
                                </div>
                            </div>
                        </label>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <?php if($withdrawMethod->count() > 4): ?>
                    <button type="button" class="more-gateway-option w-full py-4 rounded-2xl border-2 border-dashed border-slate-200 dark:border-white/5 text-[10px] font-black uppercase tracking-widest text-slate-400 hover:text-emerald-500 hover:border-emerald-500/50 transition-all">
                        <?php echo app('translator')->get('Show More Settlement Options'); ?>
                    </button>
                <?php endif; ?>
            </div>

            <div class="col-span-12 lg:col-span-5">
                <div class="flex items-center gap-4 mb-4">
                    <span class="text-[11px] font-black text-slate-900 dark:text-white uppercase tracking-[0.3em]">02. <?php echo app('translator')->get('Liquidation Spec'); ?></span>
                    <div class="h-px flex-1 bg-slate-200 dark:bg-white/10"></div>
                </div>

                <div class="relative">
                    <div class="absolute -inset-0.5 bg-gradient-to-b from-blue-500/20 to-transparent rounded-[2rem] blur-sm"></div>
                    
                    <div class="relative bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2rem] p-8 shadow-2xl">
                        
                        <div class="mb-8">
                            <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest mb-3 block"><?php echo app('translator')->get('Withdrawal Amount'); ?></label>
                            <div class="relative group">
                                <div class="absolute left-5 top-1/2 -translate-y-1/2 text-slate-400 font-black"><?php echo e(gs('cur_sym')); ?></div>
                                <input type="text" class="amount w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-5 pl-12 pr-6 text-xl font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-blue-500 transition-all outline-none" name="amount" placeholder="0.00" value="<?php echo e(old('amount')); ?>" autocomplete="off">
                            </div>
                        </div>

                        <div class="space-y-4 pt-6 border-t border-slate-100 dark:border-white/5">
                            <div class="flex justify-between items-center">
                                <span class="text-[10px] font-bold text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Protocol Limit'); ?></span>
                                <span class="text-[11px] font-black text-slate-900 dark:text-white gateway-limit">0.00</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <div class="flex items-center gap-2">
                                    <span class="text-[10px] font-bold text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Network Charge'); ?></span>
                                    <span class="proccessing-fee-info cursor-help text-slate-300" data-bs-toggle="tooltip" title="<?php echo app('translator')->get('Processing charge for withdraw method'); ?>"><i data-lucide="info" class="w-3 h-3"></i></span>
                                </div>
                                <span class="text-[11px] font-black text-rose-500">- <span class="processing-fee">0.00</span> <?php echo e(__(gs('cur_text'))); ?></span>
                            </div>
                            
                            <div class="gateway-conversion d-none py-3 px-4 bg-emerald-500/5 rounded-xl border border-emerald-500/10">
                                <div class="flex justify-between items-center text-[10px] font-black">
                                    <span class="text-emerald-600 uppercase"><?php echo app('translator')->get('Conversion Rate'); ?></span>
                                    <span class="text-emerald-600 conversion-rate-text"></span>
                                </div>
                            </div>

                            <div class="conversion-currency d-none flex justify-between items-center pt-2">
                                <span class="text-[10px] font-black text-slate-900 dark:text-white uppercase tracking-widest"><?php echo app('translator')->get('In Method Currency'); ?></span>
                                <span class="text-lg font-black text-emerald-500 in-currency font-mono"></span>
                            </div>

                            <div class="pt-6">
                                <div class="flex justify-between items-end mb-6">
                                    <span class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em]"><?php echo app('translator')->get('Final Receivable'); ?></span>
                                    <div class="text-right">
                                        <span class="text-3xl font-black text-slate-900 dark:text-white tracking-tighter"><?php echo e(gs('cur_sym')); ?><span class="final-amount">0.00</span></span>
                                    </div>
                                </div>

                                <button type="submit" class="group relative w-full h-16 bg-slate-900 dark:bg-white rounded-2xl overflow-hidden transition-all active:scale-95 disabled:opacity-50 disabled:pointer-events-none" disabled>
                                    <div class="absolute inset-0 bg-gradient-to-r from-blue-500 to-indigo-600 opacity-0 group-hover:opacity-100 transition-opacity"></div>
                                    <span class="relative text-[11px] font-black text-white dark:text-slate-900 uppercase tracking-[0.3em] group-hover:text-white"><?php echo app('translator')->get('Confirm Withdraw'); ?></span>
                                </button>
                                
                                <p class="text-[9px] text-center text-slate-400 mt-4 px-6 leading-relaxed uppercase font-black tracking-tight italic">
                                    <?php echo app('translator')->get('Safely liquidate your funds via secure payout nodes.'); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<script>
    "use strict";
    (function($) {

        var amount = parseFloat($('.amount').val() || 0);
        var gateway, minAmount, maxAmount;

        $('.amount').on('input', function(e) {
            amount = parseFloat($(this).val());
            if (!amount) { amount = 0; }
            calculation();
        });

        $('.gateway-input').on('change', function(e) {
            gatewayChange();
        });

        function gatewayChange() {
            let gatewayElement = $('.gateway-input:checked');
            gateway = gatewayElement.data('gateway');
            minAmount = gatewayElement.data('min-amount');
            maxAmount = gatewayElement.data('max-amount');

            let processingFeeInfo = `${parseFloat(gateway.percent_charge).toFixed(2)}% with ${parseFloat(gateway.fixed_charge).toFixed(2)} <?php echo e(__(gs('cur_text'))); ?> charge`;
            $(".proccessing-fee-info").attr("data-bs-original-title", processingFeeInfo);

            calculation();
        }

        function calculation() {
            if (!gateway) return;
            $(".gateway-limit").text(minAmount + " - " + maxAmount);
            let percentCharge = 0;
            let fixedCharge = 0;
            let totalPercentCharge = 0;

            if (amount) {
                percentCharge = parseFloat(gateway.percent_charge);
                fixedCharge = parseFloat(gateway.fixed_charge);
                totalPercentCharge = parseFloat(amount / 100 * percentCharge);
            }

            let totalCharge = parseFloat(totalPercentCharge + fixedCharge);
            let totalAmount = parseFloat((amount || 0) - totalPercentCharge - fixedCharge);

            $(".final-amount").text(totalAmount.toFixed(2));
            $(".processing-fee").text(totalCharge.toFixed(2));
            $(".gateway-currency").text(gateway.currency);

            if (amount < Number(gateway.min_limit) || amount > Number(gateway.max_limit)) {
                $(".withdraw-form button[type=submit]").attr('disabled', true);
            } else {
                $(".withdraw-form button[type=submit]").removeAttr('disabled');
            }

            if (gateway.currency != "<?php echo e(gs('cur_text')); ?>") {
                $(".gateway-conversion, .conversion-currency").removeClass('d-none');
                $(".conversion-rate-text").html(`1 <?php echo e(__(gs('cur_text'))); ?> = ${parseFloat(gateway.rate).toFixed(2)} ${gateway.currency}`);
                $('.in-currency').text(parseFloat(totalAmount * gateway.rate).toFixed(2) + ' ' + gateway.currency);
            } else {
                $(".gateway-conversion, .conversion-currency").addClass('d-none');
            }
        }

        $(".more-gateway-option").on("click", function(e) {
            $(".gateway-option").removeClass("d-none");
            $(this).addClass('d-none');
        });

        // Tooltip init
        if (typeof bootstrap !== 'undefined') {
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            });
        } else {
            console.warn("Bootstrap JS not found. Tooltips will fallback to default titles.");
        }

        gatewayChange();
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/withdraw/methods.blade.php ENDPATH**/ ?>