<?php
    $blogs = getContent('blog.element', false, 3);
    $blogContent = getContent('blog.content', true);
?>
<!--==========================  Blog Section Start  ==========================-->
    <section class="blog-section bg--black-two py-120">
        <div class="container position-relative">
            <div class="blog-shape d-none d-lg-block">
                <img src="<?php echo e(asset('assets/frontend/svg/balance-6.svg')); ?>" alt="balance">
                <img src="<?php echo e(asset('assets/frontend/svg/maneyPlant.svg')); ?>" alt="balance">
            </div>
            <div class="row row-gap-4">
                <div class="col-lg-6 align-self-center">
                    <div class="section-content">
                        <h6 class="right-reveal">Blogs</h6>
                        <h2 class="mb-0 right-reveal">News & Analysis</h2>
                    </div>
                </div>
                <div class="col-lg-6 align-self-center">
                    <div class="float-lg-end left-reveal">
                        <a href="#" class="btn btn--base-two ">
                            See More <i class="flaticon-arrow-upper-right"></i>
                        </a>
                    </div>
                </div>
            </div>
            <div class="row mt-60 row-gap-4">
                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-6 right-reveal">
                    <div class="blog-item">
                        <img src="<?php echo e(frontendImage('blog' , 'thumb_'. @$data->data_values->image, '460x240')); ?>" alt="blog"
                            class="img-fluid w-100">
                        <ul class="blog-list">
                            <li>Ai Trends</li>
                            <li><?php echo e($data->created_at->format('M d, Y')); ?></li>
                        </ul>
                        <h4>
                            <a href="<?php echo e(route('blog.details', $data->slug)); ?>">
                                <?php echo app('translator')->get(strLimit(strip_tags(@$data->data_values->description), 50)); ?>
                            </a>
                        </h4>
                        <a href="<?php echo e(route('blog.details', $data->slug)); ?>" class="btn btn--base-two">
                            Read More <i class="flaticon-arrow-upper-right"></i>
                        </a>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                 
            </div>
        </div>
    </section>
    <!--==========================  Blog Section End  ==========================-->
 <?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/sections/blog.blade.php ENDPATH**/ ?>