<?php
    $latestDeposit = \App\Models\Deposit::with('user', 'gateway')->where('status', 1)->latest()->limit(10)->get();
    $fakeDeposit = \App\Models\Frontend::where('data_keys', 'transaction.element')->whereJsonContains('data_values->trx_type', 'deposit')->limit(10)->get();
    $deposits = $latestDeposit->merge($fakeDeposit);
    $deposits = $deposits->sortByDesc('created_at')->take(10);

    $latestWithdraw = \App\Models\Withdrawal::with('user', 'method')->where('status', 1)->latest()->limit(10)->get();
    $fakeWithdraw = \App\Models\Frontend::where('data_keys', 'transaction.element')->whereJsonContains('data_values->trx_type', 'withdraw')->limit(10)->get();

    $withdrawals = $latestWithdraw->merge($fakeWithdraw);
    $withdrawals = $withdrawals->sortByDesc('created_at')->take(10);
    $transactionContent = getContent('transaction.content', true);
?>
            <!--==========================  Trade Section Start  ==========================-->
            <section class="trade-smartet-section bg--black py-120">
                <div class="container position-relative">
                    <div class="trade-smartet-shape d-none d-lg-block">
                        <img src="assets/svg/twostar.svg" alt="star">
                        <img src="assets/svg/balance-3.svg" alt="balance">
                    </div>
                    <div class="row justify-content-center">
                        <div class="col-xl-6 col-lg-8">
                            <div class="section-content text-center">
                                <h6 class="top-reveal">Trade Smarter</h6>
                                <h2 class="top-reveal"><?php echo e(__(@$transactionContent->data_values->heading_w)); ?> <?php echo e(__(@$transactionContent->data_values->heading_c)); ?> </h2>
                                <p class="top-reveal"><?php echo e(__(@$transactionContent->data_values->sub_heading)); ?> </p>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-60">
                        <div class="col-lg-12">
                            <div class="bg--black-two trabe-info bottom-reveal">
                                <div
                                    class="table-nav d-flex flex-wrap gap-4 align-items-center justify-content-between">
                                    <ul class="nav nav-pills order-1 order-xl-0" id="pills-tab" role="tablist">
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link active" data-bs-toggle="pill"
                                                data-bs-target="#pills-all" role="tab"><?php echo app('translator')->get('Capital Inflow'); ?></button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-forex"
                                                role="tab"><?php echo app('translator')->get('Capital Outflow'); ?></button>
                                        </li> 
                                    </ul>
                                    <form action="#">
                                        <input type="search" placeholder="Search the instruments">
                                        <button type="submit"><i class="fa-solid fa-magnifying-glass"></i></button>
                                    </form>
                                </div>
                                <div class="tab-content mt-4" id="pills-tabContent">
                                    <div class="tab-pane fade show active" id="pills-all" role="tabpanel" tabindex="0">
                                        <div class="table-responsive">

                                            <div class="trade-table-content">
                                                <div class="trade-content d-grid gap-3">
                                                    <ul class="bg--base">
                                                        <li>Name</li>
                                                        <li>Date</li>
                                                        <li>Buy</li>
                                                        <li>Spread</li>
                                                        <li></li>
                                                    </ul>
                                                    <div class="accordion-trave d-grid row-gap-3">
                                                        <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="at-item">
                                                            <div class="at-title">
                                                                <ul>
                                                                    <li><?php echo e(@$data->data_values ? __(@$data->data_values->name) : __(@$data->user->fullname)); ?></li>
                                                                    <li><?php echo e(@$data->data_values ? @$data->data_values->date : showDateTime($data->created_at, 'Y-m-d')); ?></li>
                                                                    <li> +<?php echo e(@$data->data_values ? @$data->data_values->amount : getAmount($data->amount)); ?> <?php echo e(gs('cur_text')); ?></li>
                                                                    <li><?php echo e(@$data->data_values ? __(@$data->data_values->gateway) : __(@$data->gateway->name)); ?></li>
                                                                    <li></li>
                                                                </ul>
                                                            </div>
                                                            <div class="at-tab">
                                                                <div class="tradingChart tradingview-widget-container">
                                                                </div>
                                                            </div>
                                                        </div> 
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="text-center mt-4">
                                            <a href="<?php echo e(route('user.transactions')); ?>" class="btn btn--base-two">
                                                See More <i class="flaticon-arrow-upper-right"></i>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="pills-forex" role="tabpanel" tabindex="0">
                                        <div class="table-responsive">

                                            <div class="trade-table-content">
                                                <div class="trade-content d-grid gap-3">
                                                    <ul class="bg--base">
                                                        <li>Name</li>
                                                        <li>Date</li>
                                                        <li>Amount</li>
                                                        <li>Method</li>
                                                        <li></li>
                                                    </ul>
                                                    <div class="accordion-trave d-grid row-gap-3">
                                                         <?php $__currentLoopData = $withdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="at-item">
                                                            <div class="at-title">
                                                                <ul>
                                                                    <li><?php echo e(@$data->data_values ? __(@$data->data_values->name) : __(@$data->user->fullname)); ?></li>
                                                                    <li><?php echo e(@$data->data_values ? @$data->data_values->date : showDateTime($data->created_at, 'Y-m-d')); ?></li>
                                                                    <li> -<?php echo e(@$data->data_values ? @$data->data_values->amount : getAmount($data->amount)); ?> <?php echo e(gs('cur_text')); ?></li>
                                                                    <li><?php echo e(@$data->data_values ? __(@$data->data_values->gateway) : __($data->method->name)); ?></li>
                                                                    <li></li>
                                                                </ul>
                                                            </div>
                                                            <div class="at-tab">
                                                                <div class="tradingChart tradingview-widget-container">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="text-center mt-4">
                                            <a href="<?php echo e(route('user.transactions')); ?>" class="btn btn--base-two">
                                                See More <i class="flaticon-arrow-upper-right"></i>
                                            </a>
                                        </div>
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--==========================  Trade Section End  ==========================-->
 <?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/sections/transaction.blade.php ENDPATH**/ ?>