<?php $__env->startSection('content'); ?>
<div class="py-4 px-4 mx-auto">
    
    <div class="grid grid-cols-12 gap-6 mb-10">
        
        <div class="col-span-12 lg:col-span-5 flex flex-col gap-6">
            <div class="relative overflow-hidden border border-slate-200 dark:border-white/10 bg-white dark:bg-slate-900 rounded-xl p-6 shadow-sm group">
                <div class="absolute top-0 right-0 p-4 opacity-10 group-hover:opacity-20 transition-opacity">
                    <i data-lucide="bar-chart-big" class="w-16 h-16"></i>
                </div>
                <p class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em] mb-1"><?php echo app('translator')->get('Active Deployment'); ?></p>
                <h3 class="text-3xl font-black text-slate-900 dark:text-white tracking-tighter">
                    <span class="text-sm font-bold text-slate-400 mr-1"><?php echo e(gs('cur_sym')); ?></span><?php echo e(showAmount(auth()->user()->invests->sum('amount'), currencyFormat:false)); ?>

                </h3>
                <div class="mt-4 flex gap-2">
                    <a href="<?php echo e(route('plan')); ?>" class="text-[10px] font-black uppercase text-emerald-500 hover:text-emerald-600 flex items-center gap-1 transition-all">
                        <?php echo app('translator')->get('Increase Stake'); ?> <i data-lucide="arrow-up-right" class="w-3 h-3"></i>
                    </a>
                </div>
            </div>

            <div class="relative overflow-hidden border border-slate-200 dark:border-white/10 bg-slate-900 dark:bg-white rounded-xl p-6 shadow-xl group">
                <p class="text-[10px] font-black text-slate-500 dark:text-slate-400 uppercase tracking-[0.2em] mb-1"><?php echo app('translator')->get('Net Yield Generated'); ?></p>
                <h3 class="text-3xl font-black text-white dark:text-slate-900 tracking-tighter">
                    <span class="text-sm font-bold opacity-50 mr-1"><?php echo e(gs('cur_sym')); ?></span><?php echo e(showAmount(auth()->user()->transactions()->where('remark', 'interest')->sum('amount'), currencyFormat:false)); ?>

                </h3>
                <div class="mt-4">
                    <a href="<?php echo e(route('user.withdraw')); ?>" class="inline-block py-2 px-4 rounded-lg bg-emerald-500 text-white text-[10px] font-black uppercase tracking-widest hover:bg-emerald-600 transition-all">
                        <?php echo app('translator')->get('Withdraw Profit'); ?>
                    </a>
                </div>
            </div>
        </div>

        <div class="col-span-12 lg:col-span-7">
            <div class="h-full border border-slate-200 dark:border-white/10 bg-white dark:bg-slate-900 rounded-xl p-8 flex flex-col">
                <div class="flex justify-between items-center mb-8">
                    <h4 class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em]"><?php echo app('translator')->get('Asset Distribution'); ?></h4>
                    <div class="px-3 py-1 bg-slate-100 dark:bg-white/5 rounded-md text-[10px] font-bold text-slate-500"><?php echo app('translator')->get('Live Portfolio'); ?></div>
                </div>

                <?php if($investChart->count()): ?>
                    <div class="grid grid-cols-1 md:grid-cols-2 items-center gap-8 flex-1">
                        <div class="space-y-4 order-2 md:order-1">
                            <?php $__currentLoopData = $investChart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex items-center justify-between group">
                                    <div class="flex items-center gap-3">
                                        <div class="w-3 h-3 rounded-sm plan-indicator" style="background-color: transparent;"></div>
                                        <span class="text-xs font-black text-slate-600 dark:text-slate-400 uppercase tracking-tighter group-hover:text-slate-900 dark:group-hover:text-white transition-colors"><?php echo e(__($chart->plan->name)); ?></span>
                                    </div>
                                    <span class="text-xs font-mono font-bold text-slate-900 dark:text-white">
                                        <?php echo e(showAmount(($chart->investAmount / $investChart->sum('investAmount')) * 100, currencyFormat:false)); ?>%
                                    </span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <div class="relative flex justify-center items-center order-1 md:order-2">
                            <div class="w-48 h-48">
                                <canvas id="investDonutChart"></canvas>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="flex-1 flex flex-col items-center justify-center border-2 border-dashed border-slate-100 dark:border-white/5 rounded-xl">
                        <i data-lucide="pie-chart" class="w-10 h-10 text-slate-200 mb-2"></i>
                        <p class="text-[10px] font-black text-slate-300 uppercase tracking-widest"><?php echo app('translator')->get('Insufficient Data'); ?></p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="flex items-center justify-between mb-6 px-2">
        <h4 class="text-[11px] font-black text-slate-900 dark:text-white uppercase tracking-[0.3em]"><?php echo app('translator')->get('Investment Terminal Log'); ?></h4>
        <a href="<?php echo e(route('user.invest.log')); ?>" class="text-[10px] font-bold text-slate-400 hover:text-emerald-500 uppercase transition-colors"><?php echo app('translator')->get('View Details'); ?></a>
    </div>

    <div class="overflow-hidden border border-slate-200 dark:border-white/10 bg-white dark:bg-slate-900 rounded-xl shadow-sm">
        <?php echo $__env->make('Template::partials.invest_history',['invests'=>$invests], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script src="https://unpkg.com/lucide@latest"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        (function($){
            "use strict";

            // Initialize Lucide Icons
            lucide.createIcons();

            // Premium Dark/Light Palette
            const colorPalette = [
                '#10b981', // Emerald
                '#6366f1', // Indigo
                '#f59e0b', // Amber
                '#3b82f6', // Blue
                '#ec4899', // Pink
                '#8b5cf6', // Violet
                '#14b8a6', // Teal
                '#f43f5e'  // Rose
            ];

            const ctx = document.getElementById('investDonutChart');
            
            if(ctx) {
                const myChart = new Chart(ctx, {
                    type: 'doughnut',
                    data: {
                        labels: [<?php $__currentLoopData = $investChart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> '<?php echo e($chart->plan->name); ?>', <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>],
                        datasets: [{
                            data: [<?php $__currentLoopData = $investChart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($chart->investAmount); ?>, <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>],
                            backgroundColor: colorPalette,
                            borderWidth: 0,
                            hoverOffset: 15
                        }]
                    },
                    options: {
                        cutout: '82%', // Slimmer modern donut
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: { display: false },
                            tooltip: {
                                backgroundColor: '#0f172a',
                                titleFont: { size: 10, weight: 'bold' },
                                bodyFont: { size: 12 },
                                padding: 12,
                                displayColors: false
                            }
                        }
                    }
                });

                // Apply Colors to Legend Indicators
                $('.plan-indicator').each(function(index) {
                    $(this).css('background-color', colorPalette[index % colorPalette.length]);
                });
            }

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/invest_statistics.blade.php ENDPATH**/ ?>