<?php $__env->startSection('content'); ?>
    <div class="px-4 mx-auto py-8">

        

        <div class="flex flex-col md:flex-row md:items-center justify-between gap-6 mb-12 px-4">
            <?php $__env->startPush('breadcrumb_text'); ?>
                <div class="flex items-center gap-5">
                    <div class="relative group">
                        <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-2xl blur opacity-25">
                        </div>
                        <div
                            class="relative w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white border border-white/10 shadow-2xl">
                            <i data-lucide="messages-square" class="w-7 h-7 text-emerald-400"></i>
                        </div>
                    </div>
                    <div>
                        <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase">
                            <?php echo app('translator')->get('Support Tickets'); ?></h2>
                        <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-1"><?php echo app('translator')->get('Active communication channels with core tech'); ?></p>
                    </div>
                </div>
            <?php $__env->stopPush(); ?>

            
            <?php $__env->startPush('breadcrumb'); ?>
                <a href="<?php echo e(route('ticket.open')); ?>"
                    class="group relative px-8 py-4 bg-slate-900 dark:bg-white rounded-2xl overflow-hidden transition-all active:scale-95 shadow-xl">
                    <div
                        class="absolute inset-0 bg-gradient-to-r from-emerald-500 to-blue-500 opacity-0 group-hover:opacity-100 transition-opacity">
                    </div>
                    <div class="relative flex items-center gap-3">
                        <span
                            class="text-[10px] font-black text-white dark:text-slate-900 uppercase tracking-widest group-hover:text-white"><?php echo app('translator')->get('Open New Ticket'); ?></span>
                        <i data-lucide="plus-circle"
                            class="w-4 h-4 text-emerald-500 group-hover:text-white transition-transform group-hover:rotate-90"></i>
                    </div>
                </a>
            <?php $__env->stopPush(); ?>
        </div>

        
        <div class="relative group">
            <div class="absolute -inset-0.5 bg-gradient-to-b from-blue-500/10 to-transparent rounded-[2.5rem] blur-sm">
            </div>

            <div
                class="relative bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2.5rem] overflow-hidden shadow-2xl">
                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-slate-50 dark:bg-white/[0.02] border-b border-slate-100 dark:border-white/5">
                                <th class="px-8 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest">
                                    <?php echo app('translator')->get('Ticket Subject'); ?></th>
                                <th
                                    class="px-6 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest text-center">
                                    <?php echo app('translator')->get('Status'); ?></th>
                                <th
                                    class="px-6 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest text-center">
                                    <?php echo app('translator')->get('Priority'); ?></th>
                                <th
                                    class="px-6 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest text-center">
                                    <?php echo app('translator')->get('Last Activity'); ?></th>
                                <th
                                    class="px-8 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest text-right">
                                    <?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-slate-100 dark:divide-white/5">
                            <?php $__empty_1 = true; $__currentLoopData = $supports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $support): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr
                                    class="group hover:bg-slate-50/50 dark:hover:bg-white/[0.01] transition-all duration-300">
                                    
                                    <td class="px-8 py-6">
                                        <a href="<?php echo e(route('ticket.view', $support->ticket)); ?>" class="block group/link">
                                            <p
                                                class="text-[9px] font-black text-emerald-500 uppercase tracking-widest mb-1">
                                                #<?php echo e($support->ticket); ?></p>
                                            <span
                                                class="text-xs font-black text-slate-900 dark:text-white tracking-tighter uppercase group-hover/link:text-blue-500 transition-colors"><?php echo e(__($support->subject)); ?></span>
                                        </a>
                                    </td>

                                    
                                    <td class="px-6 py-6 text-center">
                                        <div class="status-badge-wrapper inline-block">
                                            <?php echo $support->statusBadge; ?>
                                        </div>
                                    </td>

                                    
                                    <td class="px-6 py-6 text-center">
                                        <div class="priority-badge-wrapper inline-block">
                                            <?php echo $support->priorityBadge; ?>
                                        </div>
                                    </td>

                                    
                                    <td class="px-6 py-6 text-center">
                                        <span
                                            class="text-[10px] font-black text-slate-900 dark:text-white uppercase tracking-tight"><?php echo e(diffForHumans($support->last_reply)); ?></span>
                                    </td>

                                    
                                    <td class="px-8 py-6 text-right">
                                        <a href="<?php echo e(route('ticket.view', $support->ticket)); ?>"
                                            class="inline-flex items-center justify-center w-10 h-10 rounded-xl bg-slate-100 dark:bg-white/5 text-slate-500 hover:bg-blue-500 hover:text-white transition-all shadow-sm">
                                            <i data-lucide="terminal" class="w-4 h-4"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="px-8 py-24 text-center" colspan="100%">
                                        <div class="flex flex-col items-center opacity-30">
                                            <i data-lucide="inbox" class="w-12 h-12 mb-4"></i>
                                            <p class="text-[10px] font-black uppercase tracking-[0.3em]">
                                                <?php echo e(__($emptyMessage)); ?></p>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                
                <div class="h-1.5 bg-gradient-to-r from-emerald-500 via-blue-500 to-indigo-600"></div>
            </div>
        </div>

        <?php if($supports->hasPages()): ?>
            <div class="mt-10 flex justify-end">
                <?php echo e(paginateLinks($supports)); ?>

            </div>
        <?php endif; ?>
    </div>

    <style>
        /* Scoped Badge Refactoring to match your dashboard UI */
        .status-badge-wrapper .badge,
        .priority-badge-wrapper .badge {
            padding: 4px 12px !important;
            font-size: 8px !important;
            font-weight: 900 !important;
            text-transform: uppercase !important;
            letter-spacing: 0.1em !important;
            border-radius: 100px !important;
            border: 1px solid rgba(255, 255, 255, 0.1) !important;
        }

        .badge.bg--success {
            background-color: rgba(16, 185, 129, 0.1) !important;
            color: #10b981 !important;
            border-color: rgba(16, 185, 129, 0.2) !important;
        }

        .badge.bg--primary {
            background-color: rgba(59, 130, 246, 0.1) !important;
            color: #3b82f6 !important;
            border-color: rgba(59, 130, 246, 0.2) !important;
        }

        .badge.bg--warning {
            background-color: rgba(245, 158, 11, 0.1) !important;
            color: #f59e0b !important;
            border-color: rgba(245, 158, 11, 0.2) !important;
        }

        .badge.bg--danger {
            background-color: rgba(239, 68, 68, 0.1) !important;
            color: #ef4444 !important;
            border-color: rgba(239, 68, 68, 0.2) !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="https://unpkg.com/lucide@latest"></script>
    <script>
        "use strict";
        (function($) {
            lucide.createIcons();
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/support/index.blade.php ENDPATH**/ ?>