<?php $__env->startSection('content'); ?>
    <div class="max-w-7xl mx-auto">
        <!-- Enhanced Header -->
        <div
            class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
                <div class="absolute bottom-0 left-0 w-24 h-24 bg-white rounded-full translate-y-12 -translate-x-12"></div>
            </div>

            <div class="relative z-10">
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                    <div class="mb-4 lg:mb-0 lg:flex-1">
                        <h1 class="text-xl font-light mb-1">Profile Settings</h1>
                        <p class="text-gray-300 text-sm">Manage your account information and preferences</p>
                    </div>

                    <!-- Profile Image Preview -->
                    <div
                        class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-64">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-xs text-gray-300 mb-1">Profile Image</p>
                                <div
                                    class="w-16 h-16 bg-gradient-to-br from-blue-400 to-blue-600 rounded-xl flex items-center justify-center">
                                    <span class="text-white font-medium text-lg">C</span>
                                </div>
                            </div>
                            <div class="w-10 h-10 flex items-center justify-center">
                                <i data-lucide="user" class="w-5 h-5 text-white"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Profile Form -->
        <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
            <form class="register space-y-8" method="post">
                <?php echo csrf_field(); ?>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="space-y-2">
                        <label
                            class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('First Name'); ?></label>
                        <input type="text"
                            class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-emerald-500 transition-all outline-none"
                            name="firstname" value="<?php echo e($user->firstname); ?>" required>
                    </div>
                    <div class="space-y-2">
                        <label
                            class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Last Name'); ?></label>
                        <input type="text"
                            class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-emerald-500 transition-all outline-none"
                            name="lastname" value="<?php echo e($user->lastname); ?>" required>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="space-y-2">
                        <label
                            class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Address'); ?></label>
                        <input type="text"
                            class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-blue-500 transition-all outline-none"
                            name="address" value="<?php echo e(@$user->address); ?>">
                    </div>
                    <div class="space-y-2">
                        <label
                            class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('State'); ?></label>
                        <input type="text"
                            class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-blue-500 transition-all outline-none"
                            name="state" value="<?php echo e(@$user->state); ?>">
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="space-y-2">
                        <label
                            class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Zip Code'); ?></label>
                        <input type="text"
                            class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-emerald-500 transition-all outline-none"
                            name="zip" value="<?php echo e(@$user->zip); ?>">
                    </div>
                    <div class="space-y-2">
                        <label
                            class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('City'); ?></label>
                        <input type="text"
                            class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-emerald-500 transition-all outline-none"
                            name="city" value="<?php echo e(@$user->city); ?>">
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="flex items-center justify-between pt-6 border-t border-gray-200">
                    <div>
                        <p class="text-sm text-gray-600">Last updated: <?php echo e(showDateTime($user->updated_at, 'd M, Y')); ?></p>
                    </div>
                    <button type="submit"
                        class="px-6 py-3 bg-black text-white font-medium rounded-lg hover:bg-gray-800 transition-colors duration-200 flex items-center">
                        <i data-lucide="save" class="w-4 h-4 mr-2"></i>
                        Save Changes
                    </button>
                </div>
            </form>
        </div>

        <br><br>
                <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
                <form method="post"  action="<?php echo e(route('user.change.password')); ?>" class="space-y-8">
                <?php echo csrf_field(); ?>

                
                <div class="space-y-3">
                    <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest flex items-center gap-2">
                        <i data-lucide="key-round" class="w-3 h-3"></i> <?php echo app('translator')->get('Current Password'); ?>
                    </label>
                    <input type="password" name="current_password"
                        class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-rose-500 transition-all outline-none"
                        required autocomplete="current-password" placeholder="••••••••">
                </div>

                
                <div class="space-y-3">
                    <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest flex items-center gap-2">
                        <i data-lucide="lock-keyhole" class="w-3 h-3"></i> <?php echo app('translator')->get('New Password'); ?>
                    </label>
                    <input type="password" name="password"
                        class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-emerald-500 transition-all outline-none <?php if(gs('secure_password')): ?> secure-password <?php endif; ?>"
                        required autocomplete="new-password" placeholder="••••••••">
                </div>

                
                <div class="space-y-3">
                    <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest flex items-center gap-2">
                        <i data-lucide="shield-check" class="w-3 h-3"></i> <?php echo app('translator')->get('Confirm New Password'); ?>
                    </label>
                    <input type="password" name="password_confirmation"
                        class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-emerald-500 transition-all outline-none"
                        required autocomplete="new-password" placeholder="••••••••">
                </div>

                
                <div class="pt-6">
                    <button type="submit"
                        class="px-6 py-3 bg-black text-white font-medium rounded-lg hover:bg-gray-800 transition-colors duration-200 flex items-center">
                        <div
                            class="absolute inset-0 bg-gradient-to-r from-rose-500 to-blue-600 opacity-0 group-hover:opacity-100 transition-opacity">
                        </div>
                        <div class="relative flex items-center justify-center gap-3">
                            <span
                                class="text-[11px] font-black text-white dark:text-slate-900 uppercase tracking-[0.3em] group-hover:text-white transition-colors"><?php echo app('translator')->get('Execute Update'); ?></span>
                            <i data-lucide="zap"
                                class="w-4 h-4 text-rose-500 group-hover:text-white transition-all group-hover:translate-x-1"></i>
                        </div>
                    </button>
                </div>
            </form>
 
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Template::layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/user/profile_setting.blade.php ENDPATH**/ ?>