<?php $__env->startSection('content'); ?>
    <div class="min-h-screen bg-white">
        <!-- Hero Header (revamped) -->
        <header class="relative overflow-hidden bg-gradient-to-br from-black via-gray-900 to-black text-white">
            <svg class="absolute inset-0 opacity-[0.06] z-0 pointer-events-none" xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="none" aria-hidden="true" focusable="false">
                <defs>
                    <pattern id="grid" width="40" height="40" patternUnits="userSpaceOnUse">
                        <path d="M 40 0 L 0 0 0 40" fill="none" stroke="white" stroke-width="1" />
                    </pattern>
                </defs>
                <rect width="100%" height="100%" fill="url(#grid)" />
            </svg>

            <div class="absolute inset-0 z-0 pointer-events-none" aria-hidden="true">
                <img src="<?php echo e(asset('assets/frontend/images/tesla-model-y.jpg')); ?>" alt=""
                    class="h-full w-full object-cover opacity-20" loading="eager" decoding="async" />
                <div class="absolute inset-0 bg-gradient-to-b from-black/80 via-black/70 to-black/90"></div>
            </div>

            <div class="relative z-10">
                <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 py-14 lg:py-20 text-center">
                    <h1 class="text-4xl font-semibold tracking-tight sm:text-5xl">Browse Inventory</h1>
                    <p class="mt-4 max-w-3xl mx-auto text-base text-gray-300 sm:text-lg">
                        Explore premium electric vehicles ready for immediate delivery.
                    </p>
                </div>
            </div>

            <div class="absolute bottom-0 left-0 right-0 translate-y-[1px]" aria-hidden="true">
                <svg viewBox="0 0 1440 80" xmlns="http://www.w3.org/2000/svg">
                    <path fill="#ffffff" fill-opacity="1"
                        d="M0,64L48,69.3C96,75,192,85,288,85.3C384,85,480,75,576,53.3C672,32,768,0,864,0C960,0,1056,32,1152,53.3C1248,75,1344,85,1392,90.7L1440,96L1440,160L1392,160C1344,160,1248,160,1152,160C1050,160,960,160,864,160C768,160,672,160,576,160C480,160,384,160,288,160C192,160,96,160,48,160L0,160Z">
                    </path>
                </svg>
            </div>
        </header>

        <!-- Filter and Results Section -->
        <section class="py-12 lg:py-16">
            <div class="max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
                <!-- Mobile Filter Toggle -->
                <div class="lg:hidden mb-6">
                    <button id="mobile-filter-toggle"
                        class="w-full flex items-center justify-between bg-tesla-50 border border-tesla-200 rounded-lg px-4 py-3 text-tesla-900 font-medium">
                        <span class="flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.414A1 1 0 013 6.707V4z" />
                            </svg>
                            Filters & Sort
                        </span>
                        <svg class="w-5 h-5 transform transition-transform duration-200" fill="none"
                            stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                        </svg>
                    </button>
                </div>

                <div class="flex flex-col lg:flex-row gap-8">
                    <!-- Filter Sidebar -->
                    <div class="lg:w-1/4">
                        <div id="filter-sidebar"
                            class="bg-white border border-gray-200 rounded-2xl p-6 shadow lg:sticky lg:top-24 hidden lg:block">
                            <div class="flex items-center justify-between mb-6">
                                <h2 class="text-xl font-medium text-black">Filters</h2>
                                <button id="close-mobile-filters" class="lg:hidden p-2 text-tesla-500 hover:text-tesla-700">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M6 18L18 6M6 6l12 12" />
                                    </svg>
                                </button>
                            </div>

                            <form action="" method="GET" class="space-y-6" id="filter-form">
                                <!-- Quick Filters -->
                                <div>
                                    <h3 class="text-sm font-medium text-gray-700 mb-3">Quick Filters</h3>
                                    <div class="space-y-2">
                                        <label class="flex items-center group cursor-pointer">
                                            <input type="checkbox" name="available" value="true"
                                                class="w-4 h-4 text-black border-gray-300 rounded focus:ring-black focus:ring-2">
                                            <span
                                                class="ml-3 text-sm text-gray-600 group-hover:text-black transition-colors duration-200">Available
                                                Only</span>
                                        </label>
                                        <label class="flex items-center group cursor-pointer">
                                            <input type="checkbox" name="featured" value="true"
                                                class="w-4 h-4 text-black border-gray-300 rounded focus:ring-black focus:ring-2">
                                            <span
                                                class="ml-3 text-sm text-gray-600 group-hover:text-black transition-colors duration-200">Featured
                                                Vehicles</span>
                                        </label>
                                    </div>
                                </div>

                                <!-- Make Filter -->
                                <div>
                                    <h3 class="text-sm font-medium text-gray-700 mb-3">Make</h3>
                                    <select name="make"
                                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-black transition-colors duration-200">
                                        <option value="">All Makes</option>
                                        <option value="Tesla" selected>
                                            Tesla
                                        </option>
                                    </select>
                                </div>

                                <!-- Model Filter -->
                                <div>
                                    <h3 class="text-sm font-medium text-gray-700 mb-3">Model</h3>
                                    <select name="model"
                                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-black transition-colors duration-200">
                                        <option value="">All Models</option>
                                        <option value="Model 3">
                                            Model 3
                                        </option>
                                        <option value="Model X">
                                            Model X
                                        </option>
                                        <option value="Model Y">
                                            Model Y
                                        </option>
                                    </select>
                                </div>

                                <!-- Year Filter -->
                                <div>
                                    <h3 class="text-sm font-medium text-gray-700 mb-3">Year</h3>
                                    <select name="year"
                                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-black transition-colors duration-200">
                                        <option value="">All Years</option>
                                        <option value="2024">
                                            2024
                                        </option>
                                        <option value="2023">
                                            2023
                                        </option>
                                        <option value="2021">
                                            2021
                                        </option>
                                    </select>
                                </div>

                                <!-- Price Range Filter -->
                                <div>
                                    <h3 class="text-sm font-medium text-gray-700 mb-3">Price Range</h3>
                                    <select name="price_range"
                                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-black transition-colors duration-200">
                                        <option value="">All Prices</option>
                                        <option value="0-50000">Under $50,000</option>
                                        <option value="50000-75000">$50,000 - $75,000</option>
                                        <option value="75000-100000">$75,000 - $100,000</option>
                                        <option value="100000-150000">$100,000 - $150,000</option>
                                        <option value="150000+">$150,000+</option>
                                    </select>
                                </div>

                                <!-- Sort Filter -->
                                <div>
                                    <h3 class="text-sm font-medium text-gray-700 mb-3">Sort By</h3>
                                    <select name="sort"
                                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-black transition-colors duration-200">
                                        <option value="newest" selected>Newest First</option>
                                        <option value="oldest">Oldest First</option>
                                        <option value="price_low">Price: Low to High</option>
                                        <option value="price_high">Price: High to Low</option>
                                    </select>
                                </div>

                                <!-- Action Buttons -->
                                <div class="flex flex-col space-y-3 pt-6 border-t border-tesla-200">
                                    <button type="submit"
                                        class="w-full bg-black hover:bg-gray-800 text-white py-3 px-4 rounded-lg font-medium transition-all duration-200">
                                        Apply Filters
                                    </button>
                                    <a href="<?php echo e(route('cars')); ?>"
                                        class="w-full border border-gray-300 text-gray-700 hover:bg-gray-50 py-3 px-4 rounded-lg font-medium text-center transition-all duration-200">
                                        Reset All
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Results Section -->
                    <div class="lg:w-3/4">
                        <!-- Results Header -->
                        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-8">
                            <div>
                                <h2 class="text-2xl font-medium text-tesla-900 mb-2">Available Vehicles</h2>
                                <p class="text-tesla-600">
                                    Showing <?php echo e(count($cars)); ?> vehicles
                                </p>
                            </div>

                            <!-- View Toggle -->
                            <div class="flex items-center space-x-2 mt-4 sm:mt-0">
                                <span class="text-sm text-tesla-600">View:</span>
                                <button id="grid-view"
                                    class="p-2 text-tesla-500 hover:text-tesla-900 hover:bg-tesla-100 rounded-lg transition-colors duration-200 view-toggle active">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z" />
                                    </svg>
                                </button>
                                <button id="list-view"
                                    class="p-2 text-tesla-500 hover:text-tesla-900 hover:bg-tesla-100 rounded-lg transition-colors duration-200 view-toggle">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M4 6h16M4 10h16M4 14h16M4 18h16" />
                                    </svg>
                                </button>
                            </div>
                        </div>

                        <!-- Cars Grid (revamped cards) -->
                        <div id="cars-container" class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-6 lg:gap-8">
                            <?php $__currentLoopData = $cars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $car): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <article
                                class="group rounded-xl border border-gray-200 bg-white shadow-sm transition hover:shadow-md focus-within:ring-2 focus-within:ring-black/40">
                                <a href="<?php echo e(route('car.details',$car->id)); ?>" class="block overflow-hidden rounded-t-xl">
                                    <div class="relative aspect-[16/9]">
                                        <img src="<?php echo e(getImage(getFilePath('inventory').'/'.$car->image)); ?>"
                                            alt="Tesla Model Y"
                                            class="h-full w-full object-cover transition-transform duration-500 group-hover:scale-105"
                                            loading="lazy" decoding="async" />
                                        <?php if($car->soldout == 1): ?>
                                        <div
                                            class="absolute right-3 top-3 rounded-full bg-red-600 px-2.5 py-1 text-[11px] font-medium text-white">
                                            Sold Out</div>
                                        <?php endif; ?>
                                    </div>
                                </a>

                                <div class="p-4">
                                    <h3 class="mb-1 text-base font-medium text-black group-hover:text-black/80 sm:text-lg">
                                        <a href="<?php echo e(route('car.details',$car->id)); ?>"
                                            class="focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-black/40">
                                           <?php echo e($car->name); ?>

                                        </a>
                                    </h3>
                                    <p class="text-sm text-gray-600"><?php echo e($car->year); ?> <?php echo e($car->name); ?></p>

                                    <div class="mt-3 mb-3 flex items-center gap-6 text-xs text-gray-600">
                                        <div>
                                            <span class="font-medium"><?php echo e($car->range); ?></span>
                                            <span class="block text-[10px]">Range</span>
                                        </div>
                                        <div>
                                            <span class="font-medium"><?php echo e($car->mph); ?></span>
                                            <span class="block text-[10px]">Mph</span>
                                        </div>
                                        <div>
                                            <span class="font-medium"><?php echo e($car->topspeed); ?></span>
                                            <span class="block text-[10px]">Top Speed</span>
                                        </div>
                                    </div>

                                    <div class="flex items-center justify-between">
                                        <div>
                                            <p class="text-sm font-medium text-black">Starting at <?php echo e(showAmount($car->lease)); ?>*</p>
                                            <p class="text-xs text-gray-500">After Est. Gas Savings</p>
                                        </div>
                                        <div class="flex items-center gap-2">
                                            
                                            <a href="<?php echo e(route('car.details',$car->id)); ?>"
                                                class="rounded border border-gray-300 px-3 py-1.5 text-xs font-medium text-black transition hover:bg-gray-50 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-black/40">Learn</a>
                                            <?php if($car->soldout != 1): ?>
                                                  <a href="<?php echo e(route('car.details',$car->id)); ?>" class="rounded bg-black px-3 py-1.5 text-xs font-medium text-white transition hover:bg-gray-800 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-black/40">Order</a>
                                            
                                                <?php endif; ?>
                                                 
                                        </div>
                                    </div>
                                </div>
                            </article>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                             
                        </div>

                        <!-- Pagination -->
                        <div class="mt-12 flex justify-center">
                            <div class="bg-white border border-tesla-200 rounded-lg p-2">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Mobile filter toggle
            const mobileFilterToggle = document.getElementById('mobile-filter-toggle');
            const filterSidebar = document.getElementById('filter-sidebar');
            const closeMobileFilters = document.getElementById('close-mobile-filters');

            if (mobileFilterToggle && filterSidebar) {
                mobileFilterToggle.addEventListener('click', function() {
                    filterSidebar.classList.toggle('hidden');
                    const icon = this.querySelector('svg:last-child');
                    icon.classList.toggle('rotate-180');
                });
            }

            if (closeMobileFilters) {
                closeMobileFilters.addEventListener('click', function() {
                    filterSidebar.classList.add('hidden');
                    const icon = mobileFilterToggle.querySelector('svg:last-child');
                    icon.classList.remove('rotate-180');
                });
            }

            // View toggle functionality
            const gridView = document.getElementById('grid-view');
            const listView = document.getElementById('list-view');
            const carsContainer = document.getElementById('cars-container');
            const viewToggles = document.querySelectorAll('.view-toggle');

            function setActiveView(activeButton) {
                viewToggles.forEach(btn => {
                    btn.classList.remove('active', 'text-tesla-blue', 'bg-tesla-100');
                    btn.classList.add('text-tesla-500');
                });
                activeButton.classList.add('active', 'text-tesla-blue', 'bg-tesla-100');
                activeButton.classList.remove('text-tesla-500');
            }

            if (gridView && listView && carsContainer) {
                gridView.addEventListener('click', function() {
                    carsContainer.className =
                        'grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-6 lg:gap-8';
                    setActiveView(this);
                    localStorage.setItem('vehicleView', 'grid');
                });

                listView.addEventListener('click', function() {
                    carsContainer.className = 'space-y-6';
                    setActiveView(this);
                    localStorage.setItem('vehicleView', 'list');

                    // Update card layout for list view
                    const cards = carsContainer.querySelectorAll('.group');
                    cards.forEach(card => {
                        card.classList.add('flex', 'flex-col', 'sm:flex-row');
                        const img = card.querySelector('div:first-child');
                        const content = card.querySelector('.p-6');
                        if (img && content) {
                            img.classList.add('sm:w-1/3');
                            content.classList.add('sm:w-2/3');
                        }
                    });
                });

                // Restore saved view preference
                const savedView = localStorage.getItem('vehicleView');
                if (savedView === 'list') {
                    listView.click();
                }
            }

            // Auto-submit form on filter change
            const filterForm = document.getElementById('filter-form');
            const filterInputs = filterForm.querySelectorAll('select, input[type="checkbox"]');

            filterInputs.forEach(input => {
                input.addEventListener('change', function() {
                    // Add a small delay to allow for multiple quick changes
                    clearTimeout(window.filterTimeout);
                    window.filterTimeout = setTimeout(() => {
                        filterForm.submit();
                    }, 300);
                });
            });

            // Smooth scroll to results after filter
            if (window.location.search) {
                setTimeout(() => {
                    document.querySelector('#cars-container')?.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }, 100);
            }

            // Intersection Observer for card animations
            const observerOptions = {
                threshold: 0.1,
                rootMargin: '0px 0px -50px 0px'
            };

            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('animate-fade-in');
                    }
                });
            }, observerOptions);

            // Observe all car cards
            document.querySelectorAll('.group').forEach(card => {
                observer.observe(card);
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Template::layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/cars/index.blade.php ENDPATH**/ ?>