<?php $__env->startSection('content'); ?>
    <?php
        // Detect the highest ROI plan to apply the Premium UI
        $maxInterest = $plans->max('interest');
    ?>
    <?php $__env->startPush('breadcrumb_text'); ?>
        <div class="flex items-center gap-5">
            <div class="relative group">
                <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-2xl blur opacity-25"></div>
                <div class="relative w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white border border-white/10 shadow-2xl">
                    <i data-lucide="bar-chart-2" class="w-7 h-7 text-emerald-400"></i>
                </div>
            </div>
            <div>
                <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase"><?php echo app('translator')->get('Trade Plans'); ?></h2>
                <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-1"><?php echo app('translator')->get('All investment plans'); ?></p>
            </div>
        </div>
        <?php $__env->stopPush(); ?>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-10 py-12 px-4 max-w-7xl mx-auto">
        <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php $isPremium = ($data->interest == $maxInterest); ?>

            <?php if($isPremium): ?>
                <div
                    class="relative group px-8 py-10 bg-slate-900 dark:bg-emerald-600 rounded-[3.5rem] transition-all duration-500 hover:-translate-y-4 shadow-2xl shadow-emerald-900/20">
                    <div
                        class="absolute -top-5 left-1/2 -translate-x-1/2 bg-white text-slate-900 text-[10px] px-6 py-2 rounded-full font-black uppercase tracking-widest shadow-xl z-20">
                        <?php echo app('translator')->get('Best ROI'); ?>
                    </div>

                    <div class="text-center mb-8 relative z-10">
                        <div
                            class="w-16 h-16 rounded-[1.5rem] bg-white/10 backdrop-blur-md flex items-center justify-center mx-auto mb-6 border border-white/20">
                            <i data-lucide="crown" class="w-8 h-8 text-white"></i>
                        </div>
                        <h3 class="text-xl font-black text-white uppercase tracking-tight"><?php echo e(__($data->name)); ?></h3>
                        <p class="text-[10px] font-black text-white/60 uppercase tracking-[0.3em] mt-1"><?php echo app('translator')->get('Institutional Grade'); ?></p>
                    </div>

                    <div class="text-center mb-10 relative z-10">
                        <span
                            class="text-5xl font-black text-white tracking-tighter"><?php echo e(showAmount($data->interest, currencyFormat: false)); ?><?php echo e($data->interest_type == 1 ? '%' : ' ' . __(gs('cur_text'))); ?></span>
                        <span
                            class="text-xs font-bold text-white/60 uppercase ml-1">/<?php echo e(__($data->timeSetting->name)); ?></span>
                    </div>

                    <div class="space-y-4 mb-10 px-2 relative z-10">
                        <div class="flex items-center gap-4 text-sm font-bold text-white">
                            <div class="w-5 h-5 rounded-full bg-white/20 flex items-center justify-center">
                                <i data-lucide="check" class="w-3 h-3 text-white"></i>
                            </div>
                            <span>
                                <?php if($data->lifetime == 0): ?>
                                    <?php echo e(__($data->repeat_time)); ?> <?php echo e(__($data->timeSetting->name)); ?>

                                <?php else: ?>
                                    <?php echo app('translator')->get('Lifetime'); ?>
                                <?php endif; ?>
                            </span>
                        </div>
                        <div class="flex items-center gap-4 text-sm font-bold text-white">
                            <div class="w-5 h-5 rounded-full bg-white/20 flex items-center justify-center">
                                <i data-lucide="check" class="w-3 h-3 text-white"></i>
                            </div>
                            <span>
                                <?php if($data->fixed_amount == 0): ?>
                                    <?php echo e(showAmount($data->minimum)); ?> - <?php echo e(showAmount($data->maximum)); ?>

                                <?php else: ?>
                                    <?php echo e(showAmount($data->fixed_amount)); ?>

                                <?php endif; ?>
                            </span>
                        </div>
                        <?php if($data->compound_interest): ?>
                            <div class="flex items-center gap-4 text-sm font-bold text-white">
                                <div class="w-5 h-5 rounded-full bg-white/20 flex items-center justify-center">
                                    <i data-lucide="check" class="w-3 h-3 text-white"></i>
                                </div>
                                <span><?php echo app('translator')->get('Compound interest'); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>

                    <button data-plan="<?php echo e($data); ?>"
                        class="investModal w-full py-5 bg-white text-slate-900 rounded-[2rem] text-[10px] font-black uppercase tracking-[0.2em] hover:scale-105 transition-all duration-300 shadow-xl">
                        <?php echo app('translator')->get('Initialize Asset'); ?>
                    </button>
                </div>
            <?php else: ?>
                <div
                    class="glass-vault group px-8 py-10 border border-white/20 dark:border-white/5 bg-white/40 dark:bg-slate-900/40 backdrop-blur-2xl rounded-[3.5rem] transition-all duration-500 hover:-translate-y-2">
                    <div class="text-center mb-8">
                        <div
                            class="w-16 h-16 rounded-[1.5rem] bg-slate-100 dark:bg-white/5 flex items-center justify-center mx-auto mb-6 border border-slate-200 dark:border-white/10">
                            <i data-lucide="zap" class="w-8 h-8 text-slate-400"></i>
                        </div>
                        <h3 class="text-xl font-black text-slate-900 dark:text-white uppercase tracking-tight">
                            <?php echo e(__($data->name)); ?></h3>
                        <p class="text-[10px] font-black text-slate-400 uppercase tracking-[0.3em] mt-1"><?php echo app('translator')->get('Standard Grade'); ?>
                        </p>
                    </div>

                    <div class="text-center mb-10">
                        <span
                            class="text-5xl font-black text-slate-900 dark:text-white tracking-tighter"><?php echo e(showAmount($data->interest, currencyFormat: false)); ?><?php echo e($data->interest_type == 1 ? '%' : ' ' . __(gs('cur_text'))); ?></span>
                        <span
                            class="text-xs font-bold text-slate-400 uppercase ml-1">/<?php echo e(__($data->timeSetting->name)); ?></span>
                    </div>

                    <div class="space-y-4 mb-10 px-2">
                        <div class="flex items-center gap-4 text-sm font-medium text-slate-600 dark:text-slate-400">
                            <div class="w-5 h-5 rounded-full bg-slate-100 dark:bg-white/5 flex items-center justify-center">
                                <i data-lucide="check" class="w-3 h-3 text-slate-400"></i>
                            </div>
                            <span>
                                <?php if($data->lifetime == 0): ?>
                                    <?php echo e(__($data->repeat_time)); ?> <?php echo e(__($data->timeSetting->name)); ?>

                                <?php else: ?>
                                    <?php echo app('translator')->get('Lifetime'); ?>
                                <?php endif; ?>
                            </span>
                        </div>
                        <div class="flex items-center gap-4 text-sm font-medium text-slate-600 dark:text-slate-400">
                            <div class="w-5 h-5 rounded-full bg-slate-100 dark:bg-white/5 flex items-center justify-center">
                                <i data-lucide="check" class="w-3 h-3 text-slate-400"></i>
                            </div>
                            <span>
                                <?php if($data->fixed_amount == 0): ?>
                                    <?php echo e(showAmount($data->minimum)); ?> - <?php echo e(showAmount($data->maximum)); ?>

                                <?php else: ?>
                                    <?php echo e(showAmount($data->fixed_amount)); ?>

                                <?php endif; ?>
                            </span>
                        </div>
                        <?php if($data->compound_interest): ?>
                            <div class="flex items-center gap-4 text-sm font-medium text-slate-600 dark:text-slate-400">
                                <div
                                    class="w-5 h-5 rounded-full bg-slate-100 dark:bg-white/5 flex items-center justify-center">
                                    <i data-lucide="check" class="w-3 h-3 text-slate-400"></i>
                                </div>
                                <span><?php echo app('translator')->get('Compound interest'); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>

                    <button data-plan="<?php echo e($data); ?>"
                        class="investModal w-full py-5 border-2 border-slate-900 dark:border-white/10 text-slate-900 dark:text-white rounded-[2rem] text-[10px] font-black uppercase tracking-[0.2em] hover:bg-slate-900 hover:text-white dark:hover:bg-white dark:hover:text-slate-900 transition-all duration-300">
                        <?php echo app('translator')->get('Get Started'); ?>
                    </button>
                </div>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div id="investModal" class="hidden fixed inset-0 z-[9999] flex items-center justify-center p-4">
        <div class="absolute inset-0 bg-slate-900/60 backdrop-blur-md opacity-0 transition-opacity duration-300"
            id="modalBackdrop"></div>
        <div class="relative w-full max-w-2xl bg-white dark:bg-slate-900 rounded-[3rem] border border-white/20 shadow-2xl overflow-hidden transform scale-95 opacity-0 transition-all duration-300"
            id="modalContent">
            <form action="<?php echo e(route('user.invest.submit')); ?>" method="post" class="m-0">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="plan_id">
                <div
                    class="p-8 border-b border-slate-100 dark:border-white/5 flex justify-between items-center bg-slate-50/50 dark:bg-slate-800/30">
                    <div class="flex items-center gap-4">
                        <div
                            class="w-12 h-12 bg-emerald-500 rounded-2xl flex items-center justify-center text-white shadow-lg shadow-emerald-500/30">
                            <i data-lucide="rocket" class="w-6 h-6"></i>
                        </div>
                        <div>
                            <h2 class="text-lg font-black text-slate-900 dark:text-white uppercase tracking-tighter">
                                <?php echo app('translator')->get('Asset Deployment'); ?></h2>
                            <p class="text-[10px] font-bold text-emerald-500 uppercase tracking-widest planName">PLAN</p>
                        </div>
                    </div>
                    <button type="button"
                        class="closeModal p-2 rounded-full hover:bg-slate-200 dark:hover:bg-white/10 transition-colors">
                        <i data-lucide="x" class="w-6 h-6"></i>
                    </button>
                </div>
                <div class="p-8 modal-scroll max-h-[70vh] overflow-y-auto">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-8">
                        <div
                            class="p-5 rounded-3xl border border-slate-100 dark:border-white/5 bg-slate-50 dark:bg-white/5">
                            <p class="text-[9px] font-black text-slate-400 uppercase mb-1">Staking Range</p>
                            <p class="text-xs font-black text-slate-900 dark:text-white investAmountRange"></p>
                        </div>
                        <div class="p-5 rounded-3xl border border-emerald-500/20 bg-emerald-500/5">
                            <p class="text-[9px] font-black text-emerald-500 uppercase mb-1">Expected Interest</p>
                            <p class="text-xs font-black text-emerald-600 calculatedInterest"></p>
                        </div>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="space-y-2">
                            <label class="text-[10px] font-black text-slate-400 uppercase ml-2">Funding Source</label>
                            <select name="wallet_type"
                                class="w-full bg-slate-50 dark:bg-slate-800 border-none rounded-2xl p-4 text-sm font-bold focus:ring-2 focus:ring-emerald-500 transition-all"
                                required>
                                <option value=""><?php echo app('translator')->get('Select Source'); ?></option>
                                <?php if(auth()->check()): ?>
                                    <option value="deposit_wallet"><?php echo app('translator')->get('Deposit'); ?>
                                        (<?php echo e(showAmount(auth()->user()->deposit_wallet)); ?>)</option>
                                    <option value="interest_wallet"><?php echo app('translator')->get('Interest'); ?>
                                        (<?php echo e(showAmount(auth()->user()->interest_wallet)); ?>)</option>
                                <?php endif; ?>
                                <?php $__currentLoopData = $gatewayCurrency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($data->id); ?>" data-gateway="<?php echo e($data); ?>">
                                        <?php echo e($data->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <?php if(gs('schedule_invest')): ?>
                        <div class="space-y-2 investTime">
                            <label class="text-[10px] font-black text-slate-400 uppercase ml-2"><?php echo app('translator')->get('Investment Timing'); ?></label>
                            <select
                                class="w-full bg-slate-50 dark:bg-slate-800 border-none rounded-2xl p-4 text-sm font-bold focus:ring-2 focus:ring-emerald-500 transition-all"
                                name="invest_time">
                                <option value="invest_now"><?php echo app('translator')->get('Invest Now'); ?></option>
                                <option value="schedule"><?php echo app('translator')->get('Schedule'); ?></option>
                            </select>
                        </div> 

                        <div class="space-y-2 schedule" style="display: none;">
                            <label class="text-[10px] font-black text-slate-400 uppercase ml-2"><?php echo app('translator')->get('Schedule For (Times)'); ?></label>
                            <div class="relative">
                                <input type="number" name="schedule_times"
                                    class="w-full bg-slate-50 dark:bg-slate-800 border-none rounded-2xl p-4 text-sm font-bold focus:ring-2 focus:ring-emerald-500 transition-all">
                                <span class="absolute right-4 top-1/2 -translate-y-1/2 text-xs font-black text-slate-400"><?php echo app('translator')->get('Times'); ?></span>
                            </div>
                        </div>

                        <div class="space-y-2 schedule" style="display: none;">
                            <label class="text-[10px] font-black text-slate-400 uppercase ml-2"><?php echo app('translator')->get('Interval (Hours)'); ?></label>
                            <div class="relative">
                                <input type="number" name="hours" min="0"
                                    class="w-full bg-slate-50 dark:bg-slate-800 border-none rounded-2xl p-4 text-sm font-bold focus:ring-2 focus:ring-emerald-500 transition-all">
                                <span class="absolute right-4 top-1/2 -translate-y-1/2 text-xs font-black text-slate-400"><?php echo app('translator')->get('Hours'); ?></span>
                            </div>
                        </div>
                    <?php endif; ?>
                    </div>

                    <div class="space-y-2">
                        <label class="text-[10px] font-black text-slate-400 uppercase ml-2">Investment Amount</label>
                        <div class="relative">
                            <input type="number" step="any" name="amount"
                                class="w-full bg-slate-50 dark:bg-slate-800 border-none rounded-2xl p-4 text-sm font-bold focus:ring-2 focus:ring-emerald-500 transition-all"
                                required>
                            <span
                                class="absolute right-4 top-1/2 -translate-y-1/2 text-xs font-black text-slate-400"><?php echo e(gs('cur_text')); ?></span>
                        </div>
                    </div>
                </div>
                <div class="p-8 bg-slate-50/50 dark:bg-slate-800/30 flex gap-4">
                    <button type="button"
                        class="closeModal flex-1 py-4 text-[10px] font-black uppercase text-slate-400 hover:text-slate-900"><?php echo app('translator')->get('Abort'); ?></button>
                    <button type="submit"
                        class="flex-[2] py-4 bg-emerald-600 text-white rounded-2xl text-[10px] font-black uppercase tracking-widest shadow-lg"><?php echo app('translator')->get('Confirm'); ?></button>
                </div>
            </form>
        </div>
    </div>

    <script src="https://unpkg.com/lucide@latest"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            lucide.createIcons();
            const modal = document.getElementById('investModal');
            const backdrop = document.getElementById('modalBackdrop');
            const content = document.getElementById('modalContent');
            const openBtns = document.querySelectorAll('.investModal');
            const closeBtns = document.querySelectorAll('.closeModal');

            openBtns.forEach(btn => {
                btn.addEventListener('click', function() {
                    const plan = JSON.parse(this.getAttribute('data-plan'));
                    modal.querySelector('[name=plan_id]').value = plan.id;
                    modal.querySelector('.planName').innerText = plan.name;

                    let range = plan.fixed_amount == 0 ?
                        `${parseFloat(plan.minimum).toFixed(2)} - ${parseFloat(plan.maximum).toFixed(2)}` :
                        `${parseFloat(plan.fixed_amount).toFixed(2)} (Fixed)`;

                    modal.querySelector('.investAmountRange').innerText = range +
                        " <?php echo e(gs('cur_text')); ?>";
                    modal.querySelector('.calculatedInterest').innerText = plan.interest + (plan
                        .interest_type == 1 ? '%' : " <?php echo e(gs('cur_text')); ?>");

                    modal.classList.remove('hidden');
                    setTimeout(() => {
                        backdrop.classList.replace('opacity-0', 'opacity-100');
                        content.classList.replace('opacity-0', 'opacity-100');
                        content.classList.replace('scale-95', 'scale-100');
                    }, 10);
                });
            });

            const investTimeSelect = document.querySelector('select[name="invest_time"]');
            const scheduleFields = document.querySelectorAll('.schedule');

            if (investTimeSelect) {
                investTimeSelect.addEventListener('change', function() {
                    if (this.value === 'schedule') {
                        // Show fields
                        scheduleFields.forEach(el => {
                            el.style.display = 'block';
                            // Optional: Make inputs required when visible
                            el.querySelector('input').setAttribute('required', 'required');
                        });
                    } else {
                        // Hide fields
                        scheduleFields.forEach(el => {
                            el.style.display = 'none';
                            // Optional: Remove required attribute when hidden
                            el.querySelector('input').removeAttribute('required');
                        });
                    }
                });
            }

            function closeModal() {
                backdrop.classList.replace('opacity-100', 'opacity-0');
                content.classList.replace('opacity-100', 'opacity-0');
                content.classList.replace('scale-100', 'scale-95');
                setTimeout(() => modal.classList.add('hidden'), 300);
                if(investTimeSelect) {
                    investTimeSelect.value = 'invest_now';
                    scheduleFields.forEach(el => el.style.display = 'none');
                }
            }
            closeBtns.forEach(btn => btn.addEventListener('click', closeModal));
        });
    </script>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/plan.blade.php ENDPATH**/ ?>