<?php $__env->startSection('content'); ?>
<?php $plan = $invest->plan; ?>
<div class="px-4 mx-auto">
    
    <div class="flex flex-col md:flex-row md:items-center justify-between gap-4 mb-8">
        <?php $__env->startPush('breadcrumb_text'); ?>
        <div class="flex items-center gap-4">
            <div class="w-10 h-10 bg-slate-900 dark:bg-white rounded-xl flex items-center justify-center text-white dark:text-slate-900 shadow-xl ring-4 ring-slate-50 dark:ring-white/5">
                <i data-lucide="activity" class="w-5 h-5"></i>
            </div>
            <div>
                <p class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em] mb-0.5"><?php echo app('translator')->get('Node Connection'); ?></p>
                <div class="flex items-center gap-2">
                    <?php if($invest->status == 1): ?>
                        <span class="relative flex h-2 w-2">
                          <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-emerald-400 opacity-75"></span>
                          <span class="relative inline-flex rounded-full h-2 w-2 bg-emerald-500"></span>
                        </span>
                        <span class="text-[11px] font-black text-emerald-500 uppercase"><?php echo app('translator')->get('Active Deployment'); ?></span>
                    <?php elseif($invest->status == 2): ?>
                        <span class="text-[11px] font-black text-rose-500 uppercase"><?php echo app('translator')->get('Terminated'); ?></span>
                    <?php else: ?>
                        <span class="text-[11px] font-black text-blue-500 uppercase"><?php echo app('translator')->get('Matured / Completed'); ?></span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php $__env->stopPush(); ?>

        <?php $__env->startPush('breadcrumb'); ?>
        <?php if($invest->eligibleCapitalBack()): ?>
            <button class="openCapitalModal group px-6 py-3 rounded-xl bg-slate-900 dark:bg-white text-white dark:text-slate-900 text-[10px] font-black uppercase tracking-widest shadow-xl hover:bg-emerald-600 dark:hover:bg-emerald-500 dark:hover:text-white transition-all duration-300">
                <span class="flex items-center gap-2">
                    <?php echo app('translator')->get('Manage Capital'); ?>
                    <i data-lucide="settings-2" class="w-3.5 h-3.5 group-hover:rotate-90 transition-transform"></i>
                </span>
            </button>
        <?php endif; ?>
        <?php $__env->stopPush(); ?>
    </div>

    <div class="grid grid-cols-12 gap-6 mb-12">
        
        
         

        <div class="col-span-12 lg:col-span-6 relative group">
            <div class="absolute -inset-0.5 bg-gradient-to-b from-blue-500/30 to-transparent rounded-[2.5rem] blur-sm"></div>
            <div class="relative h-full bg-slate-900 dark:bg-[#0b1121] border border-white/10 rounded-[2.5rem] p-10 shadow-2xl overflow-hidden">
                <div class="absolute -bottom-24 -right-24 w-64 h-64 bg-blue-500/20 rounded-full blur-[80px]"></div>

                <div class="flex flex-col h-full relative z-10">
                    <div class="mb-10 flex items-center justify-between">
                        <span class="text-[10px] font-black text-slate-500 uppercase tracking-[0.3em]"><?php echo app('translator')->get('Investment'); ?> <b>(<?php echo e(__($plan->name)); ?>)</b></span>
                        <div class="w-8 h-8 rounded-lg bg-white/5 flex items-center justify-center">
                            <i data-lucide="wallet" class="w-4 h-4 text-blue-400"></i> 
                        </div>
                    </div>

                    <h3 class="text-5xl font-black text-white tracking-tighter mb-2">
                        <?php echo e(showAmount($invest->initial_amount)); ?>

                    </h3>
                    <p class="text-[11px] font-black text-blue-400 uppercase tracking-widest"><?php echo app('translator')->get('ROI'); ?> @ <?php echo e(showAmount($plan->interest, false)); ?><?php echo e($plan->interest_type == 1 ? '%' : gs('cur_text')); ?> <?php echo e($invest->time_name); ?></p>

                    <div class="mt-auto pt-8 border-t border-white/5">
                        <div class="flex flex-col">
                            <span class="text-[9px] font-black text-slate-500 uppercase tracking-widest mb-1"><?php echo app('translator')->get('Date Invested'); ?></span>
                            <span class="text-lg font-bold text-white tracking-tight"><?php echo e(showDateTime($invest->created_at, 'M d, H:i')); ?></span>
                            <span class="text-[10px] font-medium text-slate-400 mt-1">Total Interest: <?php echo e(showAmount($invest->net_interest)); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-span-12 lg:col-span-6 relative group">
            <div class="absolute -inset-0.5 bg-gradient-to-b from-blue-500/30 to-transparent rounded-[2.5rem] blur-sm"></div>
            <div class="relative h-full bg-slate-900 dark:bg-[#0b1121] border border-white/10 rounded-[2.5rem] p-10 shadow-2xl overflow-hidden">
                <div class="absolute -bottom-24 -right-24 w-64 h-64 bg-blue-500/20 rounded-full blur-[80px]"></div>

                <div class="flex flex-col h-full relative z-10">
                    <div class="mb-10 flex items-center justify-between">
                        <span class="text-[10px] font-black text-slate-500 uppercase tracking-[0.3em]"><?php echo app('translator')->get('Net Settlement'); ?></span>
                        <div class="w-8 h-8 rounded-lg bg-white/5 flex items-center justify-center">
                            <i data-lucide="trending-up" class="w-4 h-4 text-blue-400"></i>
                        </div>
                    </div>

                    <h3 class="text-5xl font-black text-white tracking-tighter mb-2">
                        <?php echo e(showAmount($invest->paid)); ?>

                    </h3>
                    <p class="text-[11px] font-black text-blue-400 uppercase tracking-widest"><?php echo app('translator')->get('Total Profit Earned'); ?> <b><?php echo e($invest->return_rec_time); ?> / <?php echo e($invest->period > 0 ? $invest->period : '∞'); ?></b></p>

                    <div class="mt-auto pt-8 border-t border-white/5">
                        <div class="flex flex-col">
                            <span class="text-[9px] font-black text-slate-500 uppercase tracking-widest mb-1"><?php echo app('translator')->get('Next Payout Window'); ?></span>
                            <span class="text-lg font-bold text-white tracking-tight"><?php echo e(showDateTime($invest->next_time, 'M d, H:i')); ?></span>
                            <span class="text-[10px] font-medium text-slate-400 mt-1">Syncing in <?php echo e(diffForHumans($invest->next_time)); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        
    </div>

    <div class="flex items-center gap-3 mb-6 px-2">
        <div class="h-px flex-1 bg-slate-200 dark:bg-white/5"></div>
        <h4 class="text-[11px] font-black text-slate-400 dark:text-slate-500 uppercase tracking-[0.4em]">
            <?php if($invest->compound_times): ?> <?php echo app('translator')->get('Compound Transaction Log'); ?> <?php else: ?> <?php echo app('translator')->get('Interest Ledger'); ?> <?php endif; ?>
        </h4>
        <div class="h-px flex-1 bg-slate-200 dark:bg-white/5"></div>
    </div>
    
    <div class="border border-slate-200 dark:border-white/10 bg-white/50 dark:bg-slate-900/50 backdrop-blur-xl rounded-xl overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full text-left border-collapse">
                <thead>
                    <tr class="bg-slate-50/50 dark:bg-white/5 border-b border-slate-200 dark:border-white/10">
                        <th class="px-6 py-4 text-[10px] font-black uppercase tracking-widest text-slate-500"><?php echo app('translator')->get('Reference'); ?></th>
                        <th class="px-6 py-4 text-[10px] font-black uppercase tracking-widest text-slate-500"><?php echo app('translator')->get('Execution Date'); ?></th>
                        <th class="px-6 py-4 text-[10px] font-black uppercase tracking-widest text-slate-500"><?php echo app('translator')->get('Amount'); ?></th>
                        <th class="px-6 py-4 text-[10px] font-black uppercase tracking-widest text-slate-500"><?php echo app('translator')->get('Post Balance'); ?></th>
                        <th class="px-6 py-4 text-[10px] font-black uppercase tracking-widest text-slate-500 text-right"><?php echo app('translator')->get('Context'); ?></th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-100 dark:divide-white/5">
                    <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-slate-100/50 dark:hover:bg-white/[0.03] transition-all group">
                            <td class="px-6 py-4 text-[11px] font-mono font-bold text-slate-400 group-hover:text-slate-600 dark:group-hover:text-slate-200 uppercase tracking-tighter"><?php echo e($trx->trx); ?></td>
                            <td class="px-6 py-4">
                                <div class="flex flex-col">
                                    <span class="text-xs font-bold text-slate-700 dark:text-slate-300"><?php echo e(showDateTime($trx->created_at, 'd M, Y H:i')); ?></span>
                                    <span class="text-[9px] text-slate-400 uppercase font-medium"><?php echo e(diffForHumans($trx->created_at)); ?></span>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="inline-flex items-center px-2 py-0.5 rounded text-[11px] font-black <?php echo e($trx->trx_type == '+' ? 'text-emerald-500 bg-emerald-500/10' : 'text-rose-500 bg-rose-500/10'); ?>">
                                    <?php echo e($trx->trx_type); ?><?php echo e(showAmount($trx->amount)); ?>

                                </div>
                            </td>
                            <td class="px-6 py-4 text-xs font-bold text-slate-600 dark:text-slate-400">
                                <?php echo e(showAmount($trx->post_balance)); ?>

                            </td>
                            <td class="px-6 py-4 text-right">
                                <span class="text-[10px] font-bold text-slate-400 dark:text-slate-500 uppercase tracking-tight group-hover:text-slate-900 dark:group-hover:text-white transition-colors">
                                    <?php echo e(__($trx->details)); ?>

                                </span>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="100%" class="px-6 py-20 text-center">
                                <div class="flex flex-col items-center gap-2">
                                    <i data-lucide="ghost" class="w-8 h-8 text-slate-200"></i>
                                    <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('No transaction history available'); ?></p>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <?php if($transactions->hasPages()): ?>
        <div class="mt-8">
            <?php echo e(paginateLinks($transactions)); ?>

        </div>
    <?php endif; ?>
</div>

<div id="capitalModal" class="hidden fixed inset-0 z-[9999] flex items-center justify-center p-4">
    <div class="absolute inset-0 bg-slate-900/80 backdrop-blur-md opacity-0 transition-opacity duration-300" id="capitalBackdrop"></div>
    <div class="relative w-full max-w-sm bg-white dark:bg-slate-900 rounded-2xl border border-slate-200 dark:border-white/10 shadow-2xl overflow-hidden transform scale-95 opacity-0 transition-all duration-300" id="capitalContent">
        <div class="p-6 border-b border-slate-100 dark:border-white/5 flex justify-between items-center bg-slate-50/50 dark:bg-white/5">
            <div class="flex items-center gap-3">
                <i data-lucide="settings" class="w-4 h-4 text-emerald-500"></i>
                <h2 class="text-[11px] font-black text-slate-900 dark:text-white uppercase tracking-widest"><?php echo app('translator')->get('Capital Strategy'); ?></h2>
            </div>
            <button type="button" class="closeCapital p-1 hover:bg-slate-100 dark:hover:bg-white/5 rounded-lg transition-colors">
                <i data-lucide="x" class="w-4 h-4 text-slate-400"></i>
            </button>
        </div>
        <form action="<?php echo e(route('user.invest.capital.manage')); ?>" method="post" class="m-0">
            <?php echo csrf_field(); ?>
            <div class="p-8">
                <input type="hidden" name="invest_id" value="<?php echo e($invest->id); ?>">
                <div class="space-y-4">
                    <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Choose Operation'); ?></label>
                    <div class="relative">
                        <select name="capital" class="appearance-none w-full bg-slate-50 dark:bg-slate-800 border border-slate-200 dark:border-white/5 rounded-xl p-4 text-xs font-black uppercase tracking-tighter focus:ring-2 focus:ring-emerald-500 transition-all outline-none text-slate-900 dark:text-white">
                            <option value="reinvest"><?php echo app('translator')->get('Compound / Reinvest'); ?></option>
                            <option value="capital_back"><?php echo app('translator')->get('Release to Wallet'); ?></option>
                        </select>
                        <div class="absolute right-4 top-1/2 -translate-y-1/2 pointer-events-none">
                            <i data-lucide="chevron-down" class="w-4 h-4 text-slate-400"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="p-6 pt-0 flex flex-col gap-2">
                <button type="submit" class="w-full py-4 bg-slate-900 dark:bg-white text-white dark:text-slate-900 rounded-xl text-[10px] font-black uppercase tracking-[0.2em] shadow-lg hover:bg-emerald-600 dark:hover:bg-emerald-500 dark:hover:text-white transition-all"><?php echo app('translator')->get('Confirm Strategy'); ?></button>
                <button type="button" class="closeCapital w-full py-3 text-[10px] font-bold uppercase text-slate-400 hover:text-slate-600 transition-colors"><?php echo app('translator')->get('Dismiss'); ?></button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/invest_details.blade.php ENDPATH**/ ?>