<?php $__env->startSection('content'); ?>
    <div class="max-w-7xl mx-auto">
        <!-- Enhanced Header -->
        <div
            class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
                <div class="absolute bottom-0 left-0 w-24 h-24 bg-white rounded-full translate-y-12 -translate-x-12"></div>
            </div>

            <div class="relative z-10">
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                    <div class="mb-4 lg:mb-0 lg:flex-1">
                        <h1 class="text-xl font-light mb-1"><?php echo e($stock->symbol); ?></h1>
                        <p class="text-gray-300 text-sm"><?php echo e($stock->symbol); ?> Inc.</p>
                        <p class="text-xs text-gray-400 mt-1"><?php echo e($stock->sector); ?></p>
                    </div>

                    <!-- Enhanced Stats Card -->
                    <div
                        class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-80">
                        <div class="flex items-center justify-between mb-3">
                            <div>
                                <p class="text-xs text-gray-300 mb-1">Current Price</p>
                                <p class="text-lg font-light">$<?php echo e($stock->price); ?></p>
                            </div>
                            <div class="w-10 h-10 flex items-center justify-center">
                                <i data-lucide="bar-chart-3" class="w-5 h-5 text-white"></i>
                            </div>
                        </div>
                        <div class="flex space-x-4 text-xs">
                            <div class="flex-1 text-center">
                                <p class="text-gray-300">Change</p>
                                <?php
                                    $changeColor = 'text-gray-600'; // Default
                                    if (str_starts_with($stock->pct_change, '+')) {
                                        $changeColor = 'text-green-600';
                                    } elseif (str_starts_with($stock->pct_change, '-')) {
                                        $changeColor = 'text-red-600';
                                    }
                                ?>
                                
                                <div class="text-sm <?php echo e($changeColor); ?> font-bold stock-change" data-stock-change="<?php echo e($stock->symbol); ?>">
                                    <?php echo e($stock->pct_change); ?>

                                </div>
                            </div>
                            <div class="flex-1 text-center">
                                <p class="text-gray-300">Volume</p>
                                <p class="text-white font-medium"><?php echo e($stock->volume); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Stock Overview -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
            <!-- Current Price -->
            <div class="bg-white rounded-xl p-4 shadow-sm border border-gray-100">
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Current Price</p>
                        <p class="text-lg font-light text-black"><?php echo e($stock->price); ?></p>
                    </div>
                    <div class="w-8 h-8 flex items-center justify-center">
                        <i data-lucide="dollar-sign" class="w-4 h-4 text-blue-600"></i>
                    </div>
                </div>
            </div>

            <!-- Change -->
            <div class="bg-white rounded-xl p-4 shadow-sm border border-gray-100">
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Change</p>
                        <p class="text-lg font-light <?php echo e($changeColor); ?>">
                            <?php echo e($stock->pct_change); ?>

                        </p>
                        <p class="text-xs <?php echo e($changeColor); ?>">
                            <?php echo e($stock->pe_ratio); ?>%
                        </p>
                    </div>
                    <div class="w-8 h-8 flex items-center justify-center">
                        <i data-lucide="trending-up" class="w-4 h-4 <?php echo e($changeColor); ?>"></i>
                    </div>
                </div>
            </div>

            <!-- Volume -->
            <div class="bg-white rounded-xl p-4 shadow-sm border border-gray-100">
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Volume</p>
                        <p class="text-lg font-light text-black"><?php echo e($stock->volume); ?></p>
                    </div>
                    <div class="w-8 h-8 flex items-center justify-center">
                        <i data-lucide="activity" class="w-4 h-4 text-green-600"></i>
                    </div>
                </div>
            </div>

            <!-- Market Cap -->
            <div class="bg-white rounded-xl p-4 shadow-sm border border-gray-100">
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Market Cap</p>
                        <p class="text-lg font-light text-black"><?php echo e($stock->market_cap); ?></p>
                    </div>
                    <div class="w-8 h-8 flex items-center justify-center">
                        <i data-lucide="pie-chart" class="w-4 h-4 text-purple-600"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Stock Information -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Price Chart -->
                <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
                    <div class="flex items-center justify-between mb-4">
                        <div>
                            <h3 class="text-lg font-light text-black mb-1">Price Chart</h3>
                            <p class="text-xs text-gray-500">Stock performance over time</p>
                        </div>
                        <div class="flex space-x-2">
                            <button data-period="1d"
                                class="px-3 py-1 text-xs font-medium text-gray-600 hover:text-black transition-colors duration-200">1D</button>
                            <button data-period="1w"
                                class="px-3 py-1 text-xs font-medium text-gray-600 hover:text-black transition-colors duration-200">1W</button>
                            <button data-period="1m"
                                class="px-3 py-1 text-xs font-medium text-black bg-gray-100 rounded-lg">1M</button>
                            <button data-period="1y"
                                class="px-3 py-1 text-xs font-medium text-gray-600 hover:text-black transition-colors duration-200">1Y</button>
                        </div>
                    </div>

                    <!-- Stock Chart -->
                    <div class="relative">
                        <canvas id="stockChart" class="w-full h-64"></canvas>
                    </div>
                </div>

                <!-- Stock Details -->
                <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
                    <div class="flex items-center justify-between mb-4">
                        <div>
                            <h3 class="text-lg font-light text-black mb-1">Stock Details</h3>
                            <p class="text-xs text-gray-500">Comprehensive stock information</p>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Key Metrics -->
                        <div class="space-y-4">
                            <h4 class="text-sm font-medium text-black mb-3">Key Metrics</h4>
                            <div class="space-y-3">
                                <div class="flex items-center justify-between">
                                    <span class="text-xs text-gray-600">Previous Close</span>
                                    <span class="text-xs font-medium text-black"></span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="text-xs text-gray-600">P/E Ratio</span>
                                    <span class="text-xs font-medium text-black"><?php echo e($stock->pe_ratio); ?></span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="text-xs text-gray-600">Dividend Yield</span>
                                    <span class="text-xs font-medium text-black"><?php echo e($stock->dividend_yield); ?></span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="text-xs text-gray-600">52 Week High</span>
                                    <span class="text-xs font-medium text-black">$256.35</span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="text-xs text-gray-600">52 Week Low</span>
                                    <span class="text-xs font-medium text-black">$203.35</span>
                                </div>
                            </div>
                        </div>

                        <!-- Company Info -->
                        <div class="space-y-4">
                            <h4 class="text-sm font-medium text-black mb-3">Company Information</h4>
                            <div class="space-y-3">
                                <div class="flex items-center justify-between">
                                    <span class="text-xs text-gray-600">Symbol</span>
                                    <span class="text-xs font-medium text-black"><?php echo e($stock->symbol); ?></span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="text-xs text-gray-600">Company</span>
                                    <span class="text-xs font-medium text-black"><?php echo e($stock->symbol); ?> Inc.</span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="text-xs text-gray-600">Sector</span>
                                    <span class="text-xs font-medium text-black">Technology</span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="text-xs text-gray-600">Industry</span>
                                    <span class="text-xs font-medium text-black"><?php echo e($stock->sector); ?></span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="text-xs text-gray-600">Last Updated</span>
                                    <span class="text-xs font-medium text-black"><?php echo e($stock->updated_at); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Stock News -->
                <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
                    <div class="flex items-center justify-between mb-4">
                        <div>
                            <h3 class="text-lg font-light text-black mb-1">Latest News</h3>
                            <p class="text-xs text-gray-500">Recent headlines for AAPL</p>
                        </div>
                    </div>


                    <p class="text-sm text-gray-500">No recent news found.</p>
                </div>
            </div>

            <!-- Trading Actions -->
            <div class="space-y-6">
                <!-- Trading Actions -->
                <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
                    <div class="flex items-center justify-between mb-4">
                        <div>
                            <h3 class="text-lg font-light text-black mb-1">Trading Actions</h3>
                            <p class="text-xs text-gray-500">Buy or sell this stock</p>
                        </div>
                    </div>

                    <div class="space-y-3">
                        <form action="<?php echo e(route('user.stock.buy')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <input name="stock" value="<?php echo e($stock->id); ?>" hidden>
                        <div class="mb-3">
                                <label for="alert_price" class="block text-xs font-medium text-gray-700 mb-1">Amount
                                    (USD)</label>
                                <input type="number" id="amount" name="amount" step="0.01" min="0.01"
                                    class="w-full px-3 py-2 text-sm border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent"
                                    placeholder="0.00">
                            </div>
                        <button type="submit" href="#"
                            class="w-full flex items-center justify-center px-4 py-3 bg-green-600 text-white text-sm font-medium rounded-lg hover:bg-green-700 transition-colors duration-200">
                            <i data-lucide="plus" class="w-4 h-4 mr-2"></i>
                            Buy <?php echo e($stock->symbol); ?>

                        </button>
                        </form>
                    </div>
                </div>

                <!-- Watchlist Actions -->
                <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
                    <div class="flex items-center justify-between mb-4">
                        <div>
                            <h3 class="text-lg font-light text-black mb-1">Watchlist</h3>
                            <p class="text-xs text-gray-500">Track this stock and set price alerts</p>
                        </div>
                    </div>

                    <div class="space-y-3">
                        <form action="#" method="POST">
                            <input type="hidden" name="_token" value="Pa2Xy5qmTGBbNnaTCAW55cNMoy1w9bYWDJVCdZGP"
                                autocomplete="off">
                            <div class="mb-3">
                                <label for="alert_price" class="block text-xs font-medium text-gray-700 mb-1">Alert Price
                                    (Optional)</label>
                                <input type="number" id="alert_price" name="alert_price" step="0.01" min="0.01"
                                    class="w-full px-3 py-2 text-sm border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent"
                                    placeholder="0.00">
                            </div>
                            <div class="mb-4">
                                <label for="alert_type" class="block text-xs font-medium text-gray-700 mb-1">Alert Type
                                    (Optional)</label>
                                <select id="alert_type" name="alert_type"
                                    class="w-full px-3 py-2 text-sm border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent">
                                    <option value="">No alert</option>
                                    <option value="above">Above this price</option>
                                    <option value="below">Below this price</option>
                                </select>
                            </div>
                            <button type="submit"
                                class="w-full flex items-center justify-center px-4 py-3 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition-colors duration-200">
                                <i data-lucide="eye" class="w-4 h-4 mr-2"></i>
                                Add to Watchlist
                            </button>
                        </form>
                    </div>
                </div>

                <!-- User Holdings -->

                <!-- Recent Activity -->
            </div>
        </div>
    </div>

    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <script>
        // Initialize stock chart
        document.addEventListener('DOMContentLoaded', function() {
            const ctx = document.getElementById('stockChart');
            if (ctx) {
                const stockChart = new Chart(ctx, {
                    type: 'line',
                    data: {
                        labels: [],
                        datasets: [{
                            label: 'AAPL Price',
                            data: [],
                            borderColor: '#000000',
                            backgroundColor: 'rgba(0, 0, 0, 0.1)',
                            borderWidth: 2,
                            fill: true,
                            tension: 0.4,
                            pointRadius: 0,
                            pointHoverRadius: 6,
                            pointHoverBackgroundColor: '#000000',
                            pointHoverBorderColor: '#ffffff',
                            pointHoverBorderWidth: 2
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        interaction: {
                            intersect: false,
                            mode: 'index'
                        },
                        plugins: {
                            legend: {
                                display: false
                            },
                            tooltip: {
                                backgroundColor: 'rgba(0, 0, 0, 0.8)',
                                titleColor: '#ffffff',
                                bodyColor: '#ffffff',
                                borderColor: '#000000',
                                borderWidth: 1,
                                cornerRadius: 8,
                                displayColors: false,
                                callbacks: {
                                    label: function(context) {
                                        return '$' + context.parsed.y.toFixed(2);
                                    }
                                }
                            }
                        },
                        scales: {
                            x: {
                                display: false,
                                grid: {
                                    display: false
                                }
                            },
                            y: {
                                display: true,
                                position: 'right',
                                grid: {
                                    color: 'rgba(0, 0, 0, 0.1)',
                                    drawBorder: false
                                },
                                ticks: {
                                    color: '#6b7280',
                                    font: {
                                        size: 12
                                    },
                                    callback: function(value) {
                                        return '$' + value.toFixed(2);
                                    }
                                }
                            }
                        }
                    }
                });

                // Load initial chart data
                loadChartData('1m');

                // Add period button event listeners
                document.querySelectorAll('[data-period]').forEach(button => {
                    button.addEventListener('click', function() {
                        const period = this.getAttribute('data-period');
                        loadChartData(period);

                        // Update active button
                        document.querySelectorAll('[data-period]').forEach(btn => {
                            btn.classList.remove('bg-black', 'text-white');
                            btn.classList.add('text-gray-600');
                        });
                        this.classList.remove('text-gray-600');
                        this.classList.add('bg-black', 'text-white');
                    });
                });

                function loadChartData(period) {
                    fetch(`/api/stocks/AAPL/chart-data?period=${period}`)
                        .then(response => response.json())
                        .then(data => {
                            if (data.success && data.chartData) {
                                stockChart.data.labels = data.chartData.labels;
                                stockChart.data.datasets[0].data = data.chartData.datasets[0].data;
                                stockChart.update();
                            }
                        })
                        .catch(error => {
                            console.error('Error loading chart data:', error);
                        });
                }
            }
        });

        function editWatchlistAlert(symbol, currentPrice, currentType) {
            // Create a modal for editing watchlist alert
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50';
            modal.innerHTML = `
                <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
                    <div class="mt-3">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Edit Price Alert</h3>
                        <form action="https://www.tesinvspf.com/trading/watchlist/update/1" method="POST">
                            <input type="hidden" name="_token" value="Pa2Xy5qmTGBbNnaTCAW55cNMoy1w9bYWDJVCdZGP">
                            <input type="hidden" name="_method" value="PATCH">
                            <div class="mb-4">
                                <label for="alert_price" class="block text-sm font-medium text-gray-700 mb-2">Alert Price</label>
                                <input type="number" 
                                       id="alert_price" 
                                       name="alert_price" 
                                       value="${currentPrice || ''}"
                                       step="0.01" 
                                       min="0.01"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent"
                                       placeholder="0.00">
                            </div>
                            <div class="mb-6">
                                <label for="alert_type" class="block text-sm font-medium text-gray-700 mb-2">Alert Type</label>
                                <select id="alert_type" 
                                        name="alert_type" 
                                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent">
                                    <option value="">No alert</option>
                                    <option value="above" ${currentType === 'above' ? 'selected' : ''}>Above this price</option>
                                    <option value="below" ${currentType === 'below' ? 'selected' : ''}>Below this price</option>
                                </select>
                            </div>
                            <div class="flex justify-end space-x-3">
                                <button type="button" 
                                        onclick="this.closest('.fixed').remove()"
                                        class="px-4 py-2 text-gray-600 bg-gray-100 rounded-lg hover:bg-gray-200 transition-colors duration-200">
                                    Cancel
                                </button>
                                <button type="submit" 
                                        class="px-4 py-2 bg-black text-white rounded-lg hover:bg-gray-800 transition-colors duration-200">
                                    Update Alert
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            `;
            document.body.appendChild(modal);

            // Close modal when clicking outside
            modal.addEventListener('click', function(e) {
                if (e.target === this) {
                    this.remove();
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Template::layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/user/staking/details.blade.php ENDPATH**/ ?>