  <?php
        $policyPages = getContent('policy_pages.element', false, null, true);
        $registerContent = getContent('register.content', true);
    ?>
     
     <!DOCTYPE html>
<html lang="en" class="h-full bg-slate-50">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> <?php echo e(gs()->siteName(__($pageTitle))); ?></title>
    <?php echo $__env->make('partials.seo', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
        .form-input-focus { @apply border-emerald-500 ring-2 ring-emerald-500/10; }
    </style>
</head>
<body class="h-full antialiased text-slate-900">

<div class="flex min-h-screen">
    <div class="flex flex-1 flex-col justify-center py-12 px-6 lg:flex-none lg:px-20 xl:px-32 bg-white shadow-2xl z-10">
        <div class="mx-auto w-full max-w-sm lg:w-[480px]">
            
            <div class="flex items-center justify-between mb-12">
                <div class="flex items-center gap-2">
                    <img src="<?php echo e(siteLogo()); ?>" width="100" alt="site-logo">
                </div>
                <a href="<?php echo e(route('user.login')); ?>" class="text-sm font-semibold text-emerald-600 hover:text-emerald-700">Sign In instead →</a>
            </div>

            <header class="mb-10">
                <h1 class="text-2xl font-bold text-slate-900 tracking-tight">Open your account</h1>
                <p class="text-slate-500 mt-2">Start your journey toward financial freedom today.</p>
            </header>

            <?php if(session()->get('reference') != null): ?>
                <div class="mb-8 p-4 bg-emerald-50 border border-emerald-100 rounded-xl flex items-center gap-3">
                    <span class="relative flex h-3 w-3">
                        <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-emerald-400 opacity-75"></span>
                        <span class="relative inline-flex rounded-full h-3 w-3 bg-emerald-500"></span>
                    </span>
                    <p class="text-sm text-emerald-800 font-medium">Referred by <span class="uppercase font-bold"><?php echo e(session()->get('reference')); ?></span></p>
                </div>
            <?php endif; ?>

            <form action="<?php echo e(route('user.register')); ?>" method="POST" class="space-y-6 verify-gcaptcha">
                <?php echo csrf_field(); ?>
                
                <div class="grid grid-cols-2 gap-4">
                    <div class="space-y-1">
                        <label class="text-sm font-medium text-slate-700">First Name</label>
                        <input type="text" name="firstname" value="<?php echo e(old('firstname')); ?>" required 
                            class="w-full px-4 py-3 rounded-xl border border-slate-200 focus:outline-none focus:border-emerald-500 focus:ring-4 focus:ring-emerald-500/5 transition-all" placeholder="John">
                    </div>
                    <div class="space-y-1">
                        <label class="text-sm font-medium text-slate-700">Last Name</label>
                        <input type="text" name="lastname" value="<?php echo e(old('lastname')); ?>" required 
                            class="w-full px-4 py-3 rounded-xl border border-slate-200 focus:outline-none focus:border-emerald-500 focus:ring-4 focus:ring-emerald-500/5 transition-all" placeholder="Doe">
                    </div>
                </div>

                <div class="space-y-1">
                    <label class="text-sm font-medium text-slate-700">Email Address</label>
                    <input type="email" name="email" value="<?php echo e(old('email')); ?>" required 
                        class="checkUser w-full px-4 py-3 rounded-xl border border-slate-200 focus:outline-none focus:border-emerald-500 focus:ring-4 focus:ring-emerald-500/5 transition-all" placeholder="name@example.com">
                </div>

                <div class="grid grid-cols-2 gap-4">
                    <div class="space-y-1">
                        <label class="text-sm font-medium text-slate-700">Password</label>
                        <input type="password" name="password" required 
                            class="w-full px-4 py-3 rounded-xl border border-slate-200 focus:outline-none focus:border-emerald-500 focus:ring-4 focus:ring-emerald-500/5 transition-all <?php if(gs('secure_password')): ?> secure-password <?php endif; ?>" placeholder="••••••••">
                    </div>
                    <div class="space-y-1">
                        <label class="text-sm font-medium text-slate-700">Confirm</label>
                        <input type="password" name="password_confirmation" required 
                            class="w-full px-4 py-3 rounded-xl border border-slate-200 focus:outline-none focus:border-emerald-500 focus:ring-4 focus:ring-emerald-500/5 transition-all" placeholder="••••••••">
                    </div>
                </div>

                <div class="pt-2">
                    <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
                </div>

                <?php if(gs('agree')): ?>
                <label class="relative flex items-start group cursor-pointer">
                    <div class="flex items-center h-5">
                        <input id="agree" name="agree" type="checkbox" required class="h-5 w-5 rounded border-slate-300 text-emerald-600 focus:ring-emerald-500 transition-all">
                    </div>
                    <div class="ml-3 text-sm leading-5">
                        <span class="text-slate-600">I accept the 
                            <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e(route('policy.pages', $policy->slug)); ?>" target="_blank" class="text-emerald-600 font-semibold hover:underline"><?php echo e(__($policy->data_values->title)); ?></a><?php if(!$loop->last): ?>, <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </span>
                    </div>
                </label>
                <?php endif; ?>

                <button type="submit" class="w-full bg-slate-900 text-white py-4 rounded-xl font-bold text-lg shadow-xl shadow-slate-200 hover:bg-slate-800 active:scale-[0.98] transition-all flex items-center justify-center gap-2">
                    Create Account
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/></svg>
                </button>
            </form>
        </div>
    </div>

    <div class="hidden lg:flex flex-1 relative bg-slate-900 overflow-hidden">
        <div class="absolute inset-0 z-0">
            <div class="absolute top-[-10%] left-[-10%] w-[50%] h-[50%] bg-emerald-600/20 blur-[120px] rounded-full"></div>
            <div class="absolute bottom-[-10%] right-[-10%] w-[50%] h-[50%] bg-blue-600/10 blur-[120px] rounded-full"></div>
        </div>

        <div class="relative z-10 flex flex-col justify-center px-20">
            <div class="max-w-md">
                <div class="inline-flex items-center px-3 py-1 rounded-full bg-white/10 border border-white/20 text-emerald-400 text-xs font-bold uppercase tracking-widest mb-6">
                    Join 50k+ Investors
                </div>
                <h2 class="text-5xl font-bold text-white leading-tight mb-8">Invest in the future with <span class="text-emerald-400 italic">confidence.</span></h2>
                
                <div class="space-y-8">
                    <div class="flex gap-4">
                        <div class="flex-shrink-0 w-12 h-12 bg-white/5 border border-white/10 rounded-2xl flex items-center justify-center">
                            <svg class="w-6 h-6 text-emerald-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/></svg>
                        </div>
                        <div>
                            <h4 class="text-white font-bold">Institutional Security</h4>
                            <p class="text-slate-400 text-sm mt-1">Your assets are protected by industry-leading encryption and multi-sig vaults.</p>
                        </div>
                    </div>
                    <div class="flex gap-4">
                        <div class="flex-shrink-0 w-12 h-12 bg-white/5 border border-white/10 rounded-2xl flex items-center justify-center">
                            <svg class="w-6 h-6 text-emerald-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/></svg>
                        </div>
                        <div>
                            <h4 class="text-white font-bold">Automated ROI</h4>
                            <p class="text-slate-400 text-sm mt-1">Our system manages compound interest so you don't have to lift a finger.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
    <?php echo $__env->make('partials.notify', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

</body>
</html>
<?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/auth/register.blade.php ENDPATH**/ ?>